#include <stdio.h>
#include <strings.h>

typedef unsigned short WORD;

int main(int argc,char **argv)
{
    FILE *input, *output;
    char Buffer[4096],stringa[4096],stringb[4096];
    int icount = 0;
    if (!(input = fopen("../acronyms.txt", "r")))
    {
        fprintf(stderr,"Input File not found\r\n");
        return -2;
    }
    /* Open output file */
    if (!(output = fopen("../dic/acronyms.dic", "wb")))
    {
        fprintf(stderr,"Unable to open outfile\r\n");
        fclose(input);
        return -3;
    }
    
    while (fgets(Buffer,sizeof(Buffer),input))
    {
        if (sscanf(Buffer,"%s %s",stringa,stringb)!=2)
        {
            fprintf(stderr,"error when read data\r\n");
            return -4;
        }
        char * meaning = Buffer+strlen(stringa)+1;
        while( *meaning==' ' || *meaning=='\t' )
            meaning++;
        char * end = meaning;
        while (*end != '\r' && *end!= '\n' )
            end++;
        *end = '\0';
        
        fwrite(stringa,strlen(stringa)+1,sizeof(char),output);
        fwrite(meaning,strlen(meaning)+1,sizeof(char),output);
        icount ++;
    }
    
    fwrite(&icount,sizeof(int),1,output);
    int style= (0<<24) + (0<<16) + (0<<8) + 0;
    fwrite(&style,sizeof(int),1,output);
    
    fclose(input);
    fclose(output);
}
