/*
    writer : Ma Su An
    E-Mail : msa@wri.com.cn
    
    Copyright by Ma Su An.
    All rights reserved.
    Permission to use ,copy,modify,and distribute this software for
    individual use and without fee is granted with that condition:

        Every copy of this software must have the writer's name displayed 
    on the top label.
*/

// filename: trans.cc
// msa 1999.1

#include "trans.h"
#include "image.h"
#include "getini.h"
#include "distance.h"
#include "XErrorHandler.h"
#include <locale.h>
#include <sys/types.h>
#include <sys/stat.h>


#define PREF_FILE_NAME ".stardic"

const char* const TOPLABEL_S="    " VERSION "   :      ޸:  ";

const char* const LIC_INFO_S="\
    Ȩ    1999    հ \n\
    Ȩû    2002     \n\
    Ϊ\n\
GNUͨù\n\
޸ĺ·һ,\n\
֤ڶ棬ߣѡ\n\
θµİ汾\n\
    ߲֤ƴд\n\
ȷԡ\n ";

const char* const HELP_MESS_S="\
    ӭʹáǼ\n\
ǼX-Window\n\
Ӣ/ӢֵСƥ\n\
䡱Ļѡȡģѯǿ\n\
ܡ\n\
\n\
    ֽ书ܼʹ÷˵£\n\
\n\
    1.ƥ (Ӣ)\n\
    ûС*͡\n\
ַΪƥ򡣡*ʾ\n\
ַʾĳһַ»س\n\
ұߵбмƥ\n\
ĵʡڲÿǵ\n\
ʾһͬʱڴĴ\n\
ʾһʵ塣\n\
\n\
    2.ģƥ (Ӣ)\n\
    ǲĳʵľƴдʱ,\n\
ʹñǵģƥ䷽ʽ,˷ʽ\n\
Levenshtein Edit Distance\n\
ʵƶ,뵥\n\
Ƶƥ,ֻ鵥ǰһ\n\
\"\\\", س.\n\
\n\
    3.ȫ\n\
    ڴǵҲ\n\
,һȫ,Ϊ\n\
ǵ䷶Χ,ֻ\n\
鵥ǰһ\"/\", س.\n\
\n\
    4.Ļѡȡ\n\
    ´·СĻѡȡ\n\
ƹҰťĻѡȡ״̬û\n\
Ļѡȡ\n\
˫סʹʴ\n\
״̬ڴ˵ʸᵯһ\n\
,ʾ˵ʵ塣˹֧\n\
ڡnetscapeAcrobatȡ\n\
\n\
    5.ƴǵ\n\
    ;Ӻƴ(\n\
), бѡӦĴʼ.\n\
\n\
    6.ʹб\n\
    беĿΪ鵥\n\
ɵʣڹƥ״̬ʾ\n\
ƥɵʡ\n\
\n\
    7.߼\n\
    һЩֻܿ\n\
,ļΪûhomeĿ¼\n\
\".stardic\"(û봴),ǵ\n\
config.pl޸еѡ,\n\
ʽΪ:\n\
ѡ                               ȱʡֵ\n\
UseChineseFT         ʹ÷ʾ    0\n\
MinimizeAtStart      ʱС      0\n\
FloatShowLevel       ʾ  1\n\
BackgroundPixmapFile ͼƬ          ݱԶѡ\n\
\n\
FloatShowLevel:\n\
ֵ         סalt    סaltshift\n\
0   дǵ   һǵ   һǵ\n\
1   һǵ дǵ     һǵ\n\
2   ʾ     дǵ     һǵ\n\
3   ʾ     һǵ   дǵ\n\
\n\
ڸʾʱ, ڽ\n\
,ٴε,\n\
ͨ϶ƶ.\n\
\n\
ǵȼ:\n\
ָĳǵȼȷʾ˳\n\
ߣΪ˼ڴռ,ǿнֹ\n\
ĳЩǵ,xdict.dic=20,cdict.dic=30,\n\
trans.dic=0,ָxdictȼǰ,\n\
ֹtrans.dic,Ŀǰ,7ǵ,\n\
ֱ:\n\
1: stardicӢǵ,51227.\n\
2: xdictӢǵ,177849.\n\
3: cdict5Ӣǵ,57540,ϸͺ.\n\
4: CEDICTӢǵ,21439.\n\
5: CEDICTƴǵ,21429.\n\
6: xdictӢǵ,161007.\n\
7. acronymsǵ,138.\n\
ûԸԼҪѡ.\n\
\n\
    ߼:\n\
     հ,ҵйƼѧ\n\
ϵְֹ人ʵѧоԺ\n\
רҵµϵͳ\n\
     E-MAIL: msa@wri.com.cn\n\
     ,ҵ㽭ѧϢ\n\
ѧϵ. ĿǰĲ ^_^\n\
     E-MAIL: wangvisual AT sohu.com\n\n";

const char* const UNICODETOGB2312_FILE_S="table/Uni2GB.tab";
const char* const UNICODETOBIG5_FILE_S="table/Uni2BIG5.tab";
const char* const GB2312TOUNICODE_FILE_S="table/GB2Uni.tab";
const char* const BIG5TOGB2312_FILE_S="table/big2gb.table";     

//====================================================================
// global object

char IniFileName[PATH_MAX+1];
Boolean bUseChineseFT;
ConvertTable oUni2GBConvertTable,oGB2UniConvertTable,oUni2BIG5ConvertTable;
MapTable oBIG2GBMapTable;

Libs oLibs;

char sErrorMessage[MAX_STR_LEN+1];
char sExecDir[PATH_MAX+1];
PixmapClass *poBackImage;
bool bForegroundIsWhite;
AppFrame * pAppFrame;

#ifdef XmNrenderTable
XmRenderTable MyRenderTable;
#endif

char *fallback[]={
//    "*background:black",
//    "*foreground:white",
#ifdef XmNrenderTable
#else
    "*wordtext*fontList:9x15bold",
    "*fontList:9x15bold=English,hz16=Chinese,hz16ft=ChineseFT,yb10x20=YB,9x15bold=PY,9x15bold=LibName",
#endif            
    "*transrc.minWidth:100",
    "*transrc.maxWidth:1000",
    "*transrc.minHeight:50",
    "*transrc.maxHeight:1000",
    "*transrc.title:Star Dictionary " VERSION DEBUGVERSION,
    NULL};

//===================================================================
        
//===================================================================

//===================================================================

//===================================================================
FloatWin::FloatWin(AppCore* pAppCore)
{
    poAppCore = pAppCore;
    wLabel=NULL;
    wShell=NULL;
    bMapped=False;
    xmsSavedMessage=NULL;
    GetIntFromIni(IniFileName,"FloatShowLevel",&iFloatShowLevel,FLOAT_SHOW_LEVEL_ONLYFIRST);
    oSavedWordItem=new WordItem*[oLibs.iGetTotalLibs()];
    memset(oSavedWordItem,0,oLibs.iGetTotalLibs()*sizeof(WordItem*));
    bHaveScrollBar=bInMoving=bIsLocked=bIsSavedWordItemValid=bIsSavedMessageValid=false;
    iSavedShowStates = FLOAT_SHOW_LEVEL_NONE;
    sSavedWords[0] = '\0';
}

/********************************************************************/
FloatWin::~FloatWin()
{
    if (xmsSavedMessage)
        XmStringFree(xmsSavedMessage);
    if(wShell!=NULL)
        XtDestroyWidget(wShell);
    if (oSavedWordItem)
        delete [] oSavedWordItem;
}

/********************************************************************/
void FloatWin::vSetBackground(Pixmap pixBack)
{
    XtVaSetValues(wLabel,
        XmNbackgroundPixmap,pixBack,
        NULL);
    
    XtVaSetValues(wFuzzyFind,
        XmNbackgroundPixmap,pixBack,
        NULL);

    Widget wHScrollBar,wVScrollBar;
    Widget wClipWin;
    XtVaGetValues(wScrolledWin,
        XmNhorizontalScrollBar,&wHScrollBar,
        XmNverticalScrollBar,&wVScrollBar,
        XmNclipWindow,&wClipWin,
        NULL);
    XtVaSetValues(wClipWin,
        XmNbackgroundPixmap,pixBack,
        NULL);
    XtVaSetValues(wHScrollBar,
        XmNbackgroundPixmap,pixBack,
        NULL);
    XtVaSetValues(wVScrollBar,
        XmNbackgroundPixmap,pixBack,
        NULL);
    XtVaSetValues(wScrolledWin,
        XmNbackgroundPixmap,pixBack,
        NULL);
}

int FloatWin::iGetShowLevel()
{
    if (bIsLocked)
        return iSavedShowStates;
    
    // Check the Mask's states
    Window rootwindow,child;
    int winx,winy,iX,iY;
    unsigned int mask;
    Display *display=XtDisplay(wLabel);
    XQueryPointer( display,DefaultRootWindow(display),&rootwindow,
                  &child,&iX,&iY,&winx,&winy,&mask );
//    printf("mask:%d %d %d %d %d\n",mask,Mod1Mask,Mod2Mask,Mod4Mask,ShiftMask);
    if ( (mask&Mod4Mask) == Mod4Mask )  //Meta Pressed
    {
        bIsSavedWordItemValid = bIsSavedMessageValid = false;
        sSavedWords[0]='\0';
        return FLOAT_SHOW_LEVEL_NONE;
//        printf("Meta Pressed\n");
    }
    switch ( iFloatShowLevel )
    {
        case FLOAT_SHOW_LEVEL_ALL:
            if ( ((mask&Mod1Mask)==Mod1Mask) || ((mask&Mod2Mask)==Mod2Mask) )
                return FLOAT_SHOW_LEVEL_ONLYFIRST;
            else
                return FLOAT_SHOW_LEVEL_ALL;
        case FLOAT_SHOW_LEVEL_ONLYFIRST:
        case FLOAT_SHOW_LEVEL_NONE:
            if ( ((mask&Mod1Mask)==Mod1Mask) || ((mask&Mod2Mask)==Mod2Mask) )
                if ( (mask&ShiftMask)==ShiftMask )
                    return FLOAT_SHOW_LEVEL_ONLYFIRST;
                else
                    return FLOAT_SHOW_LEVEL_ALL;
            else
                return iFloatShowLevel;
        case FLOAT_SHOW_LEVEL_NONE_ONLYFIRST:
            if ( ((mask&Mod1Mask)==Mod1Mask) || ((mask&Mod2Mask)==Mod2Mask) )
                if ( (mask&ShiftMask)==ShiftMask )
                    return FLOAT_SHOW_LEVEL_ALL;
                else
                    return FLOAT_SHOW_LEVEL_ONLYFIRST;
            else
                return FLOAT_SHOW_LEVEL_NONE;
        default:
                assert(0);
    }
    return FLOAT_SHOW_LEVEL_NONE;
}

/********************************************************************/
void FloatWin::vShow(const char * sWord, const XmString xmsMessage,const Boolean ShowFuzzyFindButton)
{
    if (xmsSavedMessage)
    {
        XmStringFree(xmsSavedMessage);
        xmsSavedMessage = NULL;
    }
    bIsSavedWordItemValid=false;
    if ( xmsMessage==NULL || sWord==NULL )
    {
        if ( !bIsLocked && bMapped )
        {
            bIsSavedMessageValid=false;
            sSavedWords[0]='\0';
            iSavedShowStates = FLOAT_SHOW_LEVEL_NONE;
            vPopdown();
        }
        return;
    }
    if (ShowFuzzyFindButton)
        strcpy(sSavedWords,sWord);
    else
        sSavedWords[0]='\0';
    xmsSavedMessage=XmStringCopy(xmsMessage);
    bIsSavedMessageValid=true;
    vRecordXY();
    vPopdown();
    XtVaSetValues(wLabel,XmNlabelString,xmsSavedMessage,NULL);
    iSavedShowStates = iGetShowLevel();
    if ( iSavedShowStates == FLOAT_SHOW_LEVEL_NONE )
        return;
    else
        iSavedShowStates = FLOAT_SHOW_LEVEL_ALL;
    vPopup();
    return;
}

void FloatWin::vShow(const WordItem ** ppWordToShow)
{
    if (xmsSavedMessage)
    {
        XmStringFree(xmsSavedMessage);
        xmsSavedMessage = NULL;
    }
    bIsSavedMessageValid=false;
    sSavedWords[0]='\0';
    memcpy(oSavedWordItem,ppWordToShow,oLibs.iGetTotalLibs()*sizeof(WordItem*));
    bIsSavedWordItemValid=true;
    vRecordXY();
    vPopdown();
    iSavedShowStates = iGetShowLevel();
    XmString * pxmsMessage = poAppCore->oWordsToShow(oSavedWordItem,False,iSavedShowStates==FLOAT_SHOW_LEVEL_ONLYFIRST);
    XtVaSetValues(wLabel,XmNlabelString,*pxmsMessage,NULL);
    XmStringFree(*pxmsMessage);
    delete pxmsMessage;
    if ( iSavedShowStates == FLOAT_SHOW_LEVEL_NONE )
        return;    
    vPopup();
    return;
}

/********************************************************************/
void FloatWin::vRecordXY()
{
    Window childwindow;
    vGetPointerXY(XtDisplay(wShell),iRecordX,iRecordY,childwindow);
    return;
}

/********************************************************************/
void FloatWin::vGoToRecordedXY()
{
    vGoTo(iRecordX,iRecordY);
    return;
}

/********************************************************************/
void FloatWin::vGoTo(int iX,int iY)
{
    int iRealX=iX+OFFSETX;
    int iRealY=iY+OFFSETY;

    Screen* screen=XtScreen(wShell);
    Dimension iScreenWidth=WidthOfScreen(screen);
    Dimension iScreenHeight=HeightOfScreen(screen);

    Dimension iWinWidth,iWinHeight;
    XtVaGetValues(wLabel,
        XmNwidth,&iWinWidth,
        XmNheight,&iWinHeight,
        NULL);
    
    iWinHeight += STICK_HEIGHT;
    
    bHaveScrollBar = false;    
    if ( iWinHeight > iScreenHeight )
    {
        iWinWidth += iScrollBarWidth+SCROLL_BAR_EXT_WIDTH;
        bHaveScrollBar = true;
    }
    if ( iWinWidth > iScreenWidth )
    {
        iWinHeight += iScrollBarHeight+SCROLL_BAR_EXT_WIDTH;
        bHaveScrollBar = true;
    }

    if(iRealX+iWinWidth>iScreenWidth) iRealX=iScreenWidth-iWinWidth;
    if(iRealY+iWinHeight>iScreenHeight) iRealY=iScreenHeight-iWinHeight;
    
    if (iRealX<0) iRealX = 0;
    if (iRealY<0) iRealY = 0;

    int iSetWinWidth,iSetWinHeight;
    iSetWinWidth = iWinWidth>iScreenWidth?iScreenWidth:iWinWidth;
    iSetWinHeight = iWinHeight>iScreenHeight?iScreenHeight:iWinHeight;
    
    XtVaSetValues(wShell,
        XmNwidth,iSetWinWidth,
        XmNheight,iSetWinHeight,
        XmNx,iRealX,
        XmNy,iRealY,
        NULL);

    return;
}

/********************************************************************/
Widget FloatWin::wCreate(Widget wParent)
{
    wShell=XtVaCreateManagedWidget("floatwin",
        xmDialogShellWidgetClass,wParent,
        XmNmappedWhenManaged,False,
        XmNoverrideRedirect,True,   //If True, the widget is considered a temporary window that redirects the keyboard focus away from the main application windows.
        NULL);
        
    wForm=XtVaCreateManagedWidget("floatform",
        xmFormWidgetClass,wShell,
        XmNmarginWidth,0,
        XmNmarginHeight,0,
        NULL);
        
    wStick=XtVaCreateManagedWidget("stick",
        xmLabelWidgetClass,wForm,
        XmNalignment,XmALIGNMENT_BEGINNING,
        XmNlabelType,XmPIXMAP,
        NULL);
    
    wScrolledWin=XtVaCreateManagedWidget("floatscrolledWin",
        xmScrolledWindowWidgetClass,wForm,
        XmNscrollingPolicy,XmAUTOMATIC,
        XmNscrollBarPlacement,XmBOTTOM_LEFT,
        XmNshadowThickness,0,
        NULL);

    wLabel=XtVaCreateManagedWidget("floatlabel",
        xmLabelWidgetClass,wScrolledWin,
        XmNalignment,XmALIGNMENT_BEGINNING,
        XmNmarginTop,3,
        XmNmarginLeft,3,
        XmNmarginRight,3,
        XmNmarginBottom,2,
        NULL);
    
    wFuzzyFind=XtVaCreateManagedWidget("FuzzyFind",
        xmLabelWidgetClass,wForm,
        XmNalignment,XmALIGNMENT_BEGINNING,
        XmNmarginWidth,0,
        XmNmarginHeight,0,
        NULL);
    
#ifdef XmNrenderTable
    XtVaSetValues(wLabel,XmNrenderTable,MyRenderTable,NULL);
    XtVaSetValues(wFuzzyFind,XmNrenderTable,MyRenderTable,NULL);
#endif
    

    pixStick_no=pixGetPixmap(wStick,FLOAT_STICK_NO_S);
    pixStick_yes=pixGetPixmap(wStick,FLOAT_STICK_YES_S);

    XtVaSetValues(wStick,
        XmNtopAttachment,XmATTACH_FORM,
        XmNleftAttachment,XmATTACH_FORM,
        XmNrightAttachment,XmATTACH_FORM,
        XmNheight,STICK_HEIGHT,
        NULL);

    XtVaSetValues(wScrolledWin,
        XmNtopAttachment,XmATTACH_WIDGET,
        XmNtopWidget,wStick,
        XmNleftAttachment,XmATTACH_FORM,
        XmNrightAttachment,XmATTACH_FORM,
        XmNbottomAttachment,XmATTACH_FORM,
        NULL);
    
//    XmString msFuzzyFind = xmsCreateChinese("ģƥ");
    XmString msFuzzyFind = XmStringCreateLtoR("Fuzzy find","English");  // It's small than chinese ^_^
    XtVaSetValues(wFuzzyFind,
        XmNtopAttachment,XmATTACH_FORM,
        XmNleftAttachment,XmATTACH_FORM,
        XmNlabelString,msFuzzyFind,
        NULL);
    XmStringFree(msFuzzyFind);
    
    Pixmap pixFind=pixGetPixmap(wFuzzyFind,FUZZY_FIND_FILE_S);
    Pixmap pixFindMask=pixGetBitmap(wFuzzyFind,FUZZY_FIND_MASK_FILE_S);
    if( pixFind!=XmUNSPECIFIED_PIXMAP && pixFindMask!=XmUNSPECIFIED_PIXMAP )
    {
        XtVaSetValues(wFuzzyFind,
            XmNlabelPixmap,pixFind,
            XmNlabelType,XmPIXMAP,
            NULL);
        XShapeCombineMask(XtDisplay(wFuzzyFind),XtWindow(wFuzzyFind),
            ShapeBounding,0,0,pixFindMask,ShapeSet); // this offset is because of margin!
    }
    else
    {
#ifndef NDEBUG        
        vShowErrorToTerm("can't get find pixmap !\n");
#endif        
    }

    Widget wHScrollBar,wVScrollBar;
    XtVaGetValues(wScrolledWin,
        XmNhorizontalScrollBar,&wHScrollBar,
        XmNverticalScrollBar,&wVScrollBar,
        NULL);
    XtVaGetValues(wHScrollBar,
        XmNheight,&iScrollBarHeight,
        NULL);
    XtVaGetValues(wVScrollBar,
        XmNwidth,&iScrollBarWidth,
        NULL);

    XtAppAddTimeOut(XtWidgetToApplicationContext(wShell),
        FLOAT_TIMEOUT,vTimeOutCallback,this);
    
    XtAddEventHandler(wLabel,ButtonReleaseMask|ButtonPressMask,False,vButtonCallback,this);
    XtAddEventHandler(wStick,ButtonReleaseMask|ButtonPressMask,False,vButtonCallback,this);
    XtAddEventHandler(wFuzzyFind,ButtonReleaseMask|ButtonPressMask,False,vButtonCallback,this);
    return(wShell);
}

void FloatWin::vDrawStick()
{
    if (bIsLocked)
    {
        if ( pixStick_yes != XmUNSPECIFIED_PIXMAP )
            XtVaSetValues(wStick,XmNbackgroundPixmap,pixStick_yes,NULL);
        else
            XtVaSetValues(wStick,XmNbackground,"black",NULL);
    }
    else
    {
        if ( pixStick_no != XmUNSPECIFIED_PIXMAP )
            XtVaSetValues(wStick,XmNbackgroundPixmap,pixStick_no,NULL);
        else
            XtVaSetValues(wStick,XmNbackground,"white",NULL);
    }
    
    if ( sSavedWords[0] && !bIsChinese(sSavedWords[0]) )
        XtManageChild(wFuzzyFind);
    else
        XtUnmanageChild(wFuzzyFind);
}

void FloatWin::vButtonCallback(Widget w,XtPointer thisObj,XEvent* pEvent, Boolean* continue_to)
{
    ((FloatWin*)thisObj)->vButton(w,pEvent);
}

/********************************************************************/
void FloatWin::vTimeOutCallback(XtPointer thisObj,XtIntervalId *)
{
    ((FloatWin*)thisObj)->vTimeOut();
}

/********************************************************************/
void FloatWin::vTimeOut()
{
    unsigned int buttons;
    int iCurrentX,iCurrentY,winx,winy;
    Window wCurrentChildWindow,rootwindow;
    XQueryPointer(XtDisplay(wShell),DefaultRootWindow(XtDisplay(wShell)),&rootwindow,
        &wCurrentChildWindow,&iCurrentX,&iCurrentY,&winx,&winy,&buttons);
    int distance;
    Dimension Shell_x,Shell_y,Shell_width,Shell_height;
    XtVaGetValues(wShell,XmNx,&Shell_x,XmNy,&Shell_y,XmNwidth,&Shell_width,XmNheight,&Shell_height,NULL);

    if( !bIsLocked && !bInMoving && (bMapped || bIsSavedWordItemValid || bIsSavedMessageValid) )
    {
        if ( wCurrentChildWindow == XtWindow(wShell) )
            vRecordXY();
        else
        {
            if ( bMapped )
            {
                if ( iCurrentX < Shell_x )
                {
                    distance = (iCurrentX-Shell_x)*(iCurrentX-Shell_x);
                    if ( iCurrentY < Shell_y )
                         distance += (iCurrentY-Shell_y)*(iCurrentY-Shell_y);
                    else if ( iCurrentY > Shell_y+Shell_height )
                        distance += (iCurrentY-Shell_y-Shell_height)*(iCurrentY-Shell_y-Shell_height);
                }
                else if ( iCurrentX > Shell_x+Shell_width )
                {
                    distance = (iCurrentX-Shell_x-Shell_width)*(iCurrentX-Shell_x-Shell_width);
                    if ( iCurrentY < Shell_y )
                         distance += (iCurrentY-Shell_y)*(iCurrentY-Shell_y);
                    else if ( iCurrentY > Shell_y+Shell_height )
                        distance += (iCurrentY-Shell_y-Shell_height)*(iCurrentY-Shell_y-Shell_height);
                }
                else
                {
                    if ( iCurrentY < Shell_y )
                        distance = (iCurrentY-Shell_y)*(iCurrentY-Shell_y);
                    else
                        distance = (iCurrentY-Shell_y-Shell_height)*(iCurrentY-Shell_y-Shell_height);
                }
            } //end of bMapped
            else
                distance = (iCurrentX-iRecordX)*(iCurrentX-iRecordX) + (iCurrentY-iRecordY)*(iCurrentY-iRecordY);
            if ( distance > DISAPPEAR_DISTANCE )
            {
                bIsSavedWordItemValid = false;
                bIsSavedMessageValid = false;
                sSavedWords[0]='\0';
                iSavedShowStates = FLOAT_SHOW_LEVEL_NONE;
                vPopdown();
            }
        } // not in wShell
    } // to be hidden

    if ( (bIsSavedWordItemValid||bIsSavedMessageValid)
          && !bIsLocked && !bInMoving )
    {
        int iCurrentShowStates = iGetShowLevel();
        if ( bIsSavedMessageValid && iCurrentShowStates!=FLOAT_SHOW_LEVEL_NONE)
            iCurrentShowStates = FLOAT_SHOW_LEVEL_ALL;
        if ( iCurrentShowStates==FLOAT_SHOW_LEVEL_NONE && bMapped && bHaveScrollBar && wCurrentChildWindow==XtWindow(wShell) )
        {
            if ( iCurrentX<=Shell_x+iScrollBarWidth || (buttons&Button1Mask)==Button1Mask )
                iCurrentShowStates = iSavedShowStates;
        }
        if ( iCurrentShowStates != iSavedShowStates )
        {
            vPopdown();
            if ( iCurrentShowStates != FLOAT_SHOW_LEVEL_NONE )
            {
                if ( bIsSavedWordItemValid )
                {
                    XmString * pxmsMessage = poAppCore->oWordsToShow(oSavedWordItem,False,iCurrentShowStates==FLOAT_SHOW_LEVEL_ONLYFIRST);
                    XtVaSetValues(wLabel,XmNlabelString,*pxmsMessage,NULL);
                    XmStringFree(*pxmsMessage);
                    delete pxmsMessage;
                }
                if ( bIsSavedMessageValid )
                {
                    //XtVaSetValues(wLabel,XmNlabelString,xmsSavedMessage,NULL); 
                }
                vPopup();
            }
            iSavedShowStates = iCurrentShowStates;
        }
    }

    XtAppAddTimeOut(XtWidgetToApplicationContext(wShell),
        FLOAT_TIMEOUT,vTimeOutCallback,this);
    return;
}

void FloatWin::vButton(Widget w,XEvent * pEvent)
{
    if ( w == wFuzzyFind )
    {
        if ( pEvent->xbutton.type == ButtonRelease )
        {
            Cursor oWaitCursor = XCreateFontCursor(XtDisplay(wShell),XC_watch);
            XDefineCursor(XtDisplay(wShell),XtWindow(wShell),oWaitCursor);
            poAppCore->vLookupWithFuzzyToFloatWin(sSavedWords);
            XUndefineCursor(XtDisplay(wShell),XtWindow(wShell));
            XFreeCursor(XtDisplay(wShell),oWaitCursor);
        }
        return;
    }
    if ( pEvent->xbutton.type == ButtonPress )
    {
        Cursor oMoveCursor = XCreateFontCursor(XtDisplay(wShell),XC_fleur);
        XDefineCursor(XtDisplay(wShell),XtWindow(wShell),oMoveCursor);
        // Check the Mask's states
        Window rootwindow,child;
        int winx,winy,iX,iY,last_X,last_Y;
        unsigned int mask;
        bool bMoved = false;
        Display *display=XtDisplay(wShell);
        XQueryPointer( display,DefaultRootWindow(display),&rootwindow,
                  &child,&iX,&iY,&winx,&winy,&mask );
        if ( (mask&Button1Mask) != Button1Mask )
        {
            XUndefineCursor(XtDisplay(wShell),XtWindow(wShell));
            XFreeCursor(XtDisplay(wShell),oMoveCursor);
            return;
        }
        last_X=iX;last_Y=iY;
        bInMoving = true;

        Dimension offsetx,offsety;
        XtVaGetValues(wShell,XmNx,&offsetx,XmNy,&offsety,NULL);
        offsetx=iX-offsetx;offsety=iY-offsety;
        while ( (mask&Button1Mask) == Button1Mask )
        {
            if ( last_X!=iX || last_Y!=iY )
            {
                XtVaSetValues( wShell,XmNx,iX-offsetx,XmNy,iY-offsety,NULL );
                last_X=iX;last_Y=iY;
                bMoved = true;
            }
            XQueryPointer( display,DefaultRootWindow(display),&rootwindow,
                           &child,&iX,&iY,&winx,&winy,&mask );
            poAppCore->vProcessXEvent();
        }
        //released button1
        bInMoving = false;
        if ( !bMoved )
        {
                bIsLocked = !bIsLocked;
                vDrawStick();
                if (!bIsLocked)
                    vRecordXY();
        }
        XUndefineCursor(XtDisplay(wShell),XtWindow(wShell));
        XFreeCursor(XtDisplay(wShell),oMoveCursor);
    }
    else if ( pEvent->xbutton.type == ButtonRelease )
    {
        if ( (pEvent->xbutton.state&Button3Mask) == Button3Mask )
            poAppCore->vPopup();
    }
}

/********************************************************************/
void FloatWin::vPopup()
{
    vRecordXY();
    XtManageChild(wLabel);
    vGoToRecordedXY(); // must be here (after XtManageChild).
    vDrawStick();
    XMapRaised(XtDisplay(wShell),XtWindow(wShell));
    XFlush(XtDisplay(wShell));
    bMapped=True;
    return;
}

/********************************************************************/
void FloatWin::vPopdown()
{
    XtUnmapWidget(wShell);
    XtUnmanageChild(wLabel);
    bMapped=False;
}

//===================================================================
HistoryList::HistoryList(AppCore* pAppCore)
{
    poAppCore=pAppCore;
}

#ifdef ALL_BG_PIXMAP
void HistoryList::vSetBackground(Pixmap pixBack)
{
    XtVaSetValues(wList,
        XmNbackgroundPixmap,pixBack,
        NULL);
}
#endif

/********************************************************************/
Widget HistoryList::wCreate(Widget wParent)
{
    wList=XtVaCreateWidget("list",
                xmListWidgetClass,wParent,
                XmNselectionPolicy,XmSINGLE_SELECT,
                XmNvisibleItemCount,1,
                XmNtraversalOn,False,
                NULL);
#ifdef XmNrenderTable
    XtVaSetValues(wList,XmNrenderTable,MyRenderTable,NULL);
#endif    

    XtAddCallback(wList,XmNsingleSelectionCallback,vChooseCallback,this);
    XtAddEventHandler( wList,ButtonReleaseMask|ButtonPressMask,False,
                       vButtonEventCallback,this );

    return(wList);
}
        
/********************************************************************/
void HistoryList::vChooseCallback(Widget,XtPointer thisObj,XtPointer cbs)
{
    XmListCallbackStruct *pCbs=(XmListCallbackStruct *)cbs;
    ((HistoryList*)thisObj)->vChoose(pCbs->item);
}

/********************************************************************/
void HistoryList::vChoose(XmString xmsWord)
{
    char *text;
    XmStringGetLtoR(xmsWord,"English",&text);
    if ( text == NULL )
    {
        char * pChineseText;
        XmStringGetLtoR(xmsWord,(char *)(bUseChineseFT?"ChineseFT":"Chinese"),&pChineseText);
        text = sReturnTo1Byte(pChineseText);
        poAppCore->vHistoryChoose(text);
        vPopdown();
        delete [] text;
        XtFree(pChineseText);
        return;
    }
    poAppCore->vHistoryChoose(text);
    XtFree(text);
    vPopdown();
}

/********************************************************************/
void HistoryList::vButtonEventCallback(Widget ,XtPointer thisObj,XEvent* ,
    Boolean* continue_to)
{
    ((HistoryList*)thisObj)->vButtonEvent(continue_to);
    return;
}

/********************************************************************/
void HistoryList::vButtonEvent(Boolean* continue_to)
{
    Window root,child;
    int rootx,rooty,winx,winy;
    unsigned int buttons;

    XQueryPointer(XtDisplay(wList),XtWindow(XtParent(wList)),&root,&child,
        &rootx,&rooty,&winx,&winy,&buttons);
    if(child!=XtWindow(wList))
    {
        *continue_to=False;
        vPopdown();
    }

    return;
}

/********************************************************************/
void HistoryList::vPopup()
{
    int iVisibleNum;
    if(iLength()==0)
        iVisibleNum=1;
    else
        iVisibleNum=iLength();

    XtVaSetValues(wList,
        XmNvisibleItemCount,iVisibleNum,
        NULL);

    XtManageChild(wList);
    XRaiseWindow(XtDisplay(wList),XtWindow(wList));
    XtGrabPointer(wList,False,ButtonPressMask|ButtonReleaseMask,
        GrabModeAsync,GrabModeAsync,None,None,CurrentTime);
    return;
}

/********************************************************************/
void HistoryList::vPopdown()
{
    XtUngrabPointer(wList,CurrentTime);
    XtUnmanageChild(wList);
}

/********************************************************************/
void HistoryList::vToggle()
{
    if(XtIsManaged(wList))
    {
        vPopdown();
    }
    else
    {
        vPopup();
    }

    return;
}

/********************************************************************/
/*
int HistoryList::iVisibleCount()
{
    int iCount;
    XtVaGetValues(wList,
        XmNvisibleItemCount,&iCount,
        NULL);
    return(iCount);
}
*/
        
/********************************************************************/
int HistoryList::iLength()
{
    int iCount;
    XtVaGetValues(wList,
        XmNitemCount,&iCount,
        NULL);
    return(iCount);
}

/********************************************************************/
void HistoryList::vInsert(const char* sNewItem)
{
    if(iLength()>=MAX_HIS_NUM) XmListDeletePos(wList,0);

    XmString xmsItem;
    if ( bIsChinese(sNewItem[0])
         || ( (sNewItem[0]=='!'||sNewItem[0]=='/') && strlen(sNewItem)>=2 && bIsChinese(sNewItem[1]) ) )
        xmsItem = xmsCreateChinese((char *)sNewItem);
    else
        xmsItem = XmStringCreateLtoR((char *)sNewItem,"English");
    if(!XmListItemExists(wList,xmsItem))
    {
        XmListAddItem(wList,xmsItem,1);
    }
    XmStringFree(xmsItem);
}

//===================================================================
UserWin::UserWin(AppCore *pAppCore):oHistoryList(pAppCore)
{
    poAppCore=pAppCore;
    return;
}

/********************************************************************/
Widget UserWin::wCreate(Widget wParent)
{
    Widget wForm=XtVaCreateManagedWidget("messageform",
                xmFormWidgetClass,wParent,
                XmNmarginWidth,2,
                XmNmarginHeight,2,
                XmNshadowType,XmSHADOW_OUT,
                XmNshadowThickness,0,
                XmNverticalSpacing,2,
                NULL);

    Widget wHistoryList=oHistoryList.wCreate(wForm);

    Widget wTextForm=XtVaCreateManagedWidget("textform",
                xmFormWidgetClass,wForm,
                XmNshadowThickness,0,
                NULL);

    wWordText=XtVaCreateManagedWidget("wordtext",
                xmTextFieldWidgetClass,wTextForm,
                XmNhighlightThickness,1,
                NULL);
#ifdef XmNrenderTable
    XtVaSetValues(wWordText,XmNrenderTable,MyRenderTable,NULL);
#endif    
    XtAddCallback(wWordText,XmNvalueChangedCallback,
        vWordChangeCallback,this);
    XtAddCallback(wWordText,XmNactivateCallback,
        vEnterWordCallback,this);

    wArrow=XtVaCreateManagedWidget("arrow",
        xmArrowButtonWidgetClass,wTextForm,
        XmNarrowDirection,XmARROW_DOWN,
        XmNhighlightThickness,0,
        XmNtraversalOn,False,
        NULL);
    XtAddCallback(wArrow,XmNactivateCallback,vArrowCallback,this);

    // set position in text form
    XtVaSetValues(wWordText,
        XmNtopAttachment,XmATTACH_FORM,
        XmNleftAttachment,XmATTACH_FORM,
        XmNrightAttachment,XmATTACH_WIDGET,
        XmNrightWidget,wArrow,
        XmNbottomAttachment,XmATTACH_FORM,
        NULL);
    XtVaSetValues(wArrow,
        XmNtopAttachment,XmATTACH_FORM,
        XmNrightAttachment,XmATTACH_FORM,
        XmNbottomAttachment,XmATTACH_FORM,
        NULL);

    Widget wSeparator=XtVaCreateManagedWidget("separator",
        xmSeparatorWidgetClass,wForm,
        XmNheight,3,
        NULL);

    Widget wMeaningWin=wCreateMeaningWin(wForm);

    // set position
    XtVaSetValues(wTextForm,
        XmNtopAttachment,XmATTACH_FORM,
        XmNleftAttachment,XmATTACH_FORM,
        XmNrightAttachment,XmATTACH_FORM,
        NULL);
    XtVaSetValues(wSeparator,
        XmNtopAttachment,XmATTACH_WIDGET,
        XmNtopWidget,wTextForm,
        XmNleftAttachment,XmATTACH_FORM,
        XmNrightAttachment,XmATTACH_FORM,
        NULL);
    XtVaSetValues(wMeaningWin,
        XmNtopAttachment,XmATTACH_WIDGET,
        XmNtopWidget,wSeparator,
    //    XmNtopWidget,wWordText,
        XmNleftAttachment,XmATTACH_FORM,
        XmNrightAttachment,XmATTACH_FORM,
        XmNbottomAttachment,XmATTACH_FORM,
        NULL);

    // History list position
    XtVaSetValues(wHistoryList,
        XmNtopAttachment,XmATTACH_WIDGET,
        XmNtopWidget,wTextForm,
        XmNleftAttachment,XmATTACH_FORM,
        XmNrightAttachment,XmATTACH_FORM,
        NULL);

    return(wForm);
}

/********************************************************************/
Widget UserWin::wCreateMeaningWin(Widget wParent)
{
    Widget wForm=XtVaCreateManagedWidget("messageform",
        xmFormWidgetClass,wParent,
        XmNmarginWidth,0,
        XmNmarginHeight,0,
        XmNshadowType,XmSHADOW_OUT,
        XmNshadowThickness,2,
        // XmNverticalSpacing,2,
        NULL);

    wWordLabel=XtVaCreateManagedWidget("wordlabel",
        xmLabelWidgetClass,wForm,
        XmNmarginWidth,15,
        XmNalignment,XmALIGNMENT_BEGINNING,
        NULL);
#ifdef XmNrenderTable
    XtVaSetValues(wWordLabel,XmNrenderTable,MyRenderTable,NULL);
#endif    

    Widget wScrolledWin=XtVaCreateManagedWidget("scrolledWin",
        xmScrolledWindowWidgetClass,wForm,
        XmNscrollingPolicy,XmAUTOMATIC,
        NULL);

    wMeaning=XtVaCreateManagedWidget("meaning",
        // xmLabelWidgetClass,wScrolledWin,
        xmPushButtonWidgetClass,wScrolledWin,
        XmNshadowThickness,0,
        XmNhighlightThickness,0,
        XmNmarginTop,10,
        XmNmarginLeft,10,
        XmNmarginRight,10,
        XmNmarginBottom,10,
        XmNalignment,XmALIGNMENT_BEGINNING,
                NULL);
#ifdef XmNrenderTable
    XtVaSetValues(wMeaning,XmNrenderTable,MyRenderTable,NULL);
#endif    

    XtAddCallback(wMeaning,XmNactivateCallback,
        vPressMeaningCallback,this);

    XtVaSetValues(wWordLabel,
        XmNtopAttachment,XmATTACH_FORM,
        XmNleftAttachment,XmATTACH_FORM,
        XmNrightAttachment,XmATTACH_FORM,
        NULL);
    XtVaSetValues(wScrolledWin,
        XmNtopAttachment,XmATTACH_WIDGET,
        XmNtopWidget,wWordLabel,
        XmNleftAttachment,XmATTACH_FORM,
        XmNrightAttachment,XmATTACH_FORM,
        XmNbottomAttachment,XmATTACH_FORM,
        NULL);

    return(wForm);
}

/********************************************************************/
Boolean UserWin::bTextSelected()
{
    XmTextPosition left,right;
    Boolean bSelected;
    bSelected=XmTextFieldGetSelectionPosition(wWordText,&left,&right);
    return(bSelected);
}

/********************************************************************/
void UserWin::vSetTextSelection()
{
    int iLastPosition=XmTextFieldGetLastPosition(wWordText);
    XmTextFieldSetSelection(wWordText,0,iLastPosition,CurrentTime);
    return;
}

void UserWin::vShowHelp()
{
    char* sAllMessage=new char[strlen(HELP_MESS_S)+strlen(LIC_INFO_S)
            +strlen("\nBuild at: ")+strlen(BUILD_DATE_S)
            +strlen("\nwith ")+strlen(XmVERSION_STRING)+1];
    strcpy(sAllMessage,HELP_MESS_S);
    strcat(sAllMessage,LIC_INFO_S);
    strcat(sAllMessage,"\nBuild at: ");
    strcat(sAllMessage,BUILD_DATE_S);
    strcat(sAllMessage,"\nwith ");
    strcat(sAllMessage,XmVERSION_STRING);
    vShowToMeaningWin(sAllMessage);
    vShowToLabel("");
    delete []sAllMessage;
}

/********************************************************************/
void UserWin::vActivateText()
{
    XmProcessTraversal(wWordText,XmTRAVERSE_CURRENT);
    return;
}

/********************************************************************/
void UserWin::vSetBackground(Pixmap pixBack)
{
    XtVaSetValues(wWordLabel,
        XmNbackgroundPixmap,pixBack,
        NULL);
    XtVaSetValues(XtParent(XtParent(wWordText)),
        XmNbackgroundPixmap,pixBack,
        NULL);
    XtVaSetValues(wArrow,
        XmNbackgroundPixmap,pixBack,
        NULL);

    Widget wHScrollBar,wVScrollBar,wClipWin;
    Widget wScrolledWin=XtParent(XtParent(wMeaning));
    XtVaGetValues( wScrolledWin,
        XmNclipWindow,&wClipWin,
        XmNhorizontalScrollBar,&wHScrollBar,
        XmNverticalScrollBar,&wVScrollBar,
        NULL);
    XtVaSetValues(wScrolledWin,
        XmNbackgroundPixmap,pixBack,
        NULL);
    XtVaSetValues(wHScrollBar,
        XmNbackgroundPixmap,pixBack,
        NULL);
    XtVaSetValues(wVScrollBar,
        XmNbackgroundPixmap,pixBack,
        NULL);
#ifdef ALL_BG_PIXMAP
    XtVaSetValues(wClipWin,
        XmNbackgroundPixmap,pixBack,
        NULL);
    XtVaSetValues(wMeaning,
        XmNbackgroundPixmap,pixBack,
        NULL);
    oHistoryList.vSetBackground(pixBack);
#endif    
}

/********************************************************************/
void UserWin::vInsertHisList(const char* sWord)
{
    oHistoryList.vInsert(sWord);
}

/********************************************************************/
void UserWin::vToggleHisList()
{
    oHistoryList.vToggle();
}

/********************************************************************/
void UserWin::vShowToLabel(const char* sWord)
{
    XmString xmsLabelString=xmsCreateChinese(sWord);
    XtVaSetValues(wWordLabel,
        XmNlabelString,xmsLabelString,
        NULL);
    XmStringFree(xmsLabelString);
}

/********************************************************************/
void UserWin::vShowToLabel(XmString xmsLabelString)
{
    XtVaSetValues(wWordLabel,
        XmNlabelString,xmsLabelString,
        NULL);
}

/********************************************************************/
void UserWin::vShowToMeaningWin(const char *sMessage)
{
    //XClearWindow(XtDisplay(wMeaning),XtWindow(wMeaning));
    XmString xmsString=xmsCreateChinese(sMessage);
    XtVaSetValues(wMeaning,
        XmNlabelString,xmsString,
        NULL);
    XmStringFree(xmsString);
    return;
}

void UserWin::vShowToMeaningWin(const XmString xmsMessage)
{
    XtVaSetValues(wMeaning,XmNlabelString,xmsMessage,NULL);
}

/********************************************************************/
void UserWin::vPutToText(const char *sWord)
{
    assert(sWord!=NULL);
    if(sWord==NULL) return;
#ifdef __linux__
    /* Workaround for the following bugs under linux:
        Name: wordtext
        Class: XmTextField
        Character '\xxx\xxx' not supported in font.  Discarded.
    */
    //XtVaSetValues(wWordText,XmNvalue,(char *)sWord,NULL);
    size_t len = mbstowcs(NULL,sWord,0)+1;
    wchar_t *wcstring = new wchar_t[len];
    mbstowcs(wcstring,sWord,len);
    XmTextFieldSetStringWcs(wWordText,wcstring);
    delete [] wcstring;
#else
    XmTextFieldSetString(wWordText,(char *)sWord);
#endif
}

/********************************************************************/
void UserWin::vClearMeaningWin()
{
    vShowToLabel("  ");
    vShowToMeaningWin(" ");
}

/********************************************************************/
void UserWin::vClearText()
{
    XmTextFieldSetString(wWordText,"");
}

/*typedef struct
{
    int     reason;
    XEvent  *event;
    int     click_count;
} XmPushButtonCallbackStruct;
*/
void UserWin::vPressMeaningCallback(Widget w, XtPointer thisObj, XtPointer call_data)
{
    XmPushButtonCallbackStruct *cbs = (XmPushButtonCallbackStruct *) call_data;
    ((UserWin *)thisObj)->poAppCore->vPressMeaning(cbs->event->xkey.time);
}

/********************************************************************/
void UserWin::vArrowCallback(Widget,XtPointer thisObj,XtPointer )
{
    ((UserWin *)thisObj)->poAppCore->vArrowActivate();
}

/********************************************************************/
void UserWin::vEnterWordCallback(Widget,XtPointer thisObj,XtPointer )
{
    ((UserWin *)thisObj)->vEnterWord();
}

/********************************************************************/
void UserWin::vEnterWord()
{
    char *sWord=XmTextFieldGetString(wWordText);
    if(sWord[0]!='\0')
        poAppCore->vUserWinEnterWord(sWord);
    XtFree(sWord);
}

/********************************************************************/
void UserWin::vWordChangeCallback(Widget,XtPointer thisObj,XtPointer )
{
    ((UserWin *)thisObj)->vWordChange();
}

/********************************************************************/
void UserWin::vWordChange()
{
    char *sWord=XmTextFieldGetString(wWordText);
    if(sWord[0]!='\0')
    {
        poAppCore->vUserWinWordChange(sWord,SEARCH_INDEX_DOWN,NULL);
    }
    else
    {
        vShowHelp();
    }

    XtFree(sWord);
}

/* Xlib and Xt are permitted to have different memory allocators, and in the
 * XtSelectionCallbackProc the client is instructed to free the selection
 * value with XtFree, so the selection value received from XGetWindowProperty
 * should be copied to memory allocated through Xt.  But copying is
 * undesirable since the selection value may be large, and, under normal
 * library configuration copying is unnecessary.
 */
inline void vFreeSelectionMemory(XtPointer memory)
{
    XtFree((char *)(memory));
}

/* From "Motif 2.1 Widget Writer's Guide":
PreferredTarget uses the following algorithm to determine which textual target to pick.
If the locale atom is present, the precedence order is as follows:
_MOTIF_COMPOUND_STRING > TEXT > COMPOUND_TEXT > locale atom > STRING
If the locale atom is not present, PreferredTargets uses this order:
_MOTIF_COMPOUND_STRING > COMPOUND_TEXT > STRING
I use the follows:
UTF8_STRING > TEXT > COMPOUND_TEXT > locale atom > STRING
*/
Atom Selection::TARGETS_Atom;
Atom Selection::UTF8_STRING_Atom;
Atom Selection::LOCALE_ENCODING_Atom;
Atom Selection::COMPOUND_TEXT_Atom;
Atom Selection::TEXT_Atom;

//===================================================================
Selection::Selection(AppCore* pAppCore)
{
    poAppCore=pAppCore;
    cNoSelTimeCount=0;
    sLastClipWord[0]='\0';
    TARGETS_Atom=UTF8_STRING_Atom=LOCALE_ENCODING_Atom=COMPOUND_TEXT_Atom=TEXT_Atom=(Atom)NULL;
    bIsEnding = false;
    cIsBusy = 0;
}

/********************************************************************/
Boolean Selection::bEnable()
{
    return(poAppCore->bScreenFetchEnable());
}

/********************************************************************/
void Selection::vStart(Widget wToUse)
{
    w=wToUse;
    UTF8_STRING_Atom = XmInternAtom(XtDisplay(w),"UTF8_STRING",False);
    TARGETS_Atom = XmInternAtom(XtDisplay(w),"TARGETS",False);
    LOCALE_ENCODING_Atom=GetLocaleEncodingAtom(XtDisplay(w));
    COMPOUND_TEXT_Atom = XmInternAtom(XtDisplay(w),"COMPOUND_TEXT",False);
    TEXT_Atom = XmInternAtom(XtDisplay(w),"TEXT",False);
#ifndef NDEBUG
    printf("Locale Encoding Atom: %s (%ld)\n",XGetAtomName(XtDisplay(w),LOCALE_ENCODING_Atom),LOCALE_ENCODING_Atom);
#endif
    XtAppSetSelectionTimeout(XtWidgetToApplicationContext(w),SELECTION_TIMEOUT);
    XtAppAddTimeOut(XtWidgetToApplicationContext(w),SELECTION_INTERVAL,vTimeOutCallback,this);
}

void Selection::vEnd()
{
    bIsEnding = true;
    time_t starttime = time(NULL);
    time_t currenttime;
    while ( cIsBusy )
    {
        currenttime = time(NULL);
        if ( currenttime-starttime > 5 )
            break;
        poAppCore->vProcessXEvent();
    }
}

/********************************************************************/
void Selection::vTimeOutCallback(XtPointer thisObj,XtIntervalId *)
{
    ((Selection *)thisObj)->vTimeOut();
        return;
}

/********************************************************************/
void Selection::vTimeOut()
{
    if ( bIsEnding )
        return;
    if( bEnable() )
    {
        if ( cIsBusy )
        {
            cIsBusy++;  // at most 256 times busy
            if ( cIsBusy*SELECTION_INTERVAL > 10000 )  //large than 10s,failed
                cIsBusy = 0;
        }
        else if ( XGetSelectionOwner(XtDisplay(w),XA_PRIMARY) != None )
        {
            cIsBusy = 1;
            XtGetSelectionValue(w,XA_PRIMARY,TARGETS_Atom,vSelectionTypeCallback,this,CurrentTime);
        }
        else    // no selection
        {
            cNoSelTimeCount++;
            if ( cNoSelTimeCount > MAX_NOSELTIME_COUNT )
            {
                sLastClipWord[0]='\0';
                cNoSelTimeCount = 0;
            }
        }
    }
    XtAppAddTimeOut(XtWidgetToApplicationContext(w),SELECTION_INTERVAL,vTimeOutCallback,this);
}

/********************************************************************/
void Selection::vSelectionTypeCallback(Widget wWidget,XtPointer thisObj,Atom * selection,
    Atom * type,XtPointer value,unsigned long *length,int *format)
{
    unsigned long count = *length;
    Atom * AtomList = (Atom *)value;
    bool utf8,text,compoundtext,localeencoding;
    utf8=text=compoundtext=localeencoding=false;

    // UTF8_STRING > TEXT > COMPOUND_TEXT > locale atom > STRING
    while ( count && AtomList )
    {
        if ( *AtomList )
        {
#if 0 && !(defined NDEBUG)
            printf("Selection Type: %s (%ld)\n",XGetAtomName(XtDisplay(wWidget),*AtomList),*AtomList);
            if ( *AtomList == UTF8_STRING_Atom )
                utf8=true;
            else
#else
            if ( *AtomList == UTF8_STRING_Atom )
            {   utf8=true;break;}
#endif
            if ( *AtomList == TEXT_Atom )
                text=true;
            else if ( *AtomList == COMPOUND_TEXT_Atom )
                compoundtext=true;
            else if ( *AtomList == LOCALE_ENCODING_Atom )
                localeencoding=true;
        }
        AtomList++;count--;
    }
    if (utf8)
        XtGetSelectionValue(wWidget,XA_PRIMARY,UTF8_STRING_Atom,vSelectionCallback,thisObj,CurrentTime);
    else if (text)
        XtGetSelectionValue(wWidget,XA_PRIMARY,TEXT_Atom,vSelectionCallback,thisObj,CurrentTime);
    else if (compoundtext)
        XtGetSelectionValue(wWidget,XA_PRIMARY,COMPOUND_TEXT_Atom,vSelectionCallback,thisObj,CurrentTime);
    else if (localeencoding)
        XtGetSelectionValue(wWidget,XA_PRIMARY,LOCALE_ENCODING_Atom,vSelectionCallback,thisObj,CurrentTime);
    else
    // all those can't be found, use XA_STRING instead
    // or no selection or "TARGETS" was not supported by current selection owner!!!
        XtGetSelectionValue(wWidget,XA_PRIMARY,XA_STRING,vSelectionCallback,thisObj,CurrentTime);    
    
    vFreeSelectionMemory(value);
}

// typedef void (*XtSelectionCallbackProc)(
//     Widget /* widget */,
//     XtPointer       /* closure */,
//     Atom*       /* selection */,
//     Atom*       /* type */,
//     XtPointer       /* value */,
//     unsigned long*  /* length */,
//     int*        /* format */
// );

/********************************************************************/
void Selection::vSelectionCallback(Widget wWidget,XtPointer thisObj,Atom *,
    Atom * type,XtPointer value,unsigned long *length,int *)
{
#if 0 && !(defined NDEBUG)
    if (*length)
    {
        printf("Selection Atom Type: %s (%ld)\tLength:%ld\n",XGetAtomName(XtDisplay(wWidget),*type),*type,*length);
        for (unsigned int i=0;i<*length;i++)
            printf("%c ",*((unsigned char*)value+i));
        printf("\n");
        for (unsigned int i=0;i<*length;i++)
            printf("%x ",(int)(*((unsigned char*)value+i)));
        printf("\n");
    }
#endif

    int iStringType=STRING_TYPE_ASCII;
    int iActLen= *length;
    if ( !iActLen || !*type )
    {
        ((Selection *)thisObj)->cNoSelTimeCount++;
        if ( ((Selection *)thisObj)->cNoSelTimeCount > MAX_NOSELTIME_COUNT )
        {
            ((Selection *)thisObj)->sLastClipWord[0]='\0';
            ((Selection *)thisObj)->cNoSelTimeCount = 0;
        }
        vFreeSelectionMemory(value);
        ((Selection *)thisObj)->cIsBusy = 0;
        return;
    }
    ((Selection *)thisObj)->cNoSelTimeCount = 0;
    if (iActLen>=MAX_STR_LEN)
        iActLen=MAX_STR_LEN;

    if ( *type == UTF8_STRING_Atom )
    {
        // first change UTF8 string to GB/BIG5 code
        unsigned char * sGBCode = new unsigned char[iActLen+1];
        unsigned char * sGBWrite = sGBCode;
        unsigned char * sBIG5Code = new unsigned char[iActLen+1];
        unsigned char * sBIG5Write = sBIG5Code;
        int iGBCount=0, iBIG5Count=0;
        
        if ( !sGBCode || !sBIG5Code )
        {
            vFreeSelectionMemory(value);
            ((Selection *)thisObj)->cIsBusy = 0;
            return;
        }
        unsigned char * sUTF8 = (unsigned char *)value;
        while ( (sUTF8<(unsigned char *)value+*length) && (sGBWrite-sGBCode<iActLen) )
        {
            if ( ((*sUTF8) & 0x80) == 0 )     // first bit is 0, so it is ASCII
            {
                *sBIG5Write++ = *sGBWrite++ = *sUTF8++;
            }
            else if ( ((*sUTF8) & 0xe0) == 0xc0 ) // first word start with 110
            {
                assert(sUTF8+1<=(unsigned char *)value + *length);
                *sBIG5Write++ = *sGBWrite++ = ((*sUTF8)&0x1f)>>2;
                *sBIG5Write++ = *sGBWrite++ = (*sUTF8)<<6 | (*(sUTF8+1)&0x3f) ;
                sUTF8++;sUTF8++;
            }
            else if ( ((*sUTF8) & 0xf0) == 0xe0 ) // first word start with 1110, CKJ characters
            {
                BYTE high,low;
                assert(sUTF8+2<=(unsigned char *)value + *length);
                high = ((*sUTF8)<<4) | (((*(sUTF8+1))>>2)&0x0f);
                low = ((*(sUTF8+1))<<6) | ((*(sUTF8+2))&0x3f);
                sUTF8+=3;
                iStringType=STRING_TYPE_CHINESE;
                WORD GBWord,BIG5Word;
                iGBCount += oUni2GBConvertTable.iConvert(high,low,GBWord);
                iBIG5Count += oUni2BIG5ConvertTable.iConvert(high,low,BIG5Word);
                *sGBWrite++ = GBWord>>8;
                *sGBWrite++ = GBWord;
                *sBIG5Write++ = BIG5Word>>8;
                *sBIG5Write++ = BIG5Word;
            }
            else // sometimes if selection owner run in chinese locale, they actully return string is gb2312 STRING, not UTF-8!
            {
                strncpy((char *)sGBCode,(const char *)value,iActLen);
                sGBWrite = sGBCode + iActLen;   // will write '\0' below
                iGBCount = iActLen;
                iBIG5Count = 0;
                iStringType=STRING_TYPE_CHINESE;
                break;
            }
#if 0            
            else
            {
#ifndef NDEBUG
                printf("Selection Buffer:%s\n",(char *)value);
#endif                
                assert(0);
                delete [] sGBCode;
                delete [] sBIG5Code;
                vFreeSelectionMemory(value);
                ((Selection *)thisObj)->cIsBusy = 0;
                return;
            }
#endif
        }
        *sBIG5Write = *sGBWrite = '\0';
        char * sChineseString = (char *)sGBCode;
        if ( iBIG5Count > iGBCount )    //must be big5 string
        {
            oBIG2GBMapTable.vMapString(sBIG5Code);
            sChineseString = (char *)sBIG5Code;
        }
        if ( iStringType==STRING_TYPE_CHINESE || iStringType==STRING_TYPE_ASCII )
            ((Selection *)thisObj)->vSelectionReceived(sChineseString,(int)(sGBWrite-sGBCode),iStringType);
            
        delete [] sGBCode;delete [] sBIG5Code;
    }   // UTF8_STRING
    else if ( *type == COMPOUND_TEXT_Atom && iActLen > 4 )  // Extra 4 byte as tag ( and maybe several tags )
    {
        char temp[MAX_STR_LEN+1];
        memcpy(temp,value,iActLen);
        temp[iActLen] = '\0';
        XmString oSelString = XmCvtCTToXmString(temp);
        // get the string's content
        XmStringContext StringContext;
        if ( XmStringInitContext(&StringContext,oSelString) )
        {
            char * text;
            XmStringCharSet charset;    // char *, null-terminated string.
            XmStringDirection direction;    // unsigned char
            Boolean separator;
            // Only get first segment.
            XmStringGetNextSegment(StringContext,&text,&charset,&direction,&separator);
            if ( !separator && direction==0 && text )
                ((Selection *)thisObj)->vSelectionReceived(text,strlen(text),bIsChinese(*text)?STRING_TYPE_CHINESE:STRING_TYPE_ASCII);
            //XtFree(charset);
            XtFree(text);
        }
        XmStringFree(oSelString);
        XmStringFreeContext(StringContext);
    }   // COMPOUND_TEXT_Atom
//     else if ( *type == LOCALE_ENCODING_Atom )   // LOCALE_ENCODING_Atom maybe "zh.euc" or just STRING!
//     {
//         ((Selection *)thisObj)->vSelectionReceived((char*)value,(int)*length,bIsChinese(*(char *)value)?STRING_TYPE_CHINESE:STRING_TYPE_ASCII);
//     }
//     else if ( *type == XA_STRING )     // add this line will cause can not get string in FrameMaker.
    else
        ((Selection *)thisObj)->vSelectionReceived((char*)value,(int)*length,bIsChinese(*(char *)value)?STRING_TYPE_CHINESE:STRING_TYPE_ASCII);
    
    vFreeSelectionMemory(value);
    ((Selection *)thisObj)->cIsBusy = 0;
}

/********************************************************************/
void Selection::vSelectionReceived(char* sValue,int iLength,int iType )
{
    if(iLength==0) 
    {
        sLastClipWord[0]='\0';
        return;
    }

    char sToken[MAX_STR_LEN+1];

    int iRealLen = iLength<MAX_STR_LEN?iLength:MAX_STR_LEN;
    memcpy(sToken,sValue,iRealLen);
    sToken[iRealLen]='\0';
    
    if ( strstr(sToken,"http://")==sToken || strstr(sToken,"ftp://")==sToken )
    {
        sLastClipWord[0]='\0';
        return;
    }

    char * sRegExp = NULL;
    if ( iType== STRING_TYPE_ASCII )
        sRegExp = "[\\(0-9A-Za-z][0-9A-Za-z_' \\(\\)\\.\\-]+";  // length >=2
    else // if ( iType== STRING_TYPE_CHINESE )
        //sRegExp = "[-\\.\\/]{2,50}";
        //sRegExp = "[\\xa0-\\xff\\.\\/]{2,50}";
        sRegExp = "[^:cntrl: a-zA-Z0-9:punct:]{2,50}";

    //MSARegExp reg("[A-Za-z_]+");
    MSARegExp reg(sRegExp);
    assert(reg.iStatus()==MSARegExp::OK);
    
    if ( strcmp(sToken,sLastClipWord) )     // not equal
    {
        strcpy(sLastClipWord,sToken);
        if( reg.bIsMatch(sToken,sToken,MAX_STR_LEN+1) )
        {
            // reject some simple words
            if ( iType == STRING_TYPE_ASCII )
            {
                if ( strstr(sToken,".pdf") || strstr(sToken,".txt") || strstr(sToken,".cpp") )
                    return;
                if ( poAppCore->vSimpleLookupToFloat(sToken,iType,False) )  //found
                    return;
                MSARegExp newreg("[a-zA-Z][a-zA-Z ]+");
                assert(newreg.iStatus()==MSARegExp::OK);
                if ( newreg.bIsMatch(sToken,sToken,MAX_STR_LEN+1) )
                    poAppCore->vSimpleLookupToFloat(sToken,iType,True);
                // else the string is too strange, don't show any thing.
            }
            else
                poAppCore->vSimpleLookupToFloat(sToken,iType,True);
        }
    }
}

//===================================================================
ListWin::ListWin(AppCore* pAppCore)
{
    poAppCore=pAppCore;
    return;
}

/********************************************************************/
Widget ListWin::wCreate(Widget wParent)
{
    Widget wScrolledWin=XtVaCreateManagedWidget("scrolledlist",
                xmScrolledWindowWidgetClass,wParent,
                NULL);
    wList=XtVaCreateManagedWidget("list",
                xmListWidgetClass,wScrolledWin,
                XmNselectionPolicy,XmSINGLE_SELECT,
                XmNvisibleItemCount,8,
                XmNtraversalOn,False,
                NULL);
#ifdef XmNrenderTable
    XtVaSetValues(wList,XmNrenderTable,MyRenderTable,NULL);
#endif    
    XtAddCallback(wList,XmNdefaultActionCallback,vClickCallback,this);
    XtAddCallback(wList,XmNsingleSelectionCallback,vChooseCallback,this);

    return(wScrolledWin);
}
    
/********************************************************************/
void ListWin::vSetBackground(Pixmap pixBack)
{
    // this scrolled window has no clip window and horizontal scrollbar.
    Widget wVScrollBar;
    Widget wScrolledWin=XtParent(wList);
    XtVaGetValues( wScrolledWin,
        XmNverticalScrollBar,&wVScrollBar,
        NULL);
    XtVaSetValues(wScrolledWin,
        XmNbackgroundPixmap,pixBack,
        NULL);
    XtVaSetValues(wVScrollBar,
        XmNbackgroundPixmap,pixBack,
        NULL);
#ifdef ALL_BG_PIXMAP    
    XtVaSetValues(wList,
        XmNbackgroundPixmap,pixBack,
        NULL);
#endif    

    return;
}

/********************************************************************/
void ListWin::vClickCallback(Widget,XtPointer thisObj,XtPointer cbs)
{
    XmListCallbackStruct *pCbs=(XmListCallbackStruct *)cbs;
    ((ListWin *)thisObj)->vClick(pCbs->item,pCbs->item_position);
    return;
}

/********************************************************************/
void ListWin::vClick(XmString xmsWord,int item_position)
{
    char *text;
    XmStringGetLtoR(xmsWord,"English",&text);
    if ( text == NULL )
    {
        char * pChineseText;
        XmStringGetLtoR(xmsWord,(char *)(bUseChineseFT?"ChineseFT":"Chinese"),&pChineseText);
        text = sReturnTo1Byte(pChineseText);
        poAppCore->vListClick(text);
        delete [] text;
        XtFree(pChineseText);
        return;
    }
    poAppCore->vListClick(text);
    XtFree(text);
    return;
}

/********************************************************************/
void ListWin::vChooseCallback(Widget,XtPointer thisObj,XtPointer cbs)
{
    XmListCallbackStruct *pCbs=(XmListCallbackStruct *)cbs;
    ((ListWin *)thisObj)->vChoose(pCbs->item);
    return;
}

/********************************************************************/
void ListWin::vChoose(XmString xmsWord)
{
    char *text;
    XmStringGetLtoR(xmsWord,"English",&text);
    if ( text == NULL )
    {
        char * pChineseText;
        XmStringGetLtoR(xmsWord,(char *)(bUseChineseFT?"ChineseFT":"Chinese"),&pChineseText);
        text = sReturnTo1Byte(pChineseText);
        poAppCore->vListChoose(text);
        delete [] text;
        XtFree(pChineseText);
        return;
    }
    poAppCore->vListChoose(text);
    XtFree(text);
    return;
}

/********************************************************************/
void ListWin::vInsertFirst(const char *sItem)
{
    XmString xmsItem=XmStringCreateLtoR((char *)sItem,"English");
    XmListAddItem(wList,xmsItem,1);
    XmStringFree(xmsItem);
    return;
}

/********************************************************************/
void ListWin::vInsertLast(const char *sItem)
{
    //opera changed here to allow chinese characters in lister.
    XmString xmsItem;
    if ( bIsChinese(sItem[0]) )
        xmsItem=xmsCreateChinese((char*)sItem);
    else
        xmsItem=XmStringCreateLtoR((char *)sItem,"English");
    XmListAddItem(wList,xmsItem,0);
    XmStringFree(xmsItem);
    return;
}

/********************************************************************/
void ListWin::vDeleteFirst(int iCount)
{
    XmListDeleteItemsPos(wList,iCount,1);
    return;
}

/********************************************************************/
void ListWin::vDeleteLast(int iCount)
{
    int iFrom=iLength()-iCount+1;
    if(iFrom>1)
    {
        XmListDeleteItemsPos(wList,iCount,iFrom);
    }
    return;
}

/********************************************************************/
int ListWin::iLength()
{
    int iCount;
    XtVaGetValues(wList,
        XmNitemCount,&iCount,
        NULL);
    return(iCount);
}

/********************************************************************/
int ListWin::iVisibleCount()
{
    int iCount;
    XtVaGetValues(wList,
        XmNvisibleItemCount,&iCount,
        NULL);
    return(iCount);
}

/********************************************************************/
void ListWin::vClear()
{
    XmListDeleteAllItems(wList);
    return;
}

//===================================================================
CfgWin::CfgWin(AppCore *pAppCore)
{
    poAppCore=pAppCore;
    return;
}

/********************************************************************/
Widget CfgWin::wCreate(Widget wParent)
{
    Widget wForm=XtVaCreateManagedWidget("toggleroom",
                xmFormWidgetClass,wParent,
                XmNfractionBase,8,
                NULL);

    XmString xmsScanClipBoard=xmsCreateChinese(SCAN_S);
    wScanClipBoardToggle=XtVaCreateManagedWidget("scanclipboardtoggle",
                xmToggleButtonWidgetClass,wForm,
                XmNlabelString,xmsScanClipBoard,
//                XmNindicatorType,XmONE_OF_MANY,
                XmNalignment,XmALIGNMENT_BEGINNING,
                XmNhighlightThickness,0,
                XmNtraversalOn,False,
                NULL);
    XmStringFree(xmsScanClipBoard);

    //Added by Opera Wang
    XmToggleButtonSetState( wScanClipBoardToggle,
                            GetIntFromIni(IniFileName,"ScanClipBoard",NULL,1),
                            TRUE
                          );
    XtAddCallback(wScanClipBoardToggle,XmNvalueChangedCallback,vScanClipBoardCallback,this);
    
    XmString xmsHelp=xmsCreateChinese(HELP_S);
    wHelpButton=XtVaCreateManagedWidget("helpbutton",
                xmPushButtonWidgetClass,wForm,
                XmNlabelString,xmsHelp,
                XmNshadowThickness,0,
                XmNhighlightThickness,0,
                XmNmarginHeight,0,
                XmNtraversalOn,False,
                NULL);
    XmStringFree(xmsHelp);
    XtAddCallback(wHelpButton,XmNactivateCallback,vHelpCallback,this);

    XmString xmsLast=xmsCreateChinese(LAST_S);
    wLastButton=XtVaCreateManagedWidget("lastbutton",
                xmPushButtonWidgetClass,wForm,
                XmNlabelString,xmsLast,
                XmNshadowThickness,0,
                XmNhighlightThickness,0,
                XmNmarginHeight,0,
                XmNtraversalOn,False,
                NULL);
    XmStringFree(xmsLast);
    XtAddCallback(wLastButton,XmNactivateCallback,vLastCallback,this);

    XmString xmsNext=xmsCreateChinese(NEXT_S);
    wNextButton=XtVaCreateManagedWidget("nextbutton",
                xmPushButtonWidgetClass,wForm,
                XmNlabelString,xmsNext,
                XmNshadowThickness,0,
                XmNhighlightThickness,0,
                XmNmarginHeight,0,
                XmNtraversalOn,False,
                NULL);
    XmStringFree(xmsNext);
    XtAddCallback(wNextButton,XmNactivateCallback,vNextCallback,this);

    XmString xmsExit=xmsCreateChinese(EXIT_S);
    wExitButton=XtVaCreateManagedWidget("exitbutton",
                xmPushButtonWidgetClass,wForm,
                XmNlabelString,xmsExit,
                XmNshadowThickness,0,
                XmNhighlightThickness,0,
                XmNmarginHeight,0,
                XmNtraversalOn,False,
                NULL);
    XmStringFree(xmsExit);
    XtAddCallback(wExitButton,XmNactivateCallback,vExitCallback,this);

    // set position
    XtVaSetValues(wScanClipBoardToggle,
            XmNtopAttachment,XmATTACH_FORM,
            XmNleftAttachment,XmATTACH_FORM,
            XmNrightAttachment,XmATTACH_POSITION,
            XmNrightPosition,2,
            XmNbottomAttachment,XmATTACH_FORM,
            NULL);
    XtVaSetValues(wHelpButton,
            XmNtopAttachment,XmATTACH_FORM,
            XmNbottomAttachment,XmATTACH_FORM,
            XmNleftAttachment,XmATTACH_POSITION,
            XmNleftPosition,2,
            NULL);
    XtVaSetValues(wLastButton,
            XmNtopAttachment,XmATTACH_FORM,
            XmNbottomAttachment,XmATTACH_FORM,
            XmNleftAttachment,XmATTACH_POSITION,
            XmNleftPosition,3,
            NULL);
    XtVaSetValues(wNextButton,
            XmNtopAttachment,XmATTACH_FORM,
            XmNbottomAttachment,XmATTACH_FORM,
            XmNleftAttachment,XmATTACH_POSITION,
            XmNleftPosition,4,
            NULL);
    XtVaSetValues(wExitButton,
            XmNtopAttachment,XmATTACH_FORM,
            XmNbottomAttachment,XmATTACH_FORM,
            XmNleftAttachment,XmATTACH_POSITION,
            XmNleftPosition,5,
            NULL);

#ifdef XmNrenderTable
    XtVaSetValues(wScanClipBoardToggle,XmNrenderTable,MyRenderTable,NULL);
    XtVaSetValues(wHelpButton,XmNrenderTable,MyRenderTable,NULL);
    XtVaSetValues(wLastButton,XmNrenderTable,MyRenderTable,NULL);
    XtVaSetValues(wNextButton,XmNrenderTable,MyRenderTable,NULL);
    XtVaSetValues(wExitButton,XmNrenderTable,MyRenderTable,NULL);
#endif    
    return(wForm);
}

void CfgWin::vScanClipBoardCallback(Widget w,XtPointer thisObj,XtPointer)
{
    ((CfgWin *)thisObj)->poAppCore->pGetAppFrame()->vUpdateScanState(XmToggleButtonGetState(w));
}

/********************************************************************/
void CfgWin::vHelpCallback(Widget,XtPointer thisObj,XtPointer)
{
    ((CfgWin *)thisObj)->poAppCore->vShowHelp();
}

/********************************************************************/
void CfgWin::vLastCallback(Widget,XtPointer thisObj,XtPointer)
{
    ((CfgWin *)thisObj)->poAppCore->vLast();
}

/********************************************************************/
void CfgWin::vNextCallback(Widget,XtPointer thisObj,XtPointer)
{
    ((CfgWin *)thisObj)->poAppCore->vNext();
}

/********************************************************************/
void CfgWin::vExitCallback(Widget,XtPointer thisObj,XtPointer)
{
    ((CfgWin *)thisObj)->poAppCore->vQuit();
}

void CfgWin::vSaveConfig()
{
    Boolean ScanClipBoard;
    XtVaGetValues(wScanClipBoardToggle,XmNset,&ScanClipBoard,NULL);
    SaveIntToIni(IniFileName,"ScanClipBoard",ScanClipBoard);
}

/********************************************************************/
void CfgWin::vSetButtonPixmap()
{
    Pixmap pixHelp=pixGetPixmap(wHelpButton,HELPIMAGEFILE_S);
    Pixmap pixHelpMask=pixGetBitmap(wHelpButton,HELPMASKFILE_S);
    if(pixHelp!=XmUNSPECIFIED_PIXMAP && pixHelpMask!=XmUNSPECIFIED_PIXMAP)
    {
        XtVaSetValues(wHelpButton,
            XmNlabelPixmap,pixHelp,
            XmNlabelType,XmPIXMAP,
            NULL);
        XShapeCombineMask(XtDisplay(wHelpButton),XtWindow(wHelpButton),
            ShapeBounding,0,0,pixHelpMask,ShapeSet);
    }
    else
    {
#ifndef NDEBUG        
        vShowErrorToTerm("can't get Help pixmap !\n");
#endif        
    }

    Pixmap pixExit=pixGetPixmap(wExitButton,EXITIMAGEFILE_S);
    Pixmap pixExitMask=pixGetBitmap(wExitButton,EXITMASKFILE_S);
    if(pixExit!=XmUNSPECIFIED_PIXMAP && pixExitMask!=XmUNSPECIFIED_PIXMAP)
    {
        XtVaSetValues(wExitButton,
            XmNlabelPixmap,pixExit,
            XmNlabelType,XmPIXMAP,
            NULL);
        XShapeCombineMask(XtDisplay(wExitButton),XtWindow(wExitButton),
            ShapeBounding,2,0,pixExitMask,ShapeSet);
    }
    else
    {
#ifndef NDEBUG
        vShowErrorToTerm("can't get Exit pixmap !\n");
        if ( pixExit == XmUNSPECIFIED_PIXMAP )
            fprintf(stderr,"Can not get file %s\n",EXITIMAGEFILE_S);
        if ( pixExitMask == XmUNSPECIFIED_PIXMAP )
            fprintf(stderr,"Can not get file %s\n",EXITMASKFILE_S);
#endif        
    }

    Pixmap pixLast=pixGetPixmap(wLastButton,LASTIMAGEFILE_S);
    Pixmap pixLastMask=pixGetBitmap(wLastButton,LASTMASKFILE_S);
    if(pixLast!=XmUNSPECIFIED_PIXMAP && pixLastMask!=XmUNSPECIFIED_PIXMAP)
    {
        XtVaSetValues(wLastButton,
            XmNlabelPixmap,pixLast,
            XmNlabelType,XmPIXMAP,
            NULL);
        XShapeCombineMask(XtDisplay(wLastButton),XtWindow(wLastButton),
            ShapeBounding,2,0,pixLastMask,ShapeSet);
    }
    else
    {
#ifndef NDEBUG        
        vShowErrorToTerm("can't get Last pixmap !\n");
#endif        
    }

    Pixmap pixNext=pixGetPixmap(wNextButton,NEXTIMAGEFILE_S);
    Pixmap pixNextMask=pixGetBitmap(wNextButton,NEXTMASKFILE_S);
    if(pixNext!=XmUNSPECIFIED_PIXMAP && pixNextMask!=XmUNSPECIFIED_PIXMAP)
    {
        XtVaSetValues(wNextButton,
            XmNlabelPixmap,pixNext,
            XmNlabelType,XmPIXMAP,
            NULL);
        XShapeCombineMask(XtDisplay(wNextButton),XtWindow(wNextButton),
            ShapeBounding,0,0,pixNextMask,ShapeSet);
    }
    else
    {
#ifndef NDEBUG        
        vShowErrorToTerm("can't get Next pixmap !\n");
#endif
    }
}

/********************************************************************/
void CfgWin::vSetBackground(Pixmap pixBack)
{
    XtVaSetValues(XtParent(wScanClipBoardToggle),
        XmNbackgroundPixmap,pixBack,
        NULL);
    XtVaSetValues(wScanClipBoardToggle,
        XmNbackgroundPixmap,pixBack,
        NULL);
    XtVaSetValues(wHelpButton,
        XmNbackgroundPixmap,pixBack,
        NULL);
    XtVaSetValues(wExitButton,
        XmNbackgroundPixmap,pixBack,
        NULL);
    XtVaSetValues(wLastButton,
        XmNbackgroundPixmap,pixBack,
        NULL);
    XtVaSetValues(wNextButton,
        XmNbackgroundPixmap,pixBack,
        NULL);
    return;
}

/********************************************************************/
Boolean CfgWin::bScanClipBoard()
{
    return(XmToggleButtonGetState(wScanClipBoardToggle));
}

Boolean CfgWin::bSetScanClipBoard(Boolean NewState)
{
    Boolean ret = XmToggleButtonGetState(wScanClipBoardToggle);
    XmToggleButtonSetState(wScanClipBoardToggle,NewState,True); // Notify will be called, so state of trayicon was updated.
    return ret;
}

//===================================================================
AppCore::AppCore(AppFrame* pAppFrame):oUserWin(this),oListWin(this),
    oCfgWin(this),oFloatWin(this),oSelection(this)
{
    poAppFrame=pAppFrame;
    sSavedWords=new char[MAX_STR_LEN*oLibs.iGetTotalLibs()];
    sSavedWords[0]='\0';
    GetIntFromIni(IniFileName,"MaxFuzzyDistance",&iMaxFuzzyDistance,MAX_FUZZY_DISTANCE);
    iCurrentIndex = new int[oLibs.iGetTotalLibs()];
}

AppCore::~AppCore()
{
    if (iCurrentIndex)
        delete [] iCurrentIndex;
    if (sSavedWords)
        delete [] sSavedWords;
}

/********************************************************************/
Widget AppCore::wCreate(Widget wParent)
{
    for (int iLib=0;iLib<oLibs.iGetTotalLibs();iLib++)
    {
        if ( oLibs.bIsOKForSearch(iLib,STRING_TYPE_ASCII,LIB_SEARCH_TYPE_INDEX) )
            iCurrentIndex[iLib] = 0;
        else
            iCurrentIndex[iLib] = INVALID_INDEX;
    }
    
    Widget wForm=XtVaCreateWidget("mainform",
            xmFormWidgetClass,wParent,
            XmNfractionBase,4,
            XmNmarginWidth,0,
            XmNmarginHeight,0,
            XmNshadowType,XmSHADOW_OUT,
            XmNshadowThickness,0,
            NULL);
    
    XColor GetForegroundColor;
    Colormap ColorMap;
    XtVaGetValues(wForm,XmNforeground,&GetForegroundColor.pixel,XmNcolormap,&ColorMap,NULL);
    XQueryColor(XtDisplay(wForm),ColorMap,&GetForegroundColor);
    unsigned long colorsqare = GetForegroundColor.red * GetForegroundColor.red
                             + GetForegroundColor.green * GetForegroundColor.green
                             + GetForegroundColor.blue * GetForegroundColor.blue;
    bForegroundIsWhite = (colorsqare>=0x7ffful*0x8000ul*3ul);
    
#ifdef XmNrenderTable
    vCreateRendertable(wForm);
#endif
        
    Widget wTopWin=wCreateTopLabel(wForm);
    Widget wListWin=oListWin.wCreate(wForm);
    Widget wUserWin=oUserWin.wCreate(wForm);
    Widget wCfgWin=oCfgWin.wCreate(wForm);

    // set position
    XtVaSetValues(wTopWin,
        XmNtopAttachment,XmATTACH_FORM,
        XmNleftAttachment,XmATTACH_FORM,
        XmNrightAttachment,XmATTACH_FORM,
        NULL);
    XtVaSetValues(wListWin,
        XmNtopAttachment,XmATTACH_WIDGET,
        XmNtopWidget,wTopWin,
        XmNleftAttachment,XmATTACH_POSITION,
        XmNleftPosition,3,
        XmNrightAttachment,XmATTACH_FORM,
        XmNbottomAttachment,XmATTACH_FORM,
        NULL);
    XtVaSetValues(wUserWin,
        XmNtopAttachment,XmATTACH_WIDGET,
        XmNtopWidget,wTopWin,
        XmNleftAttachment,XmATTACH_FORM,
        XmNrightAttachment,XmATTACH_WIDGET,
        XmNrightWidget,wListWin,
        XmNbottomAttachment,XmATTACH_WIDGET,
        XmNbottomWidget,wCfgWin,
        NULL);
    XtVaSetValues(wCfgWin,
        XmNleftAttachment,XmATTACH_FORM,
        XmNrightAttachment,XmATTACH_WIDGET,
        XmNrightWidget,wListWin,
        XmNbottomAttachment,XmATTACH_FORM,
        NULL);

    XtManageChild(wForm);

    oFloatWin.wCreate(wParent);

    return(wForm);
}

/********************************************************************/
Widget AppCore::wCreateTopLabel(Widget wParent)
{
    Widget wFrame=XtVaCreateManagedWidget("frame",
                    xmFrameWidgetClass,wParent,
                    NULL);

    XmString xmsTopLabel=xmsCreateChinese(TOPLABEL_S);
    wTopLabel=XtVaCreateManagedWidget("toplabel",
                xmLabelWidgetClass,wFrame,
                XmNlabelString,xmsTopLabel,
                NULL);
#ifdef XmNrenderTable
    XtVaSetValues(wTopLabel,XmNrenderTable,MyRenderTable,NULL);
#endif    
    XmStringFree(xmsTopLabel);

    return(wFrame);
}

/********************************************************************/
bool AppCore::bSetBackground(bool UsePicture)
{
    Pixmap pixBack = XmUNSPECIFIED_PIXMAP;
    if ( UsePicture)
    {
        char sBackgroundPixmapFile[PATH_MAX+1];
        if ( !GetStringFromIni(IniFileName,"BackgroundPixmapFile",sBackgroundPixmapFile,NULL) )
        {
            // not set in ini, select it automaticly
            if ( bForegroundIsWhite )
                strcpy(sBackgroundPixmapFile,BACKIMAGEFILE_S);
            else
                strcpy(sBackgroundPixmapFile,BACKIMAGEFILE_WHITE_S);
        }
        if ( sBackgroundPixmapFile[0] )
        {
            pixBack=pixGetPixmap(wTopLabel,sBackgroundPixmapFile);
            if( pixBack == XmUNSPECIFIED_PIXMAP )
            {
#ifndef NDEBUG        
                vShowErrorToTerm("Can't get background pixmap or no color !\n");
#endif        
                return false;
            }
        }
    }

    XtVaSetValues(wTopLabel,
        XmNbackgroundPixmap,pixBack,
        NULL);
    oUserWin.vSetBackground(pixBack);
    oListWin.vSetBackground(pixBack);
    oCfgWin.vSetBackground(pixBack);
    oFloatWin.vSetBackground(pixBack);

    if (pixBack != XmUNSPECIFIED_PIXMAP)
        XFreePixmap(XtDisplay(wTopLabel),pixBack);
    return true;
}

void AppCore::vColorMapChangeCallback(Widget w,XtPointer thisObj,XEvent* pEvent, Boolean* continue_to)
{
    ((AppCore*)thisObj)->vColorMapchange(pEvent);
}

void AppCore::vColorMapchange(XEvent * pEvent)
{
    if ( !pEvent->xcolormap.c_new ) // Colormap Installed/Uninstalled
    {
        if ( pEvent->xcolormap.state == ColormapUninstalled )
            bSetBackground(false);
        else
            bSetBackground(true);
    }
}

/********************************************************************/
void AppCore::vAfterRealize() // must be done after realized.
{
    if ( bSetBackground(true) )     //Successfully set background picture.
        XtAddEventHandler(wTopLabel,ColormapChangeMask,False,vColorMapChangeCallback,this);
    oCfgWin.vSetButtonPixmap(); 
    oSelection.vStart(wTopLabel);
    oUserWin.vActivateText();
    vShowHelp();
}

/********************************************************************/
void AppCore::vQuit()
{
    poAppFrame->vQuit();
}

/********************************************************************/
void AppCore::vShowHelp()
{
    oUserWin.vShowHelp();
}

void AppCore::vEnd()
{
    oSelection.vEnd();
    oCfgWin.vSaveConfig();
}

/********************************************************************/
void AppCore::vShowNotFoundToFloat(const char* sWord,const char* sReason,const Boolean ShowFuzzyFindButton)
{
    XmString xmsWord=xmsCreateChinese(sWord);
    XmString xmsNewLine=xmsCreateChinese("\n");
    XmString xmsMessage=XmStringConcat(xmsWord,xmsNewLine);
    XmStringFree(xmsWord);
    XmStringFree(xmsNewLine);

    XmString xmsOldMessage=xmsMessage;
    XmString xmsReason=xmsCreateChinese(sReason);
    xmsMessage=XmStringConcat(xmsOldMessage,xmsReason);
    XmStringFree(xmsOldMessage);
    XmStringFree(xmsReason);

    oFloatWin.vShow(sWord,xmsMessage,ShowFuzzyFindButton);
    XmStringFree(xmsMessage);
}

/********************************************************************/
void AppCore::vShowNotFoundToUserWin(const char* sWord,const char* sReason)
{
    oUserWin.vShowToLabel(sWord);
    oUserWin.vShowToMeaningWin(sReason);
}
        
/********************************************************************/
void AppCore::vShowWordToUserWin(WordItem ** ppWordToShow,const char * sOriginWord)
{
//    XmString xmsWord=XmStringCreateSimple((char *)sOriginWord);
    XmString xmsWord=xmsCreateChinese((char *)sOriginWord);
    oUserWin.vShowToLabel(xmsWord);
    XmString *pxmsMessage = oWordsToShow(ppWordToShow,True,False);
    oUserWin.vShowToMeaningWin(*pxmsMessage);
    XmStringFree(*pxmsMessage);
    delete pxmsMessage;
    XmStringFree(xmsWord);
}
/********************************************************************/
XmString * AppCore::oWordsToShow(WordItem ** ppWordToShow,const Boolean bSaveWords,const bool bOnlyFirstLib)
{
    XmString * xmsReturn= new XmString;
    *xmsReturn = XmStringCreateLtoR("","English");
    XmString & xmsMessage = *xmsReturn;
    //XmString xmsMessage=XmStringCreateLtoR("","English");
    XmString xmsNULL=XmStringCreateLtoR("","English");
    XmString xmsNewLine=xmsCreateChinese("\n");
    XmString xmsOldMessage;
    if (bSaveWords)
        sSavedWords[0] = '\0';
    for (int iLib=0;iLib<oLibs.iGetTotalLibs();iLib++)
    {
        if ( ppWordToShow[iLib] )   // yes
        {
//            if ( iLib>0 )   // show LIB name
            {
                if ( !XmStringCompare(xmsMessage,xmsNULL) )
                {
                    xmsOldMessage = xmsMessage;
                    xmsMessage = XmStringConcat(xmsOldMessage,xmsNewLine);
                    XmStringFree(xmsOldMessage);
                }

                if (bSaveWords)
                    strncat(sSavedWords,"\n",MAX_STR_LEN*oLibs.iGetTotalLibs()-strlen(sSavedWords));
                
//                XmString xmsLibName = xmsCreateChinese(oLibs.sGetLibName(iLib));
                XmString xmsLibName = XmStringCreateLtoR((char*)oLibs.sGetLibName(iLib),"LibName");
                xmsOldMessage = xmsMessage;
                xmsMessage = XmStringConcat(xmsOldMessage,xmsLibName);
                XmStringFree(xmsOldMessage);
                XmStringFree(xmsLibName);
                
                if (bSaveWords)
                    strncat(sSavedWords,oLibs.sGetLibName(iLib),MAX_STR_LEN*oLibs.iGetTotalLibs()-strlen(sSavedWords));
            }
            xmsOldMessage = xmsMessage;
            
            XmString xmsWord;           // show Word
            if ( oLibs.cGetLibType(iLib,LIB_TYPE_WORD) == LIB_WORD_ENGLISH )
                xmsWord = XmStringCreateLtoR( (char*)(ppWordToShow[iLib]->sGetWord()), "English" );
            else if ( oLibs.cGetLibType(iLib,LIB_TYPE_WORD) == LIB_WORD_GB )
                xmsWord = xmsCreateChinese(ppWordToShow[iLib]->sGetWord());
            else if ( oLibs.cGetLibType(iLib,LIB_TYPE_WORD) == LIB_WORD_PY )
                xmsWord = XmStringCreateLtoR( (char*)(ppWordToShow[iLib]->sGetWord()), "PY" );
            else
                xmsWord = XmStringCreateLtoR("SORRY, Not Supported Yet","English");
            
            if (bSaveWords)
                strncat(sSavedWords,ppWordToShow[iLib]->sGetWord(),MAX_STR_LEN*oLibs.iGetTotalLibs()-strlen(sSavedWords));
            
            // show Mark
            if ( ppWordToShow[iLib]->sGetMark()!=NULL && strlen(ppWordToShow[iLib]->sGetMark()) )
            {
                char *sMark=new char[strlen(ppWordToShow[iLib]->sGetMark())+20];
                sprintf(sMark,"  [%s]",ppWordToShow[iLib]->sGetMark());
                XmString xmsMark = NULL;
                if ( oLibs.cGetLibType(iLib,LIB_TYPE_MARK) == LIB_MARK_YB )       // Yin Biao
                {
                    // May contain Chinese words!!!
                    char * s = sMark;
                    char * tBegin = new char[strlen(s)+1];
                    char * t;
                    bool bChinese;
                    while ( *s )
                    {
                        t = tBegin;
                        
                        if ( bIsChinese(*s) )
                        {
                            while( *s && bIsChinese(*s) )
                            {
                                assert( *(s+1) );
                                assert( bIsChinese(*(s+1)) );
                                *t++ = *s++;
                                *t++ = *s++;
                            }
                            *t = '\0';
                            bChinese = true;
                        }
                        else    // YB
                        {
                            while ( *s && !bIsChinese(*s) )
                                *t++ = *s++;
                            *t = '\0';
                            bChinese = false;
                        }
                        XmString xmsTemp = bChinese?xmsCreateChinese(tBegin):XmStringCreateLtoR(tBegin,"YB");
                        if ( xmsMark == NULL )
                            xmsMark = xmsTemp;
                        else
                        {
                            XmString temp = xmsMark;
                            xmsMark = XmStringConcat(xmsMark,xmsTemp);
                            XmStringFree(xmsTemp);
                            XmStringFree(temp);
                        }
                        xmsTemp = NULL;
                    }
                    delete [] tBegin;
                }   // end of Yin Biao
                else if ( oLibs.cGetLibType(iLib,LIB_TYPE_MARK) == LIB_MARK_PY )       // Pin Yin
                    xmsMark = XmStringCreateLtoR(sMark,"PY");
                else
                    xmsMark = XmStringCreateLtoR("!!!ERROR!!!","English");
                if (bSaveWords)
                    strncat(sSavedWords,sMark,MAX_STR_LEN*oLibs.iGetTotalLibs()-strlen(sSavedWords));
                delete []sMark;
                XmString xmsOldWord=xmsWord;
                xmsWord=XmStringConcat(xmsOldWord,xmsMark);
                XmStringFree(xmsMark);
                XmStringFree(xmsOldWord);
            }
            // now xmsWord is Word with optional Mark

            xmsMessage = XmStringConcat(xmsOldMessage,xmsWord);
            XmStringFree(xmsOldMessage);
            XmStringFree(xmsWord);

            // add a '\n'
            xmsOldMessage=xmsMessage;
            xmsMessage=XmStringConcat(xmsOldMessage,xmsNewLine);
            XmStringFree(xmsOldMessage);
            if (bSaveWords)
                strncat(sSavedWords,"\n",MAX_STR_LEN*oLibs.iGetTotalLibs()-strlen(sSavedWords));

            // add meaning
            xmsOldMessage=xmsMessage;
            XmString xmsMeaning;
            if ( oLibs.cGetLibType(iLib,LIB_TYPE_MEANING) == LIB_MEANING_GB )
//                 || oLibs.cGetLibType(iLib,LIB_TYPE_MEANING) == LIB_MEANING_CHINESE_AND_ENGLISH )
                xmsMeaning = xmsCreateChinese(ppWordToShow[iLib]->sGetMeaning());
            else if ( oLibs.cGetLibType(iLib,LIB_TYPE_MEANING) == LIB_MEANING_ENGLISH )
                xmsMeaning = XmStringCreateLtoR( (char*)(ppWordToShow[iLib]->sGetMeaning()) , "English" );
            else
                xmsMeaning = XmStringCreateLtoR("Can't Display!","English");
            xmsMessage=XmStringConcat(xmsOldMessage,xmsMeaning);
            XmStringFree(xmsOldMessage);
            XmStringFree(xmsMeaning);
            if (bSaveWords)
                strncat( sSavedWords, ppWordToShow[iLib]->sGetMeaning(), MAX_STR_LEN*oLibs.iGetTotalLibs()-strlen(sSavedWords) );

            if ( bOnlyFirstLib )            
                break;
        }   // if valid lib
    }   // for lib loop
//    XmStringFree(xmsMessage);
    XmStringFree(xmsNULL);
    XmStringFree(xmsNewLine);
    //return &xmsMessage;
    return xmsReturn;
}

/********************************************************************/
void AppCore::vShowWordToFloat(const WordItem ** ppWordToShow)
{
    oFloatWin.vShow(ppWordToShow);
}

/********************************************************************/
void AppCore::vLookupWithRuleToUserWin(const char* sWord)
{
    int aiIndex[MAX_MATCH_ITEM+1];
    int iMatchCount = 0;
    // const char * ppMatchWord[(MAX_MATCH_ITEM+1)*oLibs.iGetTotalLibs()]; // C99 Standard, this will work under gcc
    const char ** ppMatchWord = new const char*[(MAX_MATCH_ITEM+1)*oLibs.iGetTotalLibs()];
    char sError[MAX_STR_LEN];
    
    for(int iLib=0;iLib<oLibs.iGetTotalLibs();iLib++)
    {
        if( oLibs.bIsOKForSearch(iLib,STRING_TYPE_ASCII,LIB_SEARCH_TYPE_INDEX)  // use rule search english only
            && oLibs.bGetWordsWithRule(sWord,aiIndex,MAX_MATCH_ITEM+1,iLib,sError) )
        {
            vProcessXEvent();
            for(int i=0;aiIndex[i]!=-1;i++)
            {
                const char * sMatchWord = oLibs.poGetWordItem(aiIndex[i],iLib)->sGetWord();
                Boolean bAlreadyInList = False;
                for (int j=0;j<iMatchCount;j++)
                {
                    if ( strcmp(ppMatchWord[j],sMatchWord) == 0 )   //already in list
                    {
                        bAlreadyInList = True;
                        break;
                    }
                }
                if ( !bAlreadyInList)
                    ppMatchWord[iMatchCount++] = sMatchWord;
            }
        }
    }
    if (iMatchCount)
    {
        oListWin.vClear();
        for(int i=0;i<iMatchCount;i++)
            oListWin.vInsertLast(ppMatchWord[i]);
        memset(iCurrentIndex,'\0',sizeof(int)*oLibs.iGetTotalLibs());    // iCurrentIndex is ineffective now.
        
        // show the first word.
        vSimpleLookupToUserWin(ppMatchWord[0],NULL,1);
    }    
    else
    {
        oListWin.vClear();
        vShowNotFoundToUserWin(sWord,sError);
    }
    delete [] ppMatchWord; ppMatchWord = NULL;
}

int AppCore::mycompare(const void * s1, const void * s2)
{
    if (s1==NULL || s2==NULL)
        return 0;
    const struct Fuzzystruct * o1 = (struct Fuzzystruct*)s1;
    const struct Fuzzystruct * o2 = (struct Fuzzystruct*)s2;
    
    if ( o1->iMatchWordDistance > o2->iMatchWordDistance )
        return 1;
    else if ( o1->iMatchWordDistance < o2->iMatchWordDistance )
        return -1;
    else if ( o1->pMatchWord && o2->pMatchWord )
        return strcasecmp(o1->pMatchWord,o2->pMatchWord);
    else
        return 0;
}

void AppCore::vLookupWithFuzzyToFloatWin(const char * sWord)
{
    assert(sWord);
    int iWordLen = strlen(sWord);
    if ( iWordLen==0 || iWordLen>MAX_STR_LEN )
        return;
    assert( !bIsChinese(sWord[0]) );

    char sLowerWord[MAX_STR_LEN+1];
    char sLowerCheckWord[MAX_STR_LEN+1];
    int iCheckWordLen;
    for (int i=0;i<=iWordLen;i++)   // contain end NULL
        sLowerWord[i] = tolower(sWord[i]);
    
    const char * pMatchWord = NULL;
    int iMaxDistance = iMaxFuzzyDistance;
    int iDistance;
    class EditDistance oEditDistance;
    
    for(int iLib=0;iLib<oLibs.iGetTotalLibs();iLib++)
    {
        vProcessXEvent();
        if( oLibs.bIsOKForSearch(iLib,STRING_TYPE_ASCII,LIB_SEARCH_TYPE_INDEX) )
        {
            const int iwords = oLibs.iLength(iLib);
            for (int index=0;index<iwords;index++)
            {
                //vProcessXEvent(); // too slow if here
                const char * sCheck = oLibs.poGetWordItem(index,iLib)->sGetWord();
                // tolower and skip too long or too short words
                iCheckWordLen = strlen(sCheck);
                if ( !iCheckWordLen || iCheckWordLen>MAX_STR_LEN
                     || iCheckWordLen-iWordLen>=iMaxDistance || iWordLen-iCheckWordLen>=iMaxDistance )
                    continue;
                for (int i=0;i<=iCheckWordLen;i++)   // contain end NULL
                    sLowerCheckWord[i] = tolower(sCheck[i]);
                iDistance = oEditDistance.CalEditDistance(sLowerCheckWord,sLowerWord,iMaxDistance);
                if ( iDistance < iMaxDistance )
                {
                      pMatchWord = sCheck;
                      iMaxDistance = iDistance;
                }   // find one
            }   // each word
        }   // ok for search
    }   // each lib
    
    // show
    if (pMatchWord)
    {
        oUserWin.vInsertHisList(pMatchWord);
        WordItem * * ppWordItem =  new WordItem*[oLibs.iGetTotalLibs()];
        int iIndex;
        for (int iLib=0;iLib<oLibs.iGetTotalLibs();iLib++)
        {
            iIndex = INVALID_INDEX;
            if ( oLibs.bIsOKForSearch(iLib,STRING_TYPE_ASCII,LIB_SEARCH_TYPE_INDEX) 
                 && oLibs.bSimpleGetWord(pMatchWord,iIndex,iLib,1,STRING_TYPE_ASCII) )
            {
                ppWordItem[iLib] = (WordItem *)oLibs.poGetWordItem(iIndex,iLib);
            }
            else
                ppWordItem[iLib] = (WordItem*)NULL;
        }
        vShowWordToFloat((const WordItem **)ppWordItem);
        delete [] ppWordItem; ppWordItem=NULL;
    }
    else
        vShowNotFoundToFloat(sWord,"[ ģƥҲҲ! ]",False);
}

void AppCore::vLookupWithFuzzyToUserWin(const char * sWord)
{
    assert(sWord);
    int iWordLen = strlen(sWord);
    if ( iWordLen==0 || iWordLen>MAX_STR_LEN )
        return;
    if ( bIsChinese(sWord[0]) )
    {
        vShowNotFoundToUserWin(sWord,"Բ,֧ģ");
        return;
    }
    
    char sLowerWord[MAX_STR_LEN+1];
    char sLowerCheckWord[MAX_STR_LEN+1];
    int iCheckWordLen;
    for (int i=0;i<=iWordLen;i++)   // contain end NULL
        sLowerWord[i] = tolower(sWord[i]);
    
    struct Fuzzystruct oFuzzystruct[MAX_FUZZY_MATCH_ITEM];
    for (int i=0;i<MAX_FUZZY_MATCH_ITEM;i++)
    {
        oFuzzystruct[i].pMatchWord = NULL;
        oFuzzystruct[i].iMatchWordDistance = iMaxFuzzyDistance;
    }
    int iMaxDistance = iMaxFuzzyDistance;
    int iDistance;
    Boolean Found = False;
    class EditDistance oEditDistance;
    
    for(int iLib=0;iLib<oLibs.iGetTotalLibs();iLib++)
    {
        vProcessXEvent();
        if( oLibs.bIsOKForSearch(iLib,STRING_TYPE_ASCII,LIB_SEARCH_TYPE_INDEX) )
        {
            const int iwords = oLibs.iLength(iLib);
            for (int index=0;index<iwords;index++)
            {
                //vProcessXEvent(); // too slow if here
                const char * sCheck = oLibs.poGetWordItem(index,iLib)->sGetWord();
                // tolower and skip too long or too short words
                iCheckWordLen = strlen(sCheck);
                if ( !iCheckWordLen || iCheckWordLen>MAX_STR_LEN
                     || iCheckWordLen-iWordLen>=iMaxDistance || iWordLen-iCheckWordLen>=iMaxDistance )
                    continue;
                for (int i=0;i<=iCheckWordLen;i++)   // contain end NULL
                    sLowerCheckWord[i] = tolower(sCheck[i]);
                iDistance = oEditDistance.CalEditDistance(sLowerCheckWord,sLowerWord,iMaxDistance);
                if ( iDistance < iMaxDistance )
                {
                    Found = True;
                    Boolean bAlreadyInList = False;
                    int iMaxDistanceAt;
                    for (int j=0;j<MAX_FUZZY_MATCH_ITEM;j++)
                    {
                        if ( oFuzzystruct[j].pMatchWord && strcasecmp(oFuzzystruct[j].pMatchWord,sCheck)==0 )   //already in list
                            bAlreadyInList = True;
                        if ( oFuzzystruct[j].iMatchWordDistance == iMaxDistance )
                            iMaxDistanceAt = j;
                    }
                    if ( !bAlreadyInList )
                    {
                        oFuzzystruct[iMaxDistanceAt].pMatchWord = sCheck;
                        oFuzzystruct[iMaxDistanceAt].iMatchWordDistance = iDistance;
                        // calc new iMaxDistance
                        iMaxDistance = iDistance;
                        for (int j=0;j<MAX_FUZZY_MATCH_ITEM;j++)
                        {
                            if ( oFuzzystruct[j].iMatchWordDistance > iMaxDistance )
                                iMaxDistance = oFuzzystruct[j].iMatchWordDistance;
                        } // calc new iMaxDistance
                    }   // add to list
                }   // find one
            }   // each word
        }   // ok for search
    }   // each lib
    
    // show
    oListWin.vClear();
    if (Found)
    {
        // sort with distance
        qsort(oFuzzystruct,MAX_FUZZY_MATCH_ITEM,sizeof(Fuzzystruct),mycompare);
        Boolean ShowFirst = False;
        memset(iCurrentIndex,'\0',sizeof(int)*oLibs.iGetTotalLibs());    // iCurrentIndex is ineffective now.
        for (int i=0;i<MAX_FUZZY_MATCH_ITEM;i++)
        {
            if ( oFuzzystruct[i].pMatchWord )
            {
                if (!ShowFirst)
                {
                    vListChoose(oFuzzystruct[0].pMatchWord);
                    ShowFirst = True;
                }
                oListWin.vInsertLast(oFuzzystruct[i].pMatchWord);
                //printf("%s,%d\n",oFuzzystruct[i].pMatchWord,oFuzzystruct[i].iMatchWordDistance);
            }
        }
    }
    else
        vShowNotFoundToUserWin(sWord,"̫˰:-(");
}

void AppCore::vLookupMeaningToUsrWin(const char * sWord)    // search chinese and english in meaning field
{
    assert(sWord);
    if ( strlen(sWord) == 0 )
        return;
    int aiIndex[MAX_MATCH_ITEM+1];
    int iMatchCount = 0;
    const char ** ppMatchWord = new const char *[(MAX_MATCH_ITEM+1)*oLibs.iGetTotalLibs()];
    BYTE * cMatchWordType = new BYTE[(MAX_MATCH_ITEM+1)*oLibs.iGetTotalLibs()];
    const int iSearchStringType = bIsChinese(sWord[0])?STRING_TYPE_CHINESE:STRING_TYPE_ASCII;
    
    for(int iLib=0;iLib<oLibs.iGetTotalLibs();iLib++)
    {
        if( oLibs.bIsOKForSearch(iLib,iSearchStringType,LIB_SEARCH_TYPE_MEANING)
            && oLibs.bGetWordsWithMeaning(sWord,aiIndex,MAX_MATCH_ITEM+1,iLib) )
        {
            vProcessXEvent();
            for(int i=0;aiIndex[i]!=-1;i++)
            {
                const char * sMatchWord = oLibs.poGetWordItem(aiIndex[i],iLib)->sGetWord();
                Boolean bAlreadyInList = False;
                for (int j=0;j<iMatchCount;j++)
                {
                    if ( strcmp(ppMatchWord[j],sMatchWord) == 0 )   //already in list
                    {
                        bAlreadyInList = True;
                        break;
                    }
                }
                if ( !bAlreadyInList)
                {
                    ppMatchWord[iMatchCount] = sMatchWord;
                    cMatchWordType[iMatchCount] = oLibs.cGetLibType(iLib,LIB_TYPE_WORD);
                    iMatchCount++;
                }
            }
        }
    }
    oListWin.vClear();
    if (iMatchCount)
    {
        for(int i=0;i<iMatchCount;i++)
        {
            if ( cMatchWordType[i] == LIB_WORD_PY )
            {
                char sPYWord[MAX_STR_LEN+1];
                strcpy(sPYWord,";");
                strncat(sPYWord,ppMatchWord[i],MAX_STR_LEN);
                oListWin.vInsertLast(sPYWord);
            }
            else
                oListWin.vInsertLast(ppMatchWord[i]);
        }
        memset(iCurrentIndex,'\0',sizeof(int)*oLibs.iGetTotalLibs());    // iCurrentIndex is ineffective now.
        
        // show the first word.
        if ( cMatchWordType[0] == LIB_WORD_PY )
        {
            char sPYWord[MAX_STR_LEN+1];
            strcpy(sPYWord,";");
            strncat(sPYWord,ppMatchWord[0],MAX_STR_LEN);
            vListChoose(sPYWord);
        }
        else
            vListChoose(ppMatchWord[0]);
    }    
    else
        vShowNotFoundToUserWin(sWord,sErrorMessage);
    delete [] ppMatchWord; ppMatchWord = NULL;
    delete [] cMatchWordType; cMatchWordType = NULL;
}

/********************************************************************/
void AppCore::vSimpleLookupToUserWin(const char* sWord,int* piIndex,int iSimularDirection,int iSearchType)
{
    WordItem * * ppWordItem = new WordItem*[oLibs.iGetTotalLibs()];
    Boolean bFound = False;
    int * iRetIndex = new int[oLibs.iGetTotalLibs()];
    
    for (int iLib=0;iLib<oLibs.iGetTotalLibs();iLib++)
    {
        iRetIndex[iLib] = INVALID_INDEX;
        if ( oLibs.bIsOKForSearch(iLib,iSearchType,LIB_SEARCH_TYPE_INDEX) 
             && oLibs.bSimpleGetWord(sWord,iRetIndex[iLib],iLib,iSimularDirection,iSearchType) )
        {
            ppWordItem[iLib] = (WordItem *)oLibs.poGetWordItem(iRetIndex[iLib],iLib);
            bFound = True;
        }
        else
            ppWordItem[iLib] = (WordItem*)NULL;
    }
    if (bFound==True)
        vShowWordToUserWin(ppWordItem,sWord);
    else
        vShowNotFoundToUserWin(sWord,NOTFOUND_S);
    delete [] ppWordItem; ppWordItem = NULL;

    if (piIndex!=NULL)
        memcpy(piIndex,iRetIndex,sizeof(int)*oLibs.iGetTotalLibs());
    delete [] iRetIndex;
}

/********************************************************************/
Boolean AppCore::vSimpleLookupToFloat(const char* sWord,int iType,Boolean bShowIfNotFound)
{
    if ( sWord==NULL || strlen(sWord)==0 )
        return true;
    // First disable floatwin
    oFloatWin.vShow((const char *)NULL,(const XmString)NULL,False);
    
    char SearchWord[MAX_STR_LEN+1];
    char * EndPointer,*P1,*P2;
    P1=(char *)sWord;
    P2=SearchWord;
    // delete chinese space at the begining
    while( *P1 && *P1==(char)0xa1 && *(P1+1)==(char)0xa1 )
        P1+=2;
    //format word, delete any spilth blanks.    
    while(*P1)
    {
        if ( *P1==' ' || *P1=='\t' || *P1=='\n' )
        {
            *P2++=' ';
            P1++;
            while(*P1==' ' || *P1=='\t' || *P1=='\n')
                P1++;
        }
        else
            *P2++= *P1++;
    }
    *P2='\0';
    //strcpy(SearchWord,sWord);
    EndPointer=SearchWord+strlen(SearchWord);
    
    //find the word use most biggest length
    WordItem ** ppWordItem = new WordItem*[oLibs.iGetTotalLibs()];
    while (EndPointer>=SearchWord)
    {
        // delete end spaces
        while ( EndPointer>SearchWord && *EndPointer==' ' )
            *EndPointer--='\0';
        int iIndex;
        
        Boolean bFound = False;
        for (int iLib=0;iLib<oLibs.iGetTotalLibs();iLib++)
        {
            iIndex = INVALID_INDEX;
            if ( oLibs.bIsOKForSearch(iLib,iType,LIB_SEARCH_TYPE_INDEX) 
                 && oLibs.bSimpleGetWord(SearchWord,iIndex,iLib,1,iType) )
            {
                ppWordItem[iLib] = (WordItem *)oLibs.poGetWordItem(iIndex,iLib);
                bFound = True;
            }
            else
                ppWordItem[iLib] = (WordItem*)NULL;
        }
        if (bFound==True)
        {
            vShowWordToFloat((const WordItem **)ppWordItem);
            oUserWin.vInsertHisList(SearchWord);
            delete [] ppWordItem; ppWordItem = NULL;
            return True;
        }
        // delete last word
        if ( iType == STRING_TYPE_ASCII )
        {
            while ( EndPointer>=SearchWord && *EndPointer!=' ' )
                EndPointer--;
            if (EndPointer>=SearchWord)
                *EndPointer='\0';
        }
        else // delete one character per time
            *--EndPointer='\0';
    }
    // not found
    delete [] ppWordItem; ppWordItem = NULL;
    if (bShowIfNotFound)
    {
        vShowNotFoundToFloat(strlen(SearchWord)?SearchWord:sWord,NOTFOUND_S,True);
        oUserWin.vInsertHisList(sWord);
    }
    return False;
}

/********************************************************************/
void AppCore::vUserWinWordChange(const char* sWord,int iSimularDirection,int * piInput_Index)
{
    if( bContainRule(sWord) )
    {
        oUserWin.vShowToLabel(sWord);
        oUserWin.vShowToMeaningWin("سϹĵб...");
        return;
    }

    int * iIndex = new int[oLibs.iGetTotalLibs()];
    int * pIndex = iIndex;
    Boolean bChangeIndex = True;
    if ( piInput_Index )
    {
        pIndex = piInput_Index;
        bChangeIndex = False;
    }
        
    if (sWord[0]==';')          //start with ";"
    {
        if (strlen(sWord)==1)
        {
            oUserWin.vShowToLabel(" ");
            oUserWin.vShowToMeaningWin("뺺ƴĸ...");
        }
        else if ( bIsChinese((sWord[1])) )
        {
            oUserWin.vShowToLabel(sWord);
            oUserWin.vShowToMeaningWin("÷!\n˼,ǰ\"/\"\nƴ,\";\"ƴĸ.");
        }
        else
        {
            vSimpleLookupToUserWin(sWord+1,iIndex,iSimularDirection,STRING_TYPE_PY);
            vListWords(pIndex,LIST_MEANING,bChangeIndex);
        }
    }
    else if ( sWord[0]=='!' || sWord[0]=='/' )          // Search Meaning
    {
        if ( strlen(sWord) == 1 )
        {
            oUserWin.vShowToLabel(" ");
            oUserWin.vShowToMeaningWin("ҪѯĴȻ󰴻س...");
        }
        else
            oUserWin.vShowToLabel(sWord);
    }
    else if ( sWord[0] == '\\' )          // Fuzzy Search
    {
        if ( strlen(sWord) == 1 )
        {
            oUserWin.vShowToLabel(" ");
            oUserWin.vShowToMeaningWin("Fuzzy search...");
        }
        else
        {
            oUserWin.vShowToLabel(sWord);
            if (bIsChinese((sWord[1])))
                oUserWin.vShowToMeaningWin("ģ֧\n㲻ô˵˰:-)");
        }
    }
    else if (bIsChinese(sWord[0]))      // Chinese
    {
        vSimpleLookupToUserWin(sWord,iIndex,iSimularDirection,STRING_TYPE_CHINESE);
        vListWords(pIndex,LIST_WORD,bChangeIndex);
    }
    else
    {
        vSimpleLookupToUserWin(sWord,iIndex,iSimularDirection,STRING_TYPE_ASCII);
        vListWords(pIndex,LIST_WORD,bChangeIndex);
    }
    delete [] iIndex; iIndex= NULL;
}

/********************************************************************/
void AppCore::vUserWinEnterWord(const char* sWord)
{
    Cursor oWaitCursor = XCreateFontCursor(XtDisplay(wTopLabel),XC_watch);
    XDefineCursor(XtDisplay(wTopLabel),XtWindow(XtParent(XtParent(wTopLabel))),oWaitCursor);
    vProcessXEvent();

    if ( sWord[0]=='!' || sWord[0]=='/' )
        vLookupMeaningToUsrWin(sWord+1);
    else if ( sWord[0] == '\\' )
        vLookupWithFuzzyToUserWin(sWord+1);
    else if( bContainRule(sWord) )
        vLookupWithRuleToUserWin(sWord);
    
    oUserWin.vSetTextSelection();
    oUserWin.vInsertHisList(sWord);

    XUndefineCursor(XtDisplay(wTopLabel),XtWindow(XtParent(XtParent(wTopLabel))));
    XFreeCursor(XtDisplay(wTopLabel),oWaitCursor);
}

/********************************************************************/
void AppCore::vArrowActivate()
{
    oUserWin.vToggleHisList();
}

/********************************************************************/
void AppCore::vListClick(const char* sWord)
{
    oUserWin.vPutToText(sWord);
}

/********************************************************************/
void AppCore::vListChoose(const char* sWord)
{
    BYTE iSearchType = bIsChinese(sWord[0])?STRING_TYPE_CHINESE:STRING_TYPE_ASCII;
    if ( sWord[0] == ';' )
    {
        iSearchType = STRING_TYPE_PY;
        vSimpleLookupToUserWin(sWord+1,NULL,1,STRING_TYPE_PY);
    }
    else
        vSimpleLookupToUserWin(sWord,NULL,1,iSearchType);
}

/********************************************************************/
void AppCore::vHistoryChoose(const char* sWord)
{
    oUserWin.vPutToText(sWord);
}

/********************************************************************/
void AppCore::vNext()
{
    int * iIndex = new int[oLibs.iGetTotalLibs()];
    BYTE cCurrentFillType;
    memcpy(iIndex,iCurrentIndex,sizeof(int)*oLibs.iGetTotalLibs());
    const WordItem * poNextItem = oLibs.poGetNextWordItem(iCurrentIndex,&cCurrentFillType);
    if (poNextItem)
    {
        if ( cCurrentFillType == LIB_WORD_PY )
        {
            char sPYWord[MAX_STR_LEN+1];
            strcpy(sPYWord,";");
            strncat(sPYWord,poNextItem->sGetWord(),MAX_STR_LEN);
            vUserWinWordChange(sPYWord,SEARCH_INDEX_DOWN,iIndex);
        }
        else
            vUserWinWordChange(poNextItem->sGetWord(),SEARCH_INDEX_DOWN,iIndex);
    }
    delete [] iIndex; iIndex = NULL;
}

/********************************************************************/
void AppCore::vLast()
{
    int * iIndex = new int[oLibs.iGetTotalLibs()];
    BYTE cCurrentFillType;
    memcpy(iIndex,iCurrentIndex,sizeof(int)*oLibs.iGetTotalLibs());
    const WordItem * poNextItem = oLibs.poGetPreWordItem(iCurrentIndex,&cCurrentFillType);
    if (poNextItem)
    {
        if ( cCurrentFillType == LIB_WORD_PY )
        {
            char sPYWord[MAX_STR_LEN+1];
            strcpy(sPYWord,";");
            strncat(sPYWord,poNextItem->sGetWord(),MAX_STR_LEN);
            vUserWinWordChange(sPYWord,SEARCH_INDEX_UP,iIndex);
        }
        else
            vUserWinWordChange(poNextItem->sGetWord(),SEARCH_INDEX_UP,iIndex);
    }
    delete [] iIndex; iIndex = NULL;
}

/********************************************************************/
void AppCore::vListWords(int * iStartIndex,const BYTE cListType,const Boolean bChangeIndex)
{
    for (int iLib=0;iLib<oLibs.iGetTotalLibs();iLib++)
    {
        assert( (iStartIndex[iLib]>=-1 && iStartIndex[iLib]<=oLibs.iLength(iLib))
                || iStartIndex[iLib]==INVALID_INDEX );
    }
    vFillList(iStartIndex,cListType,bChangeIndex);
    return;
}

/********************************************************************/
void AppCore::vFillList(int * iIndex,const BYTE cListType,const Boolean bChangeIndex)
{
    oListWin.vClear();
    
    int iWordCount=0;
    int * iCurrent = new int[oLibs.iGetTotalLibs()];
    BYTE cCurrentFillType;
    memcpy(iCurrent,iIndex,sizeof(int)*oLibs.iGetTotalLibs());
    if (bChangeIndex)
        memcpy(iCurrentIndex,iIndex,sizeof(int)*oLibs.iGetTotalLibs());
    const WordItem * poCurrentWordItem;
    int iShowCount=oListWin.iVisibleCount();
    while ( iWordCount<iShowCount && (poCurrentWordItem=oLibs.poGetNextWordItem(iCurrent,&cCurrentFillType)) )
    {
        if ( cListType == LIST_WORD )
        {
            if ( cCurrentFillType == LIB_WORD_PY )
            {
                char sPYWord[MAX_STR_LEN+1];
                strcpy(sPYWord,";");
                strncat(sPYWord,poCurrentWordItem->sGetWord(),MAX_STR_LEN);
                oListWin.vInsertLast(sPYWord);
            }
            else
                oListWin.vInsertLast(poCurrentWordItem->sGetWord());
        }
        else
            oListWin.vInsertLast(poCurrentWordItem->sGetMeaning());
        iWordCount++;
    }
    delete [] iCurrent; iCurrent = NULL;
}

/********************************************************************/
Boolean AppCore::bScreenFetchEnable()
{
    return(oCfgWin.bScanClipBoard() && !oUserWin.bTextSelected());
}

Bool AppCore::bScanClipBoard()
{
    return oCfgWin.bScanClipBoard();
}

Bool AppCore::bSetScanClipBoard(Bool NewState)
{
    return oCfgWin.bSetScanClipBoard(NewState);
}

AppFrame * AppCore::pGetAppFrame()
{
    return poAppFrame;
}

void AppCore::vPopup()
{
    poAppFrame->vPopup();
}

void AppCore::vProcessXEvent()
{
    poAppFrame->vProcessXEvent();
}

void AppCore::vPressMeaning(Time eventtime)
{
    if ( strlen(sSavedWords)==0 )
        return;
    long itemID = 0;
    XmString s;
    int stat;
    Widget w = oUserWin.oGetMeaningWidget();
    stat = XmClipboardStartCopy(XtDisplay(w), XtWindow(w),
                                s=XmStringCreateSimple("StarDic"),
                                eventtime, w, NULL, &itemID);
    XmStringFree(s);
    if (stat != ClipboardSuccess)
    	return;
    XmClipboardCopy(XtDisplay(w), XtWindow(w), itemID, "STRING",
    	    sSavedWords, strlen(sSavedWords), 0, NULL);
    // UTF-8
    int * iSavedWords = new int[strlen(sSavedWords)+1];
    vString2UniString(sSavedWords,iSavedWords);
    char * sSavedWords_UTF8 = (char *)UnicodeToUTF8(iSavedWords);
    XmClipboardCopy(XtDisplay(w), XtWindow(w), itemID,"UTF8_STRING",
    	    sSavedWords_UTF8, strlen(sSavedWords_UTF8), 1, NULL);
    XmClipboardEndCopy(XtDisplay(w), XtWindow(w), itemID);
    delete [] iSavedWords;
    delete [] sSavedWords_UTF8;
}

//===================================================================
AppFrame::AppFrame():oAppCore(this)
{
    m_quit = m_intray = false;
    popup_menu = NULL;
    m_state = 0;
    return;
}

AppFrame::~AppFrame()
{
}

void AppFrame::vToggleScanSelection()
{
    oAppCore.bSetScanClipBoard(!oAppCore.bScanClipBoard());
}

void AppFrame::vUpdateScanState(Bool state)
{
    Pixmap TrayIcon=pixGetPixmap(wToplevel,oAppCore.bScanClipBoard()?TRAYICON_SCAN_IMAGEFILE_S:TRAYICON_IMAGEFILE_S);
    Pixmap TrayIconMask=pixGetBitmap(wToplevel,TRAYICON_MASKFILE_S);
    oTrayIcon.UpdateIcon(TrayIcon,TrayIconMask);
    if ( TrayIcon != XmUNSPECIFIED_PIXMAP )
        XFreePixmap(XtDisplay(wToplevel),TrayIcon);
    if ( TrayIconMask != XmUNSPECIFIED_PIXMAP )
        XFreePixmap(XtDisplay(wToplevel),TrayIconMask);
}

static int iWindowState(Widget w)
{
    unsigned long *property = NULL;
    unsigned long nItems;
    unsigned long leftover;
    static Atom wmStateAtom = XInternAtom (XtDisplay(w), "WM_STATE", False);
    Atom actualType;
    int actualFormat;
    int result;
  
    if (XGetWindowProperty(XtDisplay(w), XtWindow(w),
	    wmStateAtom, 0L, 1L, False, wmStateAtom, &actualType, &actualFormat,
	    &nItems, &leftover, (unsigned char **)&property) != Success ||
	    nItems != 1 || property == NULL)
    	return WithdrawnState;   // 0
    result = *property;
    XFree((void *)property);
    return result;
}

void AppFrame::vUnmapCallback(Widget w,XtPointer thisObj,XEvent* pEvent, Boolean* continue_to)
{
    AppFrame * me =(AppFrame *) thisObj;
    assert( w == me->wToplevel );
    if ( pEvent->xunmap.type==UnmapNotify && XtWindow(w)==pEvent->xunmap.window
         && me->m_intray && iWindowState(w)==IconicState )
    {
        *continue_to = False;
        me->vGetState();
        XWithdrawWindow(XtDisplay(w),XtWindow(w),DefaultScreen(XtDisplay(w)));
    }
}

// sawfish 1.0.1 always set Stiky bit when I remap the window.
// sawfish 1.3 will forget position.
void AppFrame::vGetState()
{
    Atom type_r;
    static Atom WIN_STATE_Atom = XInternAtom(XtDisplay(wToplevel), "_WIN_STATE", False);
    int format_r;
    unsigned long nitems_r, bytesafter_r;
    unsigned char * prop_r;
    if ( XGetWindowProperty(
            XtDisplay(wToplevel),
            XtWindow(wToplevel),
            WIN_STATE_Atom,
            0L,
            1L,
            False,
            AnyPropertyType,
            &type_r,
            &format_r,
            &nitems_r,
            &bytesafter_r,
            &prop_r) == Success )
    {
        if ( nitems_r && format_r==32 )
            m_state = *(int *)prop_r;
        XFree(prop_r);
    }
    
    XWindowAttributes attr;
    XtVaGetValues(wToplevel, XmNx, &m_XPos, XmNy, &m_YPos, XmNwidth, &m_Width, XmNheight, &m_Height, NULL);
    XGetWindowAttributes(XtDisplay(wToplevel),XtWindow(wToplevel),&attr);
    m_XPos -= attr.x;
    m_YPos -= attr.y;
    //printf("OP %d %d %d %d\n",m_XPos,m_YPos,m_Width,m_Height);
}

void AppFrame::vSetState()
{
    static Atom WIN_STATE_Atom = XInternAtom(XtDisplay(wToplevel), "_WIN_STATE", False);
    XClientMessageEvent xev;
    xev.type = ClientMessage;
    xev.window = XtWindow(wToplevel);
    xev.message_type = WIN_STATE_Atom;
    xev.format = 32;
    xev.data.l[0] = 0xFFFF; // bitmask, set to all :)
    xev.data.l[1] = m_state;
    XSendEvent(XtDisplay(wToplevel), DefaultRootWindow(XtDisplay(wToplevel)), False, SubstructureNotifyMask, (XEvent *)&xev );

    XtVaSetValues(wToplevel, XmNx, m_XPos, XmNy, m_YPos, XmNwidth, m_Width, XmNheight, m_Height, NULL);
}

// sawfish 1.3 put window to init workspace
void AppFrame::vPutToCurrentWorkSpace()
{
    // freedesktop standards use _NET*
    // gnome compatible use _WIN*
    // http://www.freedesktop.org/standards/wm-spec/x225.html
    // http://www.freedesktop.org/standards/wm-spec/1.0/html/x101.html
    // http://developer.gnome.org/doc/standards/wm/x37.html
    // seems sawfish hornor _NET* :-)
    static Atom _NET_CURRENT_DESKTOP_Atom = XInternAtom(XtDisplay(wToplevel), "_NET_CURRENT_DESKTOP", False);
    static Atom _WIN_WORKSPACE_Atom = XInternAtom(XtDisplay(wToplevel), "_WIN_WORKSPACE", False);
    static Atom _NET_WM_DESKTOP_Atom = XInternAtom(XtDisplay(wToplevel), "_NET_WM_DESKTOP", False);
    
    int iCurrentWorkSpace = -1;
    int iCurrentDesktop = -1;
    
    Atom type_r;
    int format_r;
    unsigned long nitems_r, bytesafter_r;
    unsigned char * prop_r;
    
    if ( _WIN_WORKSPACE_Atom )
    {
        if ( XGetWindowProperty(XtDisplay(wToplevel),DefaultRootWindow(XtDisplay(wToplevel)),
                _WIN_WORKSPACE_Atom,0L,1L,False,XA_CARDINAL,&type_r,&format_r,&nitems_r,
                &bytesafter_r,&prop_r) == Success )
        {
            if ( nitems_r > 0 && type_r == XA_CARDINAL )
                iCurrentWorkSpace = *(int*)prop_r;
            XFree(prop_r);
        }
    }
    
    if ( _NET_CURRENT_DESKTOP_Atom && _NET_WM_DESKTOP_Atom )
    {
        if ( XGetWindowProperty(XtDisplay(wToplevel),DefaultRootWindow(XtDisplay(wToplevel)),
                _NET_CURRENT_DESKTOP_Atom,0L,1L,False,XA_CARDINAL,&type_r,&format_r,&nitems_r,
                &bytesafter_r,&prop_r) == Success )
        {
            if ( nitems_r > 0 && type_r == XA_CARDINAL )
                iCurrentDesktop = *(int*)prop_r;
            XFree(prop_r);
        }
    }
    
    if ( iCurrentWorkSpace != -1 )
    {
        XChangeProperty(XtDisplay(wToplevel),XtWindow(wToplevel),
            _WIN_WORKSPACE_Atom,XA_CARDINAL,32,PropModeReplace,
            (unsigned char *)&iCurrentWorkSpace,1);
    }
    
    if ( iCurrentDesktop != -1 )
    {
        XChangeProperty(XtDisplay(wToplevel),XtWindow(wToplevel),
            _NET_WM_DESKTOP_Atom,XA_CARDINAL,32,PropModeReplace,
            (unsigned char *)&iCurrentDesktop,1);
    }
}

void AppFrame::vTrayMessageCallback(Widget w,XtPointer thisObj,XEvent* pEvent, Boolean* continue_to)
{
    AppFrame * me =(AppFrame *) thisObj;
    assert( w == me->wToplevel );
    if ( pEvent->xclient.type==ClientMessage && pEvent->xclient.message_type==XmInternAtom(pEvent->xclient.display,TRAYICON_MESSAGE_TYPE,False) )
    {
        *continue_to = False;
        me->vDeleteRButtonMenu();
        switch ( pEvent->xclient.data.l[0] )
        {
            case TRAYICON_DOCKED:
                me->m_intray = true;
                if ( iWindowState(w) == IconicState )
                {
                    me->vGetState();
                    XWithdrawWindow(XtDisplay(w),XtWindow(w),DefaultScreen(XtDisplay(w)));
                }
                me->oTrayIcon.bSendBalloonMessage("I'm Here",1000);
                break;
            case TRAYICON_UNDOCKED:
                me->m_intray = false;
                if ( iWindowState(w) == WithdrawnState )
                {
                    me->vPutToCurrentWorkSpace();
                    XMapWindow(XtDisplay(w),XtWindow(w));
                    me->vSetState();
                    XIconifyWindow(XtDisplay(w),XtWindow(w),DefaultScreen(XtDisplay(w)));
                }
                break;
            case TRAYICON_LBUTTON:
                switch ( iWindowState(w) )
                {
                    case NormalState:
                        {
                            me->vGetState();
                            XWithdrawWindow(XtDisplay(w),XtWindow(w),DefaultScreen(XtDisplay(w)));
                        }
                        break;
                    case IconicState:
                        me->vGetState();
                        XWithdrawWindow(XtDisplay(w),XtWindow(w),DefaultScreen(XtDisplay(w)));
                        // continue !!!
                    case WithdrawnState:
                        // continue !!!
                    default:
                        me->vPutToCurrentWorkSpace();
                        XMapRaised(XtDisplay(w),XtWindow(w));
                        me->vSetState();
                }
                break;
            case TRAYICON_RBUTTON:
                {
                    XmString sToggleScanSelection, sExit;
                    sToggleScanSelection = XmStringCreateLocalized((char *)((me->oAppCore).bScanClipBoard()?"NoScan":"Scan"));
                    sExit = XmStringCreateLocalized("Exit");
                    me->popup_menu = XmVaCreateSimplePopupMenu(
                            w, "rbutton_popup", vRButtonPopupCallback,
                            XmNpopupEnabled,False,  // Without this, Stardic will Cause BadAccess (X_GrabButton)
                                                    // Error under gnome/sawfish when main window open
                            XmVaPUSHBUTTON, sToggleScanSelection, '\0', NULL, NULL,
                            XmVaSEPARATOR,
                            XmVaPUSHBUTTON, sExit, '\0', NULL, NULL,
                            NULL);
                    XtAddCallback(me->popup_menu, XmNunmapCallback, vMenuUnmapCallback,(XtPointer) me);
                    XButtonPressedEvent PostionEvent;
                    memset(&PostionEvent,0,sizeof(PostionEvent));
                    PostionEvent.x_root=pEvent->xclient.data.l[1]-24;   // -24 prevent user r-click the trayicon twice :P
                    PostionEvent.y_root=pEvent->xclient.data.l[2];
                    XmMenuPosition(me->popup_menu,&PostionEvent);
                    XtManageChild(me->popup_menu);
                    XmStringFree(sToggleScanSelection);
                    XmStringFree(sExit);
                }
                break;
            case TRAYICON_PRESENT:
                me->vSetTrayIcon();
                break;
            default:
                assert(0);
        }
    }
}

void AppFrame::vSetTrayIcon()
{
    Pixmap TrayIcon=pixGetPixmap(wToplevel,oAppCore.bScanClipBoard()?TRAYICON_SCAN_IMAGEFILE_S:TRAYICON_IMAGEFILE_S);
    Pixmap TrayIconMask=pixGetBitmap(wToplevel,TRAYICON_MASKFILE_S);
    oTrayIcon.Install(TrayIcon,TrayIconMask,"Stardic TrayIcon");
    if ( TrayIcon != XmUNSPECIFIED_PIXMAP )
        XFreePixmap(XtDisplay(wToplevel),TrayIcon);
    if ( TrayIconMask != XmUNSPECIFIED_PIXMAP )
        XFreePixmap(XtDisplay(wToplevel),TrayIconMask);
}

void AppFrame::vDeleteRButtonMenu()
{
    if ( popup_menu )
    {
        Widget test = popup_menu;
        popup_menu = NULL;     // won't recursive call
        XtUnmanageChild(test); // Get rid of : Warning: XtRemoveGrab asked to remove a widget not on the list
        XtDestroyWidget(test);
    }
}

void AppFrame::vMenuUnmapCallback(Widget menu_item, XtPointer client_data, XtPointer call_data)
{
    AppFrame * me = (AppFrame *) client_data;
    me->vDeleteRButtonMenu();
}

void AppFrame::vRButtonPopupCallback(Widget menu_item, XtPointer client_data, XtPointer call_data)
{
    assert(pAppFrame);
    switch ((int) client_data)
    {
        case 0: // Toggle Scan Selection
            pAppFrame->vToggleScanSelection();
            break;
        case 1: // Exit
            pAppFrame->vQuit();
            break;
        default:
            assert(0);
    }
}
/********************************************************************/
void AppFrame::vInit(int argc,char **argv)
{
    bUseChineseFT=GetIntFromIni(IniFileName,"UseChineseFT",NULL,False);

    wToplevel=XtVaAppInitialize(&app,"transrc",
                NULL,0,&argc,argv,fallback,
                XmNdeleteResponse,XmDO_NOTHING,
                NULL);
    vSetFontPath();
    
    // set Shell's delete menu callbackfunc.
    Atom DELETE_WIN=XmInternAtom(XtDisplay(wToplevel),"WM_DELETE_WINDOW",False);
    XmAddWMProtocolCallback(wToplevel,DELETE_WIN,vDeleteCallback,this);

#ifdef NDEBUG
    // add XError Handler
    InitializeErrorHandlers(app,NULL,NULL);
#endif
    
    oAppCore.wCreate(wToplevel);

    vSetIcon(); // must be here , can't be after XtRealizedWidget().
    XtRealizeWidget(wToplevel);
    
    // I'm the one
    XSetSelectionOwner(XtDisplay(wToplevel),XInternAtom(XtDisplay(wToplevel),ONLYONE,False),
            XtWindow(wToplevel),CurrentTime);

    // add to tray icon if possible
    oTrayIcon.Init(XtDisplay(wToplevel),XtWindow(wToplevel));
    vSetTrayIcon();
    XtAddEventHandler(wToplevel,NoEventMask,True,vTrayMessageCallback,this);
    XtAddEventHandler(wToplevel,StructureNotifyMask,False,vUnmapCallback,this);
    
    // opera add to load last state
    Boolean IsIconic;
    m_XPos=GetIntFromIni(IniFileName,"XPos",NULL,400);
    m_YPos=GetIntFromIni(IniFileName,"YPos",NULL,50);
    m_Width=GetIntFromIni(IniFileName,"Width",NULL,510);
    m_Height=GetIntFromIni(IniFileName,"Height",NULL,280);
    IsIconic=GetIntFromIni(IniFileName,"IsIconic",NULL,False);
    Boolean MinimizeAtStart=GetIntFromIni(IniFileName,"MinimizeAtStart",NULL,False);
    XtVaSetValues (wToplevel, XmNx, m_XPos, XmNy, m_YPos, XmNwidth, m_Width, XmNheight, m_Height, NULL);
    XtVaSetValues (wToplevel, XmNiconic, IsIconic||MinimizeAtStart, NULL);
    
    oAppCore.vAfterRealize();
    pAppFrame = this;
}

/********************************************************************/
void AppFrame::vRaiseUp()
{
    XRaiseWindow(XtDisplay(wToplevel),XtWindow(wToplevel));
    return;
}

void AppFrame::vPopup()
{
    vPutToCurrentWorkSpace();
    XtVaSetValues(wToplevel,XmNiconic,False,NULL);
    XMapRaised(XtDisplay(wToplevel),XtWindow(wToplevel));
}

/********************************************************************/
void AppFrame::vSetIcon()
{
    Pixmap pixIcon=pixGetPixmap(wToplevel,ICONIMAGEFILE_S);
    Pixmap pixIconMask=pixGetBitmap(wToplevel,ICONMASKFILE_S);
    if(pixIcon==XmUNSPECIFIED_PIXMAP || pixIconMask==XmUNSPECIFIED_PIXMAP)
    {
    //    vShowErrorToTerm("can't get icon pixmap !");
        return;
    }

    Window root;
    int x,y;
    unsigned int width,height,border_width,depth;
    Display *display=XtDisplay(wToplevel);
    XGetGeometry(display,pixIcon,&root,&x,&y,&width,&height,
        &border_width,&depth);
    iconWin=XCreateSimpleWindow(display,root,0,
        0,width,height,0,CopyFromParent,CopyFromParent);
    XtVaSetValues(wToplevel,        // set icon Window for toplevel.
        XmNiconWindow,iconWin,
        XmNiconPixmap,pixIcon,      // For KDE
        XmNiconMask,pixIconMask,
        NULL);
    XSetWindowBackgroundPixmap(display,iconWin,pixIcon);
    XShapeCombineMask(display,iconWin,ShapeBounding,0,0,
        pixIconMask,ShapeSet);
    XClearWindow(display,iconWin);
    return;
}

/********************************************************************/
void AppFrame::vSetFontPath()
{
    Display* display=XtDisplay(wToplevel);

    if( bHaveFont(display,bUseChineseFT?HZFONT_FT_S:HZFONT_S) && bHaveFont(display,YBFONT_S) )    
        return;    // font path has been set.

    // get old font path.
    int iOldDirs;
    char **olddirs=XGetFontPath(display,&iOldDirs);

    // copy old dirs
    char **newdirs=new char*[iOldDirs+1];
    int i;
    for(i=0;i<iOldDirs;i++)
    {
        newdirs[i]=olddirs[i];
    }

    // add $TRANSHOME/hzfont to font path.
    char sFontPath[PATH_MAX+1];
    strcpy(sFontPath,sExecDir);
    strncat(sFontPath,FONTDIR_S,PATH_MAX-strlen(sFontPath));
    newdirs[iOldDirs]=sFontPath;
    XSetFontPath(display,newdirs,iOldDirs+1);
    XFreeFontPath(olddirs);
    delete []newdirs;

    //check again
    if ( !bHaveFont(display,bUseChineseFT?HZFONT_FT_S:HZFONT_S) || !bHaveFont(display,YBFONT_S) )
    {
        fprintf(stderr,"\nCan't add fonts to your xserver, are you running under EXCEED or X-Win32?\n"
                       "If so, add font files (at %sFontsForExceed) to EXCEED manually!\n"
                       "Please reference %sdoc/exceed.gif for instruction.\n",sExecDir,sExecDir);
        fprintf(stderr,"\nAnother condition is that the fontdir (%s/%s) can not be read/accessed by everyone.\n"
                       "If so,change it attribute to drwxr-xr-x by chmod\n",sExecDir,FONTDIR_S);
        exit(-1);
    }
    return;
}

/********************************************************************/
void AppFrame::vDeleteCallback(Widget ,XtPointer thisObj,XtPointer )
{
    ((AppFrame *)thisObj)->vQuit();
}

/********************************************************************/
void AppFrame::vQuit()
{
    vDeleteRButtonMenu();
    //check can quit now?
    oAppCore.vEnd(); // maybe block here for a while
    
    //opera add here
    Boolean IsIconic=False;
    XWindowAttributes WindowStatus;
    XtVaGetValues(wToplevel, XmNx, &m_XPos, XmNy, &m_YPos, XmNwidth, &m_Width, XmNheight, &m_Height, NULL);
    XGetWindowAttributes(XtDisplay(wToplevel),XtWindow(wToplevel),&WindowStatus);
    IsIconic = WindowStatus.map_state==IsUnmapped;
    m_XPos -= WindowStatus.x;
    m_YPos -= WindowStatus.y;
    //XtVaGetValues(wToplevel, XmNiconic, &IsIconic, NULL);
    SaveIntToIni(IniFileName,"XPos",m_XPos);
    SaveIntToIni(IniFileName,"YPos",m_YPos);
    SaveIntToIni(IniFileName,"Width",m_Width);
    SaveIntToIni(IniFileName,"Height",m_Height);
    SaveIntToIni(IniFileName,"IsIconic",IsIconic);
    SaveIntToIni(IniFileName,"UseChineseFT",bUseChineseFT);
    
    XSetSelectionOwner(XtDisplay(wToplevel),XInternAtom(XtDisplay(wToplevel),ONLYONE,False),
            None,CurrentTime);

    m_quit = true;
}

/********************************************************************/
void AppFrame::vLoop()
{
    XEvent event;
    while(!m_quit)
    {
        XtAppNextEvent(app,&event);
        if ( !oTrayIcon.bEventFilter(&event) )
            XtDispatchEvent(&event);
    }
    while( XtAppPeekEvent(app,&event) )
    {
        XtAppNextEvent(app,&event);
        XtDispatchEvent(&event);
    }
}

void AppFrame::vProcessXEvent()
{
    XEvent event;
    while ( (XtAppPending(app)&XtIMXEvent) == XtIMXEvent )
    {
        XtAppNextEvent(app,&event);
        XtDispatchEvent(&event);
    }
}

//===================================================================
void vShowErrorToTerm(const char *sMessage)
{
    fputs(sMessage,stdout);
}

//*******************************************************************
// change sMessage to 2 byte string , so I can use Chinese font on it.
char* sChangeTo2Byte(const char* sMessage)
{
    if(sMessage==NULL || sMessage[0]=='\0') return(NULL);
    
    char* sResult=new char[strlen(sMessage)*2+1];
    int iByte;
    int iResultLen=0;
    for(iByte=0;sMessage[iByte]!='\0';iByte++)
    {
        if(bIsChinese(sMessage[iByte]) || sMessage[iByte]=='\n')
        {
            sResult[iResultLen++]=sMessage[iByte]&0x7f;
        }
        else
        {
            sResult[iResultLen++]=0x23;
            sResult[iResultLen++]=sMessage[iByte];
        }
    }
    sResult[iResultLen]='\0';

    return(sResult);
}

//*******************************************************************
// change sMessage back to 1 byte string
char* sReturnTo1Byte(const char* sMessage)
{
    if(sMessage==NULL || sMessage[0]=='\0') return(NULL);
    
    char* sResult=new char[strlen(sMessage)+1];
    int iByte;
    int iResultLen=0;
    for(iByte=0;sMessage[iByte]!='\0';iByte++)
    {
        if ( sMessage[iByte] == 0x23 )
        {
            iByte++;                // skip #
            sResult[iResultLen++] = sMessage[iByte];
        }
        else if ( sMessage[iByte] == '\n' )
            sResult[iResultLen++] = '\n';
        else    //chinese
        {
            sResult[iResultLen++] = sMessage[iByte++]|0x80;
            sResult[iResultLen++] = sMessage[iByte]|0x80;
        }
    }
    sResult[iResultLen]='\0';
    return(sResult);
}

/**
  * Converts an array of Unicode scalar values (code points) into
  * UTF-8. This algorithm works under the assumption that all
  * surrogate pairs have already been converted into scalar code
  * point values within the argument.
  * 
  * @param ch an array of Unicode scalar values (code points)
  * @returns a byte[] containing the UTF-8 encoded characters
  */
const char * UnicodeToUTF8(int * ch)
{
    // determine how many bytes are needed for the complete conversion
    int bytesNeeded = 1;
    for (int i=0; ch[i]; i++)
    {
        if (ch[i] < 0x80)
            ++bytesNeeded;
        else if (ch[i] < 0x0800)
            bytesNeeded += 2;
        else if (ch[i] < 0x10000)
            bytesNeeded += 3;
        else
            bytesNeeded += 4;
    }
    // allocate a byte[] of the necessary size
    char * utf8 = new char[bytesNeeded];
    // do the conversion from character code points to utf-8
    int i,bytes;
    for( i=bytes=0; ch[i]; i++)
    {
        if(ch[i] < 0x80)
            utf8[bytes++] = (char)ch[i];
        else if (ch[i] < 0x0800)
        {
            utf8[bytes++] = (char)(ch[i]>> 6 | 0xC0);
            utf8[bytes++] = (char)(ch[i] & 0x3F | 0x80);
        }
        else if (ch[i] < 0x10000)
        {
            utf8[bytes++] = (char)(ch[i]>> 12 | 0xE0);
            utf8[bytes++] = (char)(ch[i]>> 6 & 0x3F | 0x80);
            utf8[bytes++] = (char)(ch[i] & 0x3F | 0x80);
        }
        else
        {
            utf8[bytes++] = (char)(ch[i]>> 18 | 0xF0);
            utf8[bytes++] = (char)(ch[i]>> 12 & 0x3F | 0x80);
            utf8[bytes++] = (char)(ch[i]>> 6 & 0x3F | 0x80);
            utf8[bytes++] = (char)(ch[i] & 0x3F | 0x80);
        }
    }
    utf8[bytes] = '\0';
    return utf8;
}

void vString2UniString(const char * source, int * dest)
{
    BYTE * s = (BYTE *)source;
    WORD ch;
    while(*s)
    {
        if ( bIsChinese(*s) )
        {
            oGB2UniConvertTable.iConvert( *s,*(s+1), ch );
            *dest++ = ch;
            s++;s++;
        }
        else
            *dest++ = *s++;
    }
    *dest = 0;
}

//*******************************************************************
// xmsCreateChinese change string to XmString,it allow English chars appear
// in a Chinese word.
 
XmString xmsCreateChinese(const char *sMessage)
{
    if(sMessage==NULL || sMessage[0]=='\0') return(NULL);

    char* sResult=sChangeTo2Byte(sMessage);
    XmString xmsResult=XmStringCreateLtoR(sResult,(char *)(bUseChineseFT?"ChineseFT":"Chinese"));
    delete []sResult;

    return(xmsResult);
}

//*******************************************************************
Boolean bHaveFont(Display* display,const char* sFontName)
{
    int count;
    char **list=XListFonts(display,sFontName,1,&count);
    XFreeFontNames(list);

    return(count>0);
}

//*******************************************************************
Boolean bGetExecDir()
{
    // first check env variable
    char* pTransHome=getenv("TRANSHOME");
    if( pTransHome != NULL)
    {
        strcpy(sExecDir,pTransHome);
        int iLen = strlen(sExecDir);
        if ( iLen>1 && iLen<PATH_MAX && sExecDir[iLen-1]!='/' )  // not end with /
            strcat(sExecDir,"/");
        if ( bDirOK(sExecDir) )
            return(True);
        else
        {
            strcpy(sErrorMessage,"You specified an error TRANSHOME environment variable.");
            return(False);
        }
    }

    // getexecname can't be used under solaris 5.5.1 or linux :-(
#ifdef  AT_SUN_EXECNAME
    if ( realpath(getexecname(),sExecDir) )
    {
        // delete exec name, only path!
        char * p = sExecDir + strlen(sExecDir);
        while ( p>sExecDir && *p!='/' )
            p--;
        *(p+1) = '\0';
        if(  bDirOK(sExecDir) )
            return(True);
    }
    strcpy(sErrorMessage,"Can't find where am I!");
#endif
    
    // try /proc/self/exe
    if ( !access("/proc/self/exe",R_OK) )
    {
        int iLen = readlink("/proc/self/exe",sExecDir,sizeof(sExecDir)-1);
        if ( iLen > 0 )
        {
            char * end = sExecDir + iLen - 1;
            while ( *end != '/' )
                end--;
            *(end+1) = '\0';
            if ( bDirOK(sExecDir) )
                return(True);
        }
    }

    // failed to get TRANSHOME
    strcpy(sErrorMessage,"You should specify the TRANSHOME environment variable, for example:\n"
                         "csh:  setenv TRANSHOME /usr/local/stardic\n"
                         "bash: TRANSHOME=/usr/local/stardic\n"
                         "      export TRANSHOME\n");
    return(False);
}

/********************************************************************/
// check whether the Dir is the correct one.
// If there is "dic/" in "sPath",I assume that the Dir is what I want.

Boolean bDirOK(const char* sPath)
{
    if(sPath==NULL) return(False);

    char sFullPath[PATH_MAX+1];
    strcpy(sFullPath,sPath);
    strncat(sFullPath,"dic/",PATH_MAX-strlen(sFullPath));

    struct stat stFileStat;
    int iResult=stat(sFullPath,&stFileStat);

    return(iResult!=-1);
}

/********************************************************************/
void vGetPointerXY(Display* display,int& iX,int& iY,Window &childwindow)
{
    Window rootwindow;
    int winx,winy;
    unsigned int buttons;

    XQueryPointer(display,DefaultRootWindow(display),&rootwindow,
        &childwindow,&iX,&iY,&winx,&winy,&buttons);

    return;
}

/********************************************************************/
Pixmap pixGetBitmap(Widget w,const char *sImageFile)
{
    int status,iX_Hot,iY_Hot;
    unsigned int width,height;
    Pixmap pixmap;

    char sFullImageFile[PATH_MAX+1];
    strcpy(sFullImageFile,sExecDir);
    strncat(sFullImageFile,sImageFile,PATH_MAX-strlen(sFullImageFile));

    Display *display=XtDisplay(w);
    status=XReadBitmapFile(display,DefaultRootWindow(display),
        sFullImageFile,&width,&height,&pixmap,&iX_Hot,&iY_Hot);

    if(status!=BitmapSuccess)
    {
        pixmap=XmUNSPECIFIED_PIXMAP;
    }

    return(pixmap);
}

/********************************************************************/
Pixmap pixCreatePixmap(Widget w,const char *sImageFile,int* piColorLost)
{
    Colormap colormap;
    XtVaGetValues(w,
        XmNcolormap,&colormap,
        NULL);

    char sImageFullFile[PATH_MAX+1];
    if ( *sImageFile ==  '/' )  // abslute path
        strcpy(sImageFullFile,sImageFile);
    else
    {
        strncpy(sImageFullFile,sExecDir,PATH_MAX);
        strncat(sImageFullFile,sImageFile,PATH_MAX-strlen(sImageFullFile));
    }

    PixmapClass oImage(sImageFullFile);
    oImage.vSet(XtScreen(w),colormap);
    oImage.vCreate();

    if(piColorLost!=NULL) *piColorLost=oImage.iGetColorLost();

    return(oImage.pixGetPixmap());
}

/********************************************************************/
Pixmap pixGetPixmap(Widget w,const char *sImageFile)
{
    int iColorLost;
    Pixmap pixmap=pixCreatePixmap(w,sImageFile,&iColorLost);
    if(iColorLost>MAX_COLOR_LOST) pixmap=XmUNSPECIFIED_PIXMAP;
    return(pixmap);
}

/********************************************************************/
Pixmap pixForceGetPixmap(Widget w,const char* sImageFile)
{
    return(pixCreatePixmap(w,sImageFile,NULL));
}

/********************************************************************/
Boolean bContainRule(const char* sWord)
{
    int i;
    for(i=0;sWord[i]!=0;i++)
    {
        if(sWord[i]=='*' || sWord[i]=='?')
        {
            return(True);
        }
    }

    return(False);
}

#ifdef XmNrenderTable
typedef struct {
    char * fonttag;
    char * fontname;
    char * fontcolor_white;
    char * fontcolor_black;
} RenderStruct;

// In case _MOTIF_DEFAULT_LOCALE not defined:
#ifndef _MOTIF_DEFAULT_LOCALE
#define _MOTIF_DEFAULT_LOCALE "_MOTIF_DEFAULT_LOCALE"
#endif

RenderStruct oRenderStruct[]={
#ifdef __linux__
    {_MOTIF_DEFAULT_LOCALE,
            "9x15bold,\
            hz16,\
            *-medium-r-normal-*-gbk-0,\
            *-medium-r-normal-*-iso10646-1",
     NULL, NULL},
#else
    {_MOTIF_DEFAULT_LOCALE, "9x15bold", NULL,                       NULL},
#endif
    {"English",             "9x15bold", NULL,                       NULL},
    {"Chinese",             "hz16",     NULL,                       NULL},
    {"ChineseFT",           "hz16ft",   NULL,                       NULL},
    {"YB",                  "yb10x20",  "#ffc0cb"/*pink*/,          "#8b0000"/*DarkRed*/},
    {"PY",                  "9x15bold", "#00ff7f"/*SpringGreen*/,   "#006400"/*darkgreen*/},
    {"LibName",             "9x15bold", "#add8e6"/*LightBlue*/,     "#4169e1"/*RoyalBlue*/}
};

Pixel ConvertStringToPixel (Widget widget, char *name)
{
    XrmValue from_value, to_value; /* For resource conversion */
    from_value.addr = name;
    from_value.size = strlen(name) + 1;
    to_value.addr = NULL;
    XtConvertAndStore (widget,
        XmRString, &from_value,
        XmRPixel, &to_value);
    
/*    XColor GetColor;
    Colormap ColorMap;
    XtVaGetValues(widget,XmNcolormap,&ColorMap,NULL);
    GetColor.pixel = *((Pixel*) to_value.addr);
    XQueryColor(XtDisplay(widget),ColorMap,&GetColor);
    fprintf(stderr,"%s:%02x,%02x,%02x\n",name,GetColor.red,GetColor.green,GetColor.blue);*/
    
    if (to_value.addr)
        return (*((Pixel*) to_value.addr));
    return XmUNSPECIFIED_PIXEL;
}

void vCreateRendertable(Widget wWidget)
{
    XmRendition Rendition[sizeof(oRenderStruct)/sizeof(RenderStruct)];
    Arg args[4];
    Cardinal n;
    
    for (BYTE iRenditionsCount=0;iRenditionsCount<sizeof(oRenderStruct)/sizeof(RenderStruct);iRenditionsCount++)
    {
        n = 0;
        XFontSet fLoadFontSet = NULL;
        XFontStruct * fLoadFont = NULL;
        if ( strchr(oRenderStruct[iRenditionsCount].fontname,',') )
        {
            char ** missing_charset_list_return;
            int missing_charset_count_return;
            char * def_string_return;
            fLoadFontSet = XCreateFontSet(
                    XtDisplay(wWidget),
                    oRenderStruct[iRenditionsCount].fontname,
                    &missing_charset_list_return,
                    &missing_charset_count_return,
                    &def_string_return );
            if ( fLoadFontSet == NULL )
            {
                fprintf(stderr,"Can not load fontset %s.\nExit!\n",oRenderStruct[iRenditionsCount].fontname);
                exit(1);
            }
            if ( missing_charset_list_return )
            {
                printf("Missing %d charsets in %s:\n",missing_charset_count_return,oRenderStruct[iRenditionsCount].fontname);
                for (int i=0; i<missing_charset_count_return; i++)
                    printf("    %s\n",*(missing_charset_list_return+i));
                XFreeStringList(missing_charset_list_return);
            }
        } else
        {
            fLoadFont = XLoadQueryFont(XtDisplay(wWidget), oRenderStruct[iRenditionsCount].fontname);
            if ( fLoadFont == NULL )
            {
                fprintf(stderr,"Can not load font %s.\nExit!\n",oRenderStruct[iRenditionsCount].fontname);
                exit(1);
            }
        }
        if ( fLoadFontSet )
        {
            XtSetArg(args[n], XmNfont, fLoadFontSet); n++;
            XtSetArg(args[n], XmNfontType, XmFONT_IS_FONTSET); n++;
        } else
        {
            XtSetArg(args[n], XmNfont, fLoadFont); n++;
            XtSetArg(args[n], XmNfontType, XmFONT_IS_FONT); n++;
        }
        XtSetArg(args[n], XmNloadModel, XmLOAD_IMMEDIATE); n++;
        if ( bForegroundIsWhite?oRenderStruct[iRenditionsCount].fontcolor_white:oRenderStruct[iRenditionsCount].fontcolor_black )
        {
            XtSetArg(args[n],
                     XmNrenditionForeground,
                     ConvertStringToPixel( wWidget,
                                           bForegroundIsWhite?oRenderStruct[iRenditionsCount].fontcolor_white:oRenderStruct[iRenditionsCount].fontcolor_black
                                         )
                    );
            n++;
        }
        Rendition[iRenditionsCount] = XmRenditionCreate(wWidget,oRenderStruct[iRenditionsCount].fonttag,args,n);
    }
    
    MyRenderTable = XmRenderTableAddRenditions( NULL,
            Rendition,
            sizeof(oRenderStruct)/sizeof(RenderStruct),
            XmMERGE_NEW);
}
#endif  /* XmNrenderTable */

#ifdef NDEBUG
static void signal_handler(int whatsig)
{
    switch (whatsig)
    {
        case SIGSEGV:
            fprintf(stderr,"\nCatch signal SIGSEGV,exit!\n"
                           "\nYou've probably found a bug in Star Dictionary,"
                           "\nplease send email to wangvisual AT sohu.com to report this bug.\n");
            break;
        case SIGBUS:
            fprintf(stderr,"\nCatch signal SIGBUS\nMaybe their is a NEW version!\nexit!\n");
            break;
        case SIGINT:
            fprintf(stderr,"\nCatch signal SIGINT(^C),exit!\n");
            break;
    }
    if (pAppFrame)
    {
        pAppFrame->vQuit();
        pAppFrame = NULL;
    }
    else
        exit(-1);
}
#endif

static Atom GetLocaleEncodingAtom(Display *dpy)
{
  int ret_status = 0;
  XTextProperty tmp_prop;
  char * tmp_string = "ABC";  /* these are characters in XPCS, so... safe */
  Atom encoding;

  tmp_prop.value = NULL; /* just in case X doesn't do it */
  ret_status = XmbTextListToTextProperty(dpy, &tmp_string, 1,
                        (XICCEncodingStyle)XTextStyle, 
                        &tmp_prop);
  if (ret_status == Success)
    encoding = tmp_prop.encoding;
  else
    encoding = None;      /* XmbTextList... should always be able
                           * to convert XPCS characters; but in
                           * case its broken, this prevents a core
                           * dump.
                           */
  if (tmp_prop.value != NULL) XFree((char *)tmp_prop.value);
  return(encoding);
}

void vTrySetChineseLocale()
{
    bool bInChineseLocale = false;
    // motif 1.2 has no XtSetLanguageProc
    // XtSetLanguageProc(NULL,NULL,NULL);
    char * locale = setlocale(LC_CTYPE,"");
    if ( !locale )
        fprintf(stderr,"Warning: Locale not supported by C library.\n");
    else
    {
        const char * const sChineseLocales[] = {
#ifdef __linux__
                                                    "zh_CN.gbk",
#endif
                                                    "zh_CN.GB2312",
                                                    "zh_CN.GBK",
                                                    "zh_CN.gbk",
                                                    "zh_CN.EUC",
#ifndef __linux__
                                                    "zh_CN.GB18030",
                                                    "zh_CN.gb18030",
#endif
                                                    "zh_CN",
                                                    "zh",
                                                    "chinese",
                                                    "zh_CN.UTF-8",
                                                    "zh_CN.utf8",
                                                    "zh.UTF-8"
                                               };
        for ( unsigned int currentlocale = 0;currentlocale<sizeof(sChineseLocales)/sizeof(char*);currentlocale++)
        {
            if ( strcasecmp(locale,sChineseLocales[currentlocale]) == 0 )
            {
                bInChineseLocale = true;
                break;
            }
        }
        // not in my acceptable locale, try setting it
        if ( !bInChineseLocale )
            for ( unsigned int currentlocale = 0;currentlocale<sizeof(sChineseLocales)/sizeof(char*);currentlocale++)
            {
                if ( setlocale(LC_CTYPE,sChineseLocales[currentlocale]) )
                {
                    bInChineseLocale = true;
                    // for motif apps, the most import thing is to set env's LC_CTYPE, other than 
                    // setlocale directly???
                    static char sSetLocale[256];    // Must be static strings for putenv use!
                    sprintf(sSetLocale,"LC_CTYPE=%s",sChineseLocales[currentlocale]);
                    putenv(sSetLocale);
#ifndef NDEBUG
                    printf("Set locale to \"%s\".\n",sChineseLocales[currentlocale]);
#endif
                    break;
                }
            }
        // if still not chinese locale, set back :(
        if ( !bInChineseLocale )
            setlocale(LC_CTYPE,locale);
    }
    if (!XSupportsLocale())
    {
        fprintf(stderr, "Error: X does not support your locale.\n");
        exit(-1);
    }
    if ( XSetLocaleModifiers("") == NULL )
        fprintf(stderr,"Warning: Can't set X Modifiers.\n");
}

//====================================================================
int main(int argc,char **argv)
{
#ifdef NDEBUG
    //init signal handler
    signal(SIGSEGV,signal_handler);
    signal(SIGBUS,signal_handler);
    signal(SIGINT,signal_handler);
#endif

    bool nogui = false;
    for ( int i=1; i<argc; i++)
    {
        if ( strcasecmp(argv[i],"-nogui") == 0 )
        {
            nogui = true;
            break;
        }
    }
    
    Display *display;   // another connection to display, only to confirm and test
    if ( nogui || (display=XOpenDisplay(NULL))==NULL )
    {
        if ( display == NULL )
            printf("Unable to connect to X server\n");
        printf("Using command line: ( Type exit to quit! )\n");
        vInitCommonData();
        vCommandLineLoop();
        return 0;
    }
    
    // check another instance
    Atom OnlyOne = XInternAtom(display,ONLYONE,False);
    Window another;
    if ( (another=XGetSelectionOwner(display,OnlyOne)) )
    {
        printf("Another instance is already running! Quit...\n");
        // sendmessage();
        XCloseDisplay(display);
        return -1;
    }
    XCloseDisplay(display);
    
    vTrySetChineseLocale();
    vInitCommonData();
    
    // if it is the first time this config version startup, exec config
    if ( GetIntFromIni(IniFileName,"ConfigVersionID",NULL,0) < CONFIG_VERSION_ID )
    {
        SaveIntToIni(IniFileName,"ConfigVersionID",CONFIG_VERSION_ID);
        char execstring[PATH_MAX+1];
        strcpy(execstring,sExecDir);
        strncat(execstring,"config.pl -i",PATH_MAX-11);
        system(execstring);
    }

    AppFrame oAppFrame;
    oAppFrame.vInit(argc,argv);
    oAppFrame.vLoop();

    return 0;
}

void vInitCommonData()
{    
    GetIniFileName(PREF_FILE_NAME,IniFileName);
    if( !bGetExecDir() )
    {
        vShowErrorToTerm(sErrorMessage);
        exit(1);
    }
    
    if( oLibs.iGetLibs() == 0 )
    {
        vShowErrorToTerm("Can't load any dictionary!\n");
        exit(-1);
    }
    
    if( !oUni2GBConvertTable.Init(UNICODETOGB2312_FILE_S)
        || !oGB2UniConvertTable.Init(GB2312TOUNICODE_FILE_S)
        || !oUni2BIG5ConvertTable.Init(UNICODETOBIG5_FILE_S)
        || !oBIG2GBMapTable.Init(BIG5TOGB2312_FILE_S) )
    {
        vShowErrorToTerm(sErrorMessage);
        exit(1);
    }
}

void vCommandLineLoop()
{
    char commandline[MAX_STR_LEN];
    WordItem **  ppWordItem= new WordItem*[oLibs.iGetTotalLibs()];
    int * iRetIndex = new int[oLibs.iGetTotalLibs()];
    int iSearchType;
    int iBufferLen = 16384*oLibs.iGetTotalLibs();
    char * sOutput = new char[iBufferLen];
    int * iUniCode = new int[iBufferLen];
    bool utf8 = true;

    while (true)
    {
        printf("> ");
        if ( fgets(commandline,sizeof(commandline),stdin) )
        {
            if ( commandline[strlen(commandline)-1] == '\n' )
                commandline[strlen(commandline)-1] = '\0';
            if ( !strlen(commandline) )
                continue;
            if ( !strcmp(commandline,"bye") || !strcmp(commandline,"exit") || !strcmp(commandline,"quit") )
                break;
            if ( !strcmp(commandline,"utf8") )
            {
                utf8 = !utf8;
                printf("*** Setting output format to %s.\n",utf8?"UTF8":"Non-UTF8");
                continue;
            }
            
            Boolean bFound = False;
            iSearchType = bIsChinese(commandline[0])?STRING_TYPE_CHINESE:STRING_TYPE_ASCII;
            for (int iLib=0;iLib<oLibs.iGetTotalLibs();iLib++)
            {
                iRetIndex[iLib] = INVALID_INDEX;
                if ( oLibs.bIsOKForSearch(iLib,iSearchType,LIB_SEARCH_TYPE_INDEX) 
                     && oLibs.bSimpleGetWord(commandline,iRetIndex[iLib],iLib,1,iSearchType) )
                {
                    ppWordItem[iLib] = (WordItem *)oLibs.poGetWordItem(iRetIndex[iLib],iLib);
                    bFound = True;
                }
                else
                    ppWordItem[iLib] = (WordItem*)NULL;
            }
            if (bFound==True)
            {
                sOutput[0] = '\0';
                for (int iLib=0;iLib<oLibs.iGetTotalLibs();iLib++)
                {
                    if ( ppWordItem[iLib] )   // yes
                    {
                        strncat(sOutput,oLibs.sGetLibName(iLib),iBufferLen-strlen(sOutput));
                        strncat(sOutput,ppWordItem[iLib]->sGetWord(),iBufferLen-strlen(sOutput));
                        if ( oLibs.cGetLibType(iLib,LIB_TYPE_MARK) == LIB_MARK_PY )       // Pin Yin
                        {
                            strncat(sOutput,"\n",iBufferLen-strlen(sOutput));
                            strncat(sOutput,ppWordItem[iLib]->sGetMark(),iBufferLen-strlen(sOutput));
                        }
                        if ( sOutput[strlen(sOutput)-1]!='\n' && sOutput[strlen(sOutput)-1]!='\r' )
                            strncat(sOutput,"\n",iBufferLen-strlen(sOutput));
                        strncat(sOutput,ppWordItem[iLib]->sGetMeaning(),iBufferLen-strlen(sOutput));
                        if ( sOutput[strlen(sOutput)-1]!='\n' && sOutput[strlen(sOutput)-1]!='\r' )
                            strncat(sOutput,"\n",iBufferLen-strlen(sOutput));
                    }
                }
                if ( !utf8)
                {
                    printf("%s*************************************************\n",sOutput);
                } else
                {
                    vString2UniString(sOutput,iUniCode);
                    char * sUTF8 = (char *)UnicodeToUTF8(iUniCode);
                    printf("%s*************************************************\n",sUTF8);
                    delete [] sUTF8;
                }
            }
            else
                printf("Not found.\n");
        }
    }
    delete [] ppWordItem; ppWordItem = NULL;
    delete [] iRetIndex; iRetIndex = NULL;
    delete [] sOutput; sOutput = NULL;
    delete [] iUniCode; iUniCode = NULL;
}
/************************** END *************************************/
