#include "s2s.h"
#include "client.h"
#include "debug.h"


S2S s2s;


S2S::S2S()
{
	Socket::socketRegistry = &socketRegistry;

	listenSocket = new ListenSocket;
	nameServer = new NameServer;
	sessionManager = new SessionManager;
}

S2S::~S2S()
{
	delete listenSocket;
	delete nameServer;
	delete sessionManager;

	while (!clientList.isEmpty()) {
		Client *c = LIST_ENTRY(clientList.removeHead(), Client, listItem);
		delete c;
	}
}

bool S2S::init(int argc, char *argv[])
{
	option.load(argc, argv);

	sessionManager->connect(option.sm_ip, option.sm_port, 30);
	nameServer->connect(option.named_ip, option.named_port, 30);
	listenSocket->listen(option.s2s_ip, option.s2s_port);

	if (!createSocket(SOCK_STREAM))
		return false;

	if (!bindAddress(option.linqd_ip, option.linqd_port)) {
		ICQ_LOG("Can not bind on port %d\n", option.linqd_port);
		return false;
	}

	listen(sockfd, 5);
	addEvent(SOCKET_READ);

	ICQ_LOG("s2s is now started\n");
	return true;
}

bool S2S::onSocketRead()
{
	int fd = accept(sockfd, NULL, NULL);
	if (fd < 0)
		return false;

	Client *c = new Client(fd);
	clientList.add(&c->listItem);
	return true;
}

void S2S::run()
{
	time_t t;

	while (true) {
		time(&t);

		if (!socketRegistry.poll(t))
			break;
	}
}
