#ifndef __LINQ_SEND_FILE_DLG_H__
#define __LINQ_SEND_FILE_DLG_H__

#include "filesession.h"

#include <gtk/gtk.h>

#include <string>

class CSendFileDlg : public FileSession
{
public:
	CSendFileDlg(TCPSessionBase *tcp);

	virtual const char *getPathName(const char *name, uint32 size);
	virtual void onFileStart();
	virtual void onFileProgress(int n);
	virtual void onFileComplete();

private:
	std::string filePath;
	int start_time;
	uint32 transfer_size;
	GtkWidget *progress_window, *progressbar, *speed_label;

	gint update_progress_timeout;
	static gboolean update_progress_cb(gpointer data);

	static void on_progress_window_delete_event (GtkWidget * widget, GdkEvent  *event, CSendFileDlg *oCSendFileDlg);
	static void on_progress_window_stop_clicked (GtkWidget * widget, CSendFileDlg *oCSendFileDlg);
};

#endif
