#include "config.h"
#include "MainWin.h"
#include "LinqMain.h"
#include "textstream.h"
#include "SysMsgDlg.h"
#include "intl.h"

#include <gdk/gdkkeysyms.h>

MainWin::MainWin()
{
	window = NULL;
	main_menu = NULL;
	status_menu = NULL;
	status_animate_timeout = 0;
}

MainWin::~MainWin()
{
	if (status_animate_timeout)
		gtk_timeout_remove(status_animate_timeout);
	if (main_menu)
		gtk_widget_destroy(main_menu);
	if (status_menu)
		gtk_widget_destroy(status_menu);
	
	contact_view.Destroy();
	gtk_widget_destroy(window);
}

void MainWin::Show()
{		
	if (window) {
		gtk_window_present(GTK_WINDOW(window));
		return;
	}
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_default_size (GTK_WINDOW(window), 100, 300);
	gtk_window_set_title(GTK_WINDOW(window),_("LinQ COOLLL"));
	gtk_window_set_icon(GTK_WINDOW (window), linqMain->skin->linq.icon);
	gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
	g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK (on_delete_event), this);
	g_signal_connect (G_OBJECT (window), "key_press_event", G_CALLBACK (on_key_press_release_event), this);
	g_signal_connect (G_OBJECT (window), "key_release_event", G_CALLBACK (on_key_press_release_event), this);
	
	GtkWidget *vbox;
	vbox = gtk_vbox_new(false,0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(window),vbox);
	
	GtkWidget *notebook;
	notebook= gtk_notebook_new();
	gtk_widget_show(notebook);
	gtk_box_pack_start(GTK_BOX(vbox),notebook,true,true,2);
	GtkWidget *image;
	image = gtk_image_new_from_pixbuf(linqMain->skin->linq.buddy);
	gtk_widget_show(image);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),contact_view.Create(),image);
	image = gtk_image_new_from_pixbuf(linqMain->skin->linq.service);
	gtk_widget_show(image);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),service_view.Create(),image);
	image = gtk_image_new_from_pixbuf(linqMain->skin->linq.mobile);
	gtk_widget_show(image);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),mobile_view.Create(),image);
	image = gtk_image_new_from_pixbuf(linqMain->skin->linq.chain);
	gtk_widget_show(image);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),chain_view.Create(),image);
	
	GtkWidget *hbox;
	hbox = gtk_hbox_new(false,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,false,false,0);
	GtkWidget *button;
	button = gtk_button_new();
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (on_chatroom_button_clicked), this);	
	image = gtk_image_new_from_pixbuf(linqMain->skin->linq.chatroom);
	gtk_container_add(GTK_CONTAINER(button), image);
	gtk_box_pack_start(GTK_BOX(hbox), button,false,false,0);
	button = gtk_button_new();
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (on_search_button_clicked), this);
	GtkWidget *hbox1;
	hbox1 = gtk_hbox_new(false,0);
	image = gtk_image_new_from_pixbuf(linqMain->skin->linq.search);
	gtk_box_pack_start(GTK_BOX(hbox1), image,false,false,0);
	GtkWidget *label;
	label = gtk_label_new(_("Search"));
	gtk_box_pack_start(GTK_BOX(hbox1), label,true,true,0);	
	gtk_container_add(GTK_CONTAINER(button), hbox1);	
	gtk_box_pack_start(GTK_BOX(hbox), button,true,true,0);
	gtk_widget_show_all(hbox);
	
	hbox = gtk_hbox_new(false,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,false,false,2);
	button = gtk_button_new();
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (on_mozilla_button_clicked), this);
	image = gtk_image_new_from_pixbuf(linqMain->skin->linq.mozilla);
	gtk_container_add(GTK_CONTAINER(button), image);
	gtk_box_pack_start(GTK_BOX(hbox), button,false,false,0);
	button = gtk_button_new();
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (on_message_button_clicked), this);
	hbox1 = gtk_hbox_new(false,0);
	image = gtk_image_new_from_pixbuf(linqMain->skin->linq.sysmsg);
	gtk_box_pack_start(GTK_BOX(hbox1), image,false,false,0);
	label = gtk_label_new(_("Message"));
	gtk_box_pack_start(GTK_BOX(hbox1), label,true,true,0);	
	gtk_container_add(GTK_CONTAINER(button), hbox1);	
	gtk_box_pack_start(GTK_BOX(hbox), button,true,true,0);
	gtk_widget_show_all(hbox);
	
	hbox = gtk_hbox_new(false,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,false,false,0);
	button = gtk_button_new();
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (on_menu_button_clicked), this);
	image = gtk_image_new_from_pixbuf(linqMain->skin->linq.main_menu.icon);
	gtk_container_add(GTK_CONTAINER(button), image);
	gtk_box_pack_start(GTK_BOX(hbox), button,false,false,0);
	button = gtk_button_new();
	g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (on_status_button_clicked), this);
	hbox1 = gtk_hbox_new(false,0);
	status_image = gtk_image_new_from_pixbuf(linqMain->skin->linq.status[STATUS_ONLINE]);
	gtk_box_pack_start(GTK_BOX(hbox1), status_image,false,false,0);
	status_label = gtk_label_new(_("Loging"));
	gtk_box_pack_start(GTK_BOX(hbox1), status_label,true,true,0);	
	gtk_container_add(GTK_CONTAINER(button), hbox1);	
	gtk_box_pack_start(GTK_BOX(hbox), button,true,true,0);	
	gtk_widget_show_all(hbox);
	
	gtk_widget_show(window);	
}

void MainWin::Hide()
{
	gtk_widget_hide(window);
}

gboolean MainWin::on_delete_event(GtkWidget * window, GdkEvent *event , MainWin *oMainWin)
{
	linqMain->Quit();
	return true;
}

gboolean MainWin::on_key_press_release_event(GtkWidget * window, GdkEventKey *event , MainWin *oMainWin)
{
	gboolean return_val=true;  //if return TRUE,the widget which in the main window will not receive any keyboard event.

	gboolean only_ctrl_pressed = ((event->state & GDK_CONTROL_MASK)&&(!(event->state & GDK_MOD1_MASK))&&(!(event->state & GDK_SHIFT_MASK)));
	//gboolean only_mod1_pressed = ((event->state & GDK_MOD1_MASK)&&(!(event->state & GDK_CONTROL_MASK))&&(!(event->state & GDK_SHIFT_MASK)));
	if (((event->keyval==GDK_q || event->keyval==GDK_Q) && only_ctrl_pressed)
	   ) {
		if (event->type==GDK_KEY_PRESS)
			linqMain->Quit();
	}
	else {
		return_val = false;
	}

	return return_val;
}

void MainWin::on_chatroom_button_clicked(GtkWidget *button, MainWin *oMainWin)
{
}

void MainWin::on_search_button_clicked(GtkWidget *button, MainWin *oMainWin)
{
	linqMain->ShowSearchDlg();
}

void MainWin::on_mozilla_button_clicked(GtkWidget *button, MainWin *oMainWin)
{
}

void MainWin::on_message_button_clicked(GtkWidget *button, MainWin *oMainWin)
{
}

void MainWin::on_main_menu_netbookmark_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
}

void MainWin::on_main_menu_gourpfriend_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
}

void MainWin::on_main_menu_msghistory_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
}

void MainWin::on_main_menu_memorandum_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
}

void MainWin::on_main_menu_mobilemsg_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
}

void MainWin::on_main_menu_changeskin_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
}

void MainWin::on_main_menu_changeuser_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
}

void MainWin::on_main_menu_regwizard_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
}

void MainWin::on_main_menu_myoption_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
	oMainWin->getInfo(linqMain->myInfo.name.c_str());
}

void MainWin::on_main_menu_sysoption_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
}

void MainWin::on_main_menu_help_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
}

void MainWin::on_main_menu_quit_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
	linqMain->Quit();
}

void MainWin::on_menu_button_clicked(GtkWidget *button, MainWin *oMainWin)
{
	if (!oMainWin->main_menu) {	
		oMainWin->main_menu = gtk_menu_new();
	
		GtkWidget *menuitem;
		menuitem = gtk_image_menu_item_new_with_label(_("Net bookmark"));
		GtkWidget *image;
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.main_menu.netbookmark);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_main_menu_netbookmark_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);

		menuitem = gtk_image_menu_item_new_with_label(_("Group friend"));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.main_menu.gourpfriend);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_main_menu_gourpfriend_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);

		menuitem = gtk_image_menu_item_new_with_label(_("msg log manage"));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.main_menu.msghistory);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_main_menu_msghistory_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);
		
		menuitem = gtk_image_menu_item_new_with_label(_("Memorandum"));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.main_menu.memorandum);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_main_menu_memorandum_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);

		menuitem = gtk_image_menu_item_new_with_label(_("Mobile message"));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.main_menu.mobilemsg);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_main_menu_mobilemsg_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);
		menuitem = gtk_separator_menu_item_new();
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);


		menuitem = gtk_image_menu_item_new_with_label(_("Change Skin"));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.main_menu.changeskin);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_main_menu_changeskin_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);
		menuitem = gtk_separator_menu_item_new();
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);

		menuitem = gtk_image_menu_item_new_with_label(_("Change User"));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.main_menu.changeuser);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_main_menu_changeuser_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);

		menuitem = gtk_image_menu_item_new_with_label(_("Register Wizard"));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.main_menu.regwizard);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_main_menu_regwizard_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);
		menuitem = gtk_separator_menu_item_new();
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);

		menuitem = gtk_image_menu_item_new_with_label(_("My option"));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.main_menu.myoption);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_main_menu_myoption_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);

		menuitem = gtk_image_menu_item_new_with_label(_("System option"));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.main_menu.sysoption);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_main_menu_sysoption_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);
		menuitem = gtk_separator_menu_item_new();
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);

		menuitem = gtk_image_menu_item_new_with_label(_("Help"));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.main_menu.help);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_main_menu_help_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);
		menuitem = gtk_separator_menu_item_new();
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);

		menuitem = gtk_image_menu_item_new_with_label(_("Quit"));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.main_menu.quit);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_main_menu_quit_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->main_menu), menuitem);

		gtk_widget_show_all(oMainWin->main_menu);
	}
	
	gtk_menu_popup(GTK_MENU(oMainWin->main_menu), NULL, NULL, NULL, NULL, 1, gtk_get_current_event_time());
}

void MainWin::on_status_menu_online_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
	oMainWin->changeStatus(STATUS_ONLINE);
}

void MainWin::on_status_menu_invis_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
	oMainWin->changeStatus(STATUS_INVIS);
}

void MainWin::on_status_menu_away_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
	oMainWin->changeStatus(STATUS_AWAY);
}

void MainWin::on_status_menu_offline_activate(GtkMenuItem *menuitem, MainWin *oMainWin)
{
	oMainWin->changeStatus(STATUS_OFFLINE);
}

void MainWin::on_status_button_clicked(GtkWidget *button, MainWin *oMainWin)
{
	if (!oMainWin->status_menu) {	
		oMainWin->status_menu = gtk_menu_new();
	
		GtkWidget *menuitem;
		menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Online"));
		GtkWidget *image;
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.status[STATUS_ONLINE]);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_status_menu_online_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->status_menu), menuitem);
		menuitem = gtk_separator_menu_item_new();
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->status_menu), menuitem);

		
		GtkWidget *awaymenu;
		awaymenu = gtk_menu_new();

		menuitem = gtk_image_menu_item_new_with_label(_("hi,i am away form computer..."));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.status[STATUS_AWAY]);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_status_menu_away_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(awaymenu), menuitem);
		menuitem = gtk_separator_menu_item_new();
		gtk_menu_shell_append(GTK_MENU_SHELL(awaymenu), menuitem);

		menuitem = gtk_image_menu_item_new_with_label(_("working, please don't disturb me"));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.status[STATUS_OFFLINE]);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_status_menu_away_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(awaymenu), menuitem);
		menuitem = gtk_separator_menu_item_new();
		gtk_menu_shell_append(GTK_MENU_SHELL(awaymenu), menuitem);

		menuitem = gtk_image_menu_item_new_with_label(_("i have go eating,wait..."));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.status[STATUS_OFFLINE]);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_status_menu_away_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(awaymenu), menuitem);
		menuitem = gtk_separator_menu_item_new();
		gtk_menu_shell_append(GTK_MENU_SHELL(awaymenu), menuitem);

		menuitem = gtk_image_menu_item_new_with_label(_("No auto reply message..."));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.status[STATUS_OFFLINE]);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_status_menu_away_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(awaymenu), menuitem);
		menuitem = gtk_separator_menu_item_new();
		gtk_menu_shell_append(GTK_MENU_SHELL(awaymenu), menuitem);

		menuitem = gtk_image_menu_item_new_with_label(_("Custom..."));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.main_menu.sysoption);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_status_menu_away_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(awaymenu), menuitem);
		
		menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Away"));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.status[STATUS_AWAY]);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);		
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->status_menu), menuitem);
		
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), awaymenu);		
		
		menuitem = gtk_separator_menu_item_new();
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->status_menu), menuitem);
		

		menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Invisible"));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.status[STATUS_INVIS]);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_status_menu_invis_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->status_menu), menuitem);
		menuitem = gtk_separator_menu_item_new();
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->status_menu), menuitem);

		menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Offline"));
		image = gtk_image_new_from_pixbuf(linqMain->skin->linq.status[STATUS_OFFLINE]);
		gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
		g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_status_menu_offline_activate), oMainWin);
		gtk_menu_shell_append(GTK_MENU_SHELL(oMainWin->status_menu), menuitem);

		gtk_widget_show_all(oMainWin->status_menu);
	}
	
	gtk_menu_popup(GTK_MENU(oMainWin->status_menu), NULL, NULL, NULL, NULL, 1, gtk_get_current_event_time());
}

void MainWin::changeStatus(uint32 status)
{
	if (linqMain->myInfo.now_status != status) {
		if (linqMain->myInfo.now_status == STATUS_OFFLINE) {
			linqMain->myInfo.login_status = status;
			doLogin();
			return;
		}
		else if (status == STATUS_OFFLINE) {
			linqMain->logout();
			linqMain->myInfo.now_status = STATUS_OFFLINE;
		}
		else {
			linqMain->getUDPSession()->changeStatus(status);
			linqMain->myInfo.now_status = status;
		}
		gtk_image_set_from_pixbuf(GTK_IMAGE(status_image), linqMain->skin->linq.status[status]);
		gtk_label_set_text(GTK_LABEL(status_label), status2text(status));
	}
	else {
		if (status == STATUS_OFFLINE) {
			if (status_animate_timeout) {
				gtk_timeout_remove(status_animate_timeout);
				status_animate_timeout = 0;
				gtk_image_set_from_pixbuf(GTK_IMAGE(status_image), linqMain->skin->linq.status[status]);
				gtk_label_set_text(GTK_LABEL(status_label), status2text(status));
			}
		}
	}
}

void MainWin::getInfo(const gchar *name)
{
	std::list<LinqWindow *>::iterator iter;
	for (iter = linqMain->windowList.begin(); iter != linqMain->windowList.end(); ++iter) {
		LinqWindow *win = (LinqWindow *) *iter;
		if (win->type == WIN_VIEW_DETAIL) {
			UserInfoDlg *dlg = (UserInfoDlg *) *iter;
			if (!g_ascii_strcasecmp(dlg->getName(), name)) {
				if (dlg->widgets)
					gtk_window_present(GTK_WINDOW(dlg->widgets->window));
				return;
			}
		}
	}
	
	UserInfoDlg *dlg;
	dlg = new UserInfoDlg(name);
	
	if (g_ascii_strcasecmp(name, linqMain->myInfo.name.c_str())) {
		linqMain->getUDPSession()->getContactInfo(name);
	}
	else {
		linqMain->getUDPSession()->getUserInfo();
	}
}

gboolean MainWin::status_animate_cb(gpointer data)
{
	MainWin *oMainWin = (MainWin*)data;
	static int i = 0;
	i++;
	if (i == 4)
		i = 0;
	gtk_image_set_from_pixbuf(GTK_IMAGE(oMainWin->status_image), linqMain->skin->linq.status[i]);
	return true;
}

void MainWin::doLogin()
{
	if (!status_animate_timeout)
		status_animate_timeout = gtk_timeout_add(STATUS_ANIMATE_TIMOUT_INTERVAL, status_animate_cb, this);
	gtk_label_set_text(GTK_LABEL(status_label), _("Loging"));
	linqMain->connect(linqMain->options.server_host.c_str(), linqMain->options.server_port);	
}

void MainWin::onConnect(bool connected)
{
	if (connected) {
		linqMain->getUDPSession()->preLogin(linqMain->myInfo.name.c_str());
	}
	else {
		if (status_animate_timeout) {
			gtk_timeout_remove(status_animate_timeout);
			status_animate_timeout = 0;
			gtk_image_set_from_pixbuf(GTK_IMAGE(status_image), linqMain->skin->linq.status[STATUS_OFFLINE]);
		}
	}		
}

gboolean MainWin::onPreLoginReply(uint16 sequence, const char *token)
{
	if (sequence > 0) {
		linqMain->login(linqMain->myInfo.name.c_str(), linqMain->myInfo.passwd.c_str(), token, sequence, linqMain->myInfo.login_status);
	}
	else {
		if (status_animate_timeout) {
			gtk_timeout_remove(status_animate_timeout);
			status_animate_timeout = 0;
		}
		linqMain->myInfo.now_status = STATUS_OFFLINE;
		gtk_image_set_from_pixbuf(GTK_IMAGE(status_image), linqMain->skin->linq.status[linqMain->myInfo.now_status]);
		gtk_label_set_text(GTK_LABEL(status_label), status2text(linqMain->myInfo.now_status));
	}
	return true;
}

void MainWin::onLoginReply(uint8 error)
{
	if (status_animate_timeout) {
			gtk_timeout_remove(status_animate_timeout);
			status_animate_timeout = 0;
	}

	switch (error) {
	case LOGIN_SUCCESS:
			linqMain->myInfo.now_status = linqMain->myInfo.login_status;			
			gtk_image_set_from_pixbuf(GTK_IMAGE(status_image), linqMain->skin->linq.status[linqMain->myInfo.now_status]);
			gtk_label_set_text(GTK_LABEL(status_label), status2text(linqMain->myInfo.now_status));
		break;
	case LOGIN_WRONG_PASSWD:
		linqMain->myInfo.now_status = STATUS_OFFLINE;
		gtk_image_set_from_pixbuf(GTK_IMAGE(status_image), linqMain->skin->linq.status[linqMain->myInfo.now_status]);
		gtk_label_set_text(GTK_LABEL(status_label), status2text(linqMain->myInfo.now_status));
		break;
	case LOGIN_INVALID_USER:
		linqMain->myInfo.now_status = STATUS_OFFLINE;
		gtk_image_set_from_pixbuf(GTK_IMAGE(status_image), linqMain->skin->linq.status[linqMain->myInfo.now_status]);
		gtk_label_set_text(GTK_LABEL(status_label), status2text(linqMain->myInfo.now_status));
		break;
	}
}

void MainWin::onContactListReply(const char *result[], int n)
{
}

void MainWin::onUserOnline(const gchar *name)
{
	contact_view.onUserOnline(name);
}

void MainWin::onUserOffline(const gchar *name)
{
	contact_view.onUserOffline(name);
}

void MainWin::onUserStatus(const char *name, uint32 status)
{
	contact_view.onUserStatus(name, status);
}

void MainWin::onAddContactReply(const char *name, uint8 auth)
{
	SysMsgDlg *dlg;
	dlg = new SysMsgDlg;
	dlg->Create();
	dlg->onAddContactReply(name, auth);
}

void MainWin::onRecvMessage(uint8 type, const char *from, time_t when, const char *text)
{	
	tm *t = localtime(&when);
	g_print("received message from %s(%s):", from, t ? asctime(t) : "NULL");

	if (type == MSG_TEXT)
	{
		LinqWindow *win;
		win = linqMain->findWindow(WIN_SEND_MESSAGE);
		SendMsgDlg *dlg;
		if (win) {
			dlg = (SendMsgDlg *)win;
		}
		else {
			dlg = new SendMsgDlg;
		}	
		dlg->Show(from, when, text);	
	}
	else if ((type == MSG_AUTH_ACCEPTED)||(type == MSG_AUTH_REJECTED)||(type == MSG_AUTH_REQUEST)||(type == MSG_ADDED))
	{
		SysMsgDlg *dlg;
		dlg = new SysMsgDlg;
		dlg->Create();
		dlg->onRecvMessage(type, from, when, text);
	}

	if (type == MSG_TCP_REQUEST) {
		TextInStream in(text);
		string type;

		in >> type;
		g_print("%s request you to accept %s", from, type.c_str());

		linqMain->acceptTCPRequest(type.c_str(), from, 0);
	}
}

void MainWin::onContactInfoReply(CONTACT_INFO &c)
{	
	contact_view.onContactInfoReply(c);
	
	std::list<LinqWindow *>::iterator iter;
	for (iter = linqMain->windowList.begin(); iter != linqMain->windowList.end(); ++iter) {
		LinqWindow *win = (LinqWindow *) *iter;
		if (win->type == WIN_VIEW_DETAIL) {
			UserInfoDlg *dlg = (UserInfoDlg *) *iter;
			if (!g_ascii_strcasecmp(dlg->getName(), c.name)) {
				dlg->show(c);
				return;
			}
		}
	}
}

void MainWin::onUserInfoReply(USER_INFO &user)
{
	std::list<LinqWindow *>::iterator iter;
	for (iter = linqMain->windowList.begin(); iter != linqMain->windowList.end(); ++iter) {
		LinqWindow *win = (LinqWindow *) *iter;
		if (win->type == WIN_VIEW_DETAIL) {
			UserInfoDlg *dlg = (UserInfoDlg *) *iter;
			if (!g_ascii_strcasecmp(dlg->getName(), linqMain->myInfo.name.c_str())) {
				dlg->show(user);
				return;
			}
		}
	}
}
