#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys
from getopt import getopt

def utf2sql(ifile, ofile):
	if ifile:
		if not os.path.exists(ifile):
			print >> sys.stderr, "Error: Can not open input file %s!" % ifile
			sys.exit (2)
		try:
			i = file (ifile)
		except:
			print >> sys.stderr, "Error: Can not open input file %s!" % ifile
			sys.exit (2)
	else:
		i = sys.stdin
		
	if ofile:
		try:
			o = file (ofile, 'w')
		except:
			print >> sys.stderr, "Error: Can not open output file %s!" % ofile
	else:
		o = sys.stdout
	o.write ("BEGIN TRANSACTION;\n")
	o.write ("CREATE TABLE data (code TEXT PRIMARY KEY, strokes TEXT);\n")	
	o.write ("COMMIT;\n")
	o.write ("BEGIN TRANSACTION;\n")
	for l in i:
		ul = unicode(l, "utf8")
		for z in ul:
			if z != u"\n":
				o.write((u"INSERT INTO data (code) VALUES( '%s' );\n" % z).encode ("utf-8"))
	o.write("COMMIT;\n")
	print >> sys.stderr, "SQL have been generated."

def usage ():
	print "python utf2sql.py"
	print "\t -h --help			print this message"
	print "\t -i --input=filename		use specify file instead of stdin"
	print "\t -o --output=filename		use specify file instead of stdout"

def main ():
	ifile, ofile = None, None
	try:
		opts, args = getopt (sys.argv[1:], "hi:o:", ["help","input=", "output="])
	except:
		usage ()
		sys.exit (2)
		
	for o, a in opts:
		if o in ("-h", "--help"):
			usage ()
			sys.exit ()
		if o in ("-i", "--input"):
			ifile = a
		if o in ("-o", "--output"):
			ofile = a
	utf2sql (ifile, ofile)	

if __name__ == "__main__":
	main ()
