/*
 * GTK See -- an image viewer based on GTK+
 * Copyright (C) 1998 Hotaru Lee <jkhotaru@mail.sti.com.cn> <hotaru@163.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Code based in WAP WAE Specification Version 24-May-1999
 *
 * 2004-07-01: First development
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "im_wbmp.h"

glong filepos = 0;

guint16
get_guint(FILE *fd)
{
   guint16  octet = 0;
   guchar   byte;

   do
   {
      octet = octet << 7;
      if ((fread(&byte, 1, 1, fd)) != 1) return 0;
      octet |= (byte & 0x7F);
   } while (byte & 0x80);

   return octet;
}

gboolean
wbmp_get_header(gchar *filename, wbmp_info *info)
{
   FILE      *fd;
   guchar    buf[2];
   gboolean  status = FALSE;

   if ((fd = fopen (filename, "rb")) == NULL)
   {
      return FALSE;
   }

   if ((fread(&buf, 1, 1, fd) == 1) &&
       (buf[0] == 0))   /* Only type binary 00 */
   {
      info->typefield = buf[0];

      if ((fread(&buf, 1, 1, fd)) != 1) goto stop_all;

      info->fixheaderfield = buf[0];

      while (buf[0] & 0x80)
      {
         if ((fread(&buf, 1, 1, fd)) != 1) goto stop_all;
      }

      info->width = get_guint(fd);
      info->height= get_guint(fd);

      if (info->width == 0 || info->height== 0)
      {
         status = FALSE;
      } else
      {
         info->ncolors = 1;
         filepos = ftell(fd);
         fseek(fd, 0L, SEEK_END);
         status = ((info->width * info->height) > ftell(fd)) ? TRUE : FALSE;
      }
   }

stop_all:
   fclose(fd);
   return status;
}

gboolean
wbmp_load (gchar *filename, WbmpLoadFunc func)
{
   FILE        *fd;
   wbmp_info   wbmphdr;
   guchar      *buffer;
   gint        i, j, c;

   if (wbmp_get_header(filename, &wbmphdr) == FALSE)
   {
      return FALSE;
   }

   if ((fd = fopen (filename, "rb")) == NULL)
   {
      return FALSE;
   }

   fseek(fd, filepos, SEEK_SET);

   buffer = g_malloc(sizeof(gchar) * wbmphdr.width);

   for (i = 0; i < wbmphdr.height; i++)
   {
      for (j = 0; j < wbmphdr.width; j++)
      {
         if (j % 8 == 0)
         {
            if ((c = fgetc(fd)) == EOF)
            {
               g_free(buffer);
               fclose(fd);
               return FALSE;
            }
         }
         buffer[j] = (c & 0x80) ? 0xFF : 0x00;
         c <<= 1;
      }
      if ((*func) (buffer, wbmphdr.width, 0, i, 1, -1, 0)) break;
   }

/*
   buffer = g_malloc (wbmphdr.width * sizeof(guchar) * 3);

   for (i = 0; i < wbmphdr.height; i++)
   {
      for (j = 0; j < wbmphdr.width*3; j++)
      {
         if (j % 8 == 0)
         {
            if ((c = fgetc(fd)) == EOF)
            {
               g_free(buffer);
               fclose(fd);
               return FALSE;
            }
         }
         buffer[j] =
         buffer[j+1] =
         buffer[j+2]   = (c & 0x80) ? 0xFF : 0x00;
         j += 2;
         c <<= 1;
      }
      if ((*func) (buffer, wbmphdr.width, 0, i, 3, -1, 0)) break;
   }
*/

   g_free(buffer);
   return TRUE;
}
