/*
 * GTK See -- an image viewer based on GTK+
 * Copyright (C) 1998 Hotaru Lee <jkhotaru@mail.sti.com.cn> <hotaru@163.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * 20-06-2004: Functions for Dialog window
 */

#ifndef __DIALOG_H__
#define __DIALOG_H__

#ifdef __cplusplus
        extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>

typedef enum Dialog_Type
{
   OK_DIALOG           ,
   OK_CANCEL_DIALOG    ,
   OK_CANCEL_ALL_DIALOG
} DialogType;

typedef enum Dialog_Pix
{
   DELETE_DIALOG   ,
   ERROR_DIALOG    ,
   FAVORITES_DIALOG,
   QUESTION_DIALOG ,
   RENAME_DIALOG   ,
   WARNING_DIALOG
} DialogPixmap;

typedef enum Dialog_Status
{
   OK_STATUS = 1,
   CANCEL_STATUS,
   ALL_STATUS
} DialogStatus;

DialogStatus dialog_color  (GtkWidget *parentwindow, gchar *title, gint *newcolor);
DialogStatus dialog_message(GtkWidget      *parentwindow,
                              gchar        *title,
                              gchar        *msg,
                              gchar        *msguser,
                              DialogType   type,
                              DialogPixmap pixmaptype,
                              gboolean     useentry,
                              gchar        **str,
                              gint         maxlen);

#ifdef __cplusplus
        }
#endif /* __cplusplus */

#endif
