#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "infodlg.h"

#include "gaim.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <string.h>
#include <stdio.h>

void
myicq_save_contact_info(int is_myself, struct ContactInfo *info)
{
	struct stat st;
	FILE *file;	
	char dir[256];
	
	
	sprintf(dir,"%s/myicq",gaim_user_dir());
	if (stat (dir, &st))
		mkdir (dir,00755);
	sprintf(dir,"%s/myicq/%s",gaim_user_dir(),info->domain);
	if (stat (dir, &st))
		mkdir (dir,00755);
	
	if (is_myself)
		sprintf(dir,"%s/myicq/%lu@%s.dat",gaim_user_dir(),info->uin,info->domain); //if is myself,there contian extra auth information.
	else
		sprintf(dir,"%s/myicq/%s/%lu.dat",gaim_user_dir(),info->domain,info->uin);
	if ((file = fopen (dir, "w")) == NULL)
			return;
	//infact, uin and domain needn't save to file,it can be know from filename.
	fprintf (file, "%u%s%u%u%s%s%s%s%s%s%s%s%u%s%s%s%s",
		info->face,info->nick,info->age,info->gender,info->country,info->province,info->city,info->email,
		info->address,info->zipcode,info->tel,info->name,info->blood
		,info->college,info->occupation,info->homepage,info->intro);		
	if (is_myself)
		fprintf(file,"%u",info->auth);
	fclose (file);
}

static void
info_window_destroy (GtkWidget * widget, gpointer data)
{
	struct gaim_connection *gc = (struct gaim_connection *)data;
	struct myicq_data *md = gc->proto_data;
	GList *list= md->updatingContactInfo;
	struct _updatingContactInfo *updateinfo;

	while (list)
	{
		updateinfo = (struct _updatingContactInfo *)(list->data);
		if (updateinfo->window == widget)
		{
			if (updateinfo->domain)
				g_free(updateinfo->domain);
			g_free(updateinfo);
			md->updatingContactInfo = g_list_remove(md->updatingContactInfo,updateinfo);
			break;
		}
		else
		{
			list = list->next;
		}
	}
}

static void
info_window_deleteevent (GtkWidget * widget, GdkEvent * event, gpointer data)
{
	gtk_widget_destroy (widget);
}

static void
info_window_close (GtkWidget * widget, gpointer data)
{	
	gtk_widget_destroy (GTK_WIDGET(data));
}
	
static void
info_window_refresh (GtkWidget * widget, gpointer data)
{
	struct gaim_connection *gc = (struct gaim_connection *)data;

	struct _updatingContactInfo *updateinfo	= (struct _updatingContactInfo *)g_object_get_data(G_OBJECT(widget),"user_data");
		
	if (updateinfo->refresh_button[3]) //is myself
		myicq_send_packet_updateUser(gc);
	else
		myicq_send_packet_updateContact(updateinfo->uin,updateinfo->domain, gc);
	
	gtk_widget_set_sensitive(updateinfo->refresh_button[0],FALSE);
	gtk_widget_set_sensitive(updateinfo->refresh_button[1],FALSE);
	gtk_widget_set_sensitive(updateinfo->refresh_button[2],FALSE);
	if (updateinfo->refresh_button[3])
		gtk_widget_set_sensitive(updateinfo->refresh_button[3],FALSE);
}

static char* myicq_get_gender_str(int gender)
{
	if (gender==1)
		return _("Male");
	else if (gender==2)
		return _("Female");
	else
		return "-";
}

static int myicq_get_gender_int(const char *gender)
{
	if (!strcmp(gender,_("Male")))
		return 1;
	else if (!strcmp(gender,_("Female")))
		return 2;
	else
		return 0;
}

static char* myicq_get_blood_str(int blood)
{
	switch (blood)
	{
		case 0:
			return "-";
			break;
		case 1:
			return "A";
			break;
		case 2:
			return "B";
			break;
		case 3:
			return "O";
			break;
		case 4:
			return "AB";
			break;
		default:
			return _("Else");
			break;
	}
}

static int myicq_get_blood_int(const char *blood)
{
	if (!strcmp(blood,"-"))
		return 0;
	else if (!strcmp(blood,"A"))
		return 1;
	else if (!strcmp(blood,"B"))
		return 2;
	else if (!strcmp(blood,"O"))
		return 3;
	else if (!strcmp(blood,"AB"))
		return 4;
	else
		return 5;
}

static void
info_window_change (GtkWidget * widget, gpointer data)
{
	struct _updatingContactInfo *updateinfo	= (struct _updatingContactInfo *)g_object_get_data(G_OBJECT(widget),"user_data");
	struct gaim_connection *gc = (struct gaim_connection *)data;
	struct myicq_data *md = gc->proto_data;
	struct ContactInfo info;
	GtkTextIter start, end;
	gchar *str;
		
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(updateinfo->is_modify_passwd)))
	{
		if (strcmp(gc->password,gtk_entry_get_text(GTK_ENTRY(updateinfo->old_password))))
		{
			do_error_dialog(_("Error"), _("Old password is wrong!"), GAIM_ERROR);
			return;
		}
		if (gtk_entry_get_text(GTK_ENTRY(updateinfo->password[0]))[0]=='\0')
		{
			do_error_dialog(_("Error"), _("Password can't be NULL!"), GAIM_ERROR);
			return;
		}
		if (strcmp(gtk_entry_get_text(GTK_ENTRY(updateinfo->password[0])),gtk_entry_get_text(GTK_ENTRY(updateinfo->password[1]))))
		{
			do_error_dialog(_("Error"),_("Your new password is not equal"),GAIM_ERROR);
			return;
		}
		if (strlen(gtk_entry_get_text(GTK_ENTRY(updateinfo->password[0])))> 16)
		{
			do_error_dialog(_("Error"),_("Your new password should no more than 16 char"),GAIM_ERROR);
			return;
		}
	}
		
	
	info.uin = atol(gc->username);
	info.domain = strchr(gc->username,'@')+1;
	info.face = (int) g_object_get_data(G_OBJECT(updateinfo->face),"user_data");
	info.nick = g_locale_from_utf8(gtk_entry_get_text(GTK_ENTRY(updateinfo->nick)),-1,NULL,NULL,NULL);
	info.age = atol(gtk_entry_get_text(GTK_ENTRY(updateinfo->age)));
	info.gender = myicq_get_gender_int(gtk_entry_get_text(GTK_ENTRY(updateinfo->gender)));
	info.country = g_locale_from_utf8(gtk_entry_get_text(GTK_ENTRY(updateinfo->country)),-1,NULL,NULL,NULL);
	info.province = g_locale_from_utf8(gtk_entry_get_text(GTK_ENTRY(updateinfo->province)),-1,NULL,NULL,NULL);
	info.city = g_locale_from_utf8(gtk_entry_get_text(GTK_ENTRY(updateinfo->city)),-1,NULL,NULL,NULL);
	info.email = g_locale_from_utf8(gtk_entry_get_text(GTK_ENTRY(updateinfo->email)),-1,NULL,NULL,NULL);
	info.address = g_locale_from_utf8(gtk_entry_get_text(GTK_ENTRY(updateinfo->address)),-1,NULL,NULL,NULL);
	info.zipcode = g_locale_from_utf8(gtk_entry_get_text(GTK_ENTRY(updateinfo->zipcode)),-1,NULL,NULL,NULL);
	info.tel = g_locale_from_utf8(gtk_entry_get_text(GTK_ENTRY(updateinfo->tel)),-1,NULL,NULL,NULL);
	info.name = g_locale_from_utf8(gtk_entry_get_text(GTK_ENTRY(updateinfo->name)),-1,NULL,NULL,NULL);
	info.blood = myicq_get_blood_int(gtk_entry_get_text(GTK_ENTRY(updateinfo->blood)));
	info.college = g_locale_from_utf8(gtk_entry_get_text(GTK_ENTRY(updateinfo->college)),-1,NULL,NULL,NULL);
	info.occupation = g_locale_from_utf8(gtk_entry_get_text(GTK_ENTRY(updateinfo->occupation)),-1,NULL,NULL,NULL);
	info.homepage = g_locale_from_utf8(gtk_entry_get_text(GTK_ENTRY(updateinfo->homepage)),-1,NULL,NULL,NULL);
	
	gtk_text_buffer_get_bounds(gtk_text_view_get_buffer(GTK_TEXT_VIEW(updateinfo->intro)),&start,&end);
	str = gtk_text_buffer_get_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(updateinfo->intro)),&start,&end,FALSE);
	info.intro = g_locale_from_utf8(str,-1,NULL,NULL,NULL);
	g_free(str);
	
	
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(updateinfo->auth_radio[0])))
		info.auth = 0;
	else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(updateinfo->auth_radio[1])))
		info.auth = 1;
	else
		info.auth = 2;
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(updateinfo->is_modify_passwd)))
		info.is_modify_passwd = 1;
	else
		info.is_modify_passwd = 0;
	if (info.is_modify_passwd == 1)
		info.password = g_locale_from_utf8(gtk_entry_get_text(GTK_ENTRY(updateinfo->password[0])),-1,NULL,NULL,NULL);
	else
		info.password = NULL;
				
	myicq_send_packet_modifyUser(&info, gc);
	myicq_save_contact_info(1,&info);
	
	md->face = info.face; // fresh face and nick
	strcpy(gc->displayname,gtk_entry_get_text(GTK_ENTRY(updateinfo->nick)));
	
	g_free(info.nick);
	g_free(info.country);
	g_free(info.province);
	g_free(info.city);
	g_free(info.email);
	g_free(info.address);
	g_free(info.zipcode);
	g_free(info.tel);
	g_free(info.name);
	g_free(info.college);
	g_free(info.occupation);
	g_free(info.homepage);
	g_free(info.intro);
	if (info.password)
		g_free(info.password);

	gtk_widget_destroy(updateinfo->window); //close window
}

void set_face(GtkWidget *w, struct _updatingContactInfo *updateinfo) 
{
	GdkPixbuf *pixbuf;

	int i;
	i = (int)g_object_get_data(G_OBJECT(w),"user_data");
	g_object_set_data(G_OBJECT(updateinfo->face),"user_data",GINT_TO_POINTER(i));	
	pixbuf = get_face_gdkpixbuf(i*3);
	gtk_image_set_from_pixbuf(GTK_IMAGE(updateinfo->face),pixbuf);
	g_object_unref(pixbuf);
}

static void
info_window_change_face (GtkWidget * widget, GdkEvent * event, struct _updatingContactInfo *updateinfo)
{
	GtkWidget *dialog;
	GtkWidget *vbox, *smiley_box=NULL;
	GtkWidget *image;
	GdkPixbuf *pixbuf;
	GtkWidget *button;
	int i;

	dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(updateinfo->window));
	gtk_window_set_modal(GTK_WINDOW(dialog),TRUE);
	g_signal_connect (G_OBJECT (dialog), "delete_event",
			    G_CALLBACK(info_window_deleteevent), NULL);

	gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
	//gtk_widget_realize(dialog);

	/* setup boxes */
	vbox = gtk_vbox_new(TRUE, 5);

	/* setup buttons */

	/* pack buttons */

	for (i=0;i<85;i++)
	{
		if (i % 8 == 0 )
		{
			smiley_box = gtk_toolbar_new();
			gtk_box_pack_start(GTK_BOX(vbox), smiley_box, TRUE, TRUE, 0);
		}

		pixbuf = get_face_gdkpixbuf(i*3);		
		image = gtk_image_new_from_pixbuf(pixbuf);
		g_object_unref(pixbuf);
		button =
			gtk_toolbar_append_item(GTK_TOOLBAR(smiley_box), NULL, NULL, NULL,
					image, G_CALLBACK(set_face), updateinfo);		
		g_object_set_data(G_OBJECT(button),"user_data",GINT_TO_POINTER(i));
		g_signal_connect (G_OBJECT (button), "clicked",
			    G_CALLBACK(info_window_close), dialog);

		/* these look really weird with borders */
		gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);
	}
	

	gtk_container_add(GTK_CONTAINER(dialog), vbox);
	gtk_container_set_border_width(GTK_CONTAINER(dialog), 5);

	/* show everything */
	gtk_window_set_title(GTK_WINDOW(dialog), _("Choose my head icon"));
	gtk_widget_show_all(dialog);
}

static GtkWidget *
createleftvbox (int is_myself,int index,struct ContactInfo *info,struct gaim_connection *gc,struct _updatingContactInfo *updateinfo)
{
	GtkWidget *vbox1;
	GtkWidget *button;
	
	vbox1 = gtk_vbox_new(FALSE, 0);
	button = gtk_button_new_with_label(_("Close"));
	g_signal_connect (G_OBJECT (button), "clicked",
			    G_CALLBACK(info_window_close), updateinfo->window);
	gtk_box_pack_end(GTK_BOX(vbox1),button,FALSE,FALSE,2);
	button = gtk_button_new_with_label(_("Refresh"));
	updateinfo->refresh_button[index] = button;
	g_object_set_data(G_OBJECT(button),"user_data", (gpointer)updateinfo); //used by info_window_refresh().
	g_signal_connect (G_OBJECT (button), "clicked",
			    G_CALLBACK(info_window_refresh), gc);
	gtk_box_pack_end(GTK_BOX(vbox1),button,FALSE,FALSE,0);
	if (is_myself)
	{
		button = gtk_button_new_with_label(_("Change"));
		g_object_set_data(G_OBJECT(button), "user_data", (gpointer)updateinfo);
		g_signal_connect (G_OBJECT (button), "clicked",
			    G_CALLBACK(info_window_change), gc);
	}
	else
	{
		button = gtk_button_new_with_label(_("Remarks"));
	}
	gtk_box_pack_end(GTK_BOX(vbox1),button,FALSE,FALSE,2);
	return vbox1;
}

static GList *get_list_by_str(gchar *str)
{
	GList *cbitems = NULL;
	gchar *a,*b;
	b = str;
	a = strchr(str,'\n');
	while (a)
	{
		*a = '\0';
		cbitems = g_list_append (cbitems, b);
		b = a+1;
		a = strchr(b,'\n');
	}
	cbitems = g_list_append (cbitems, b);
	return cbitems;
}

static GtkWidget *
createpage1 (int is_myself,struct ContactInfo *info, struct gaim_connection *gc,struct _updatingContactInfo *updateinfo)
{
	char msg[256];
	char *str;
	GtkWidget *hbox;
	GtkWidget *pixmap;
	GdkPixbuf *pixbuf;
	GList *cbitems = NULL;
	gchar *cbitems_str;
	GtkWidget *frame;
	GtkWidget *label;
	GtkWidget *table;
	GtkWidget *entry;
	GtkWidget *combo;
	
	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),createleftvbox(is_myself,0,info,gc,updateinfo),FALSE,FALSE,3);
	frame = gtk_frame_new(_("Basic information"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(hbox),frame,TRUE,TRUE,0);
	table = gtk_table_new(7,4,FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 5);
	gtk_container_add (GTK_CONTAINER (frame), table);
	label = gtk_label_new(_("Head icon:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,0,1,GTK_FILL,0,0,0);
	pixbuf = get_face_gdkpixbuf((info->face)*3);
	pixmap = gtk_image_new_from_pixbuf(pixbuf);
	updateinfo->face = pixmap;
	g_object_unref(pixbuf);
	if (is_myself)
	{
		GtkWidget *event_box;
		g_object_set_data(G_OBJECT(updateinfo->face),"user_data",GINT_TO_POINTER((gint)info->face));	
		event_box = gtk_event_box_new();
		g_signal_connect (G_OBJECT (event_box), "button_press_event",
			    G_CALLBACK(info_window_change_face), updateinfo);
		gtk_container_add(GTK_CONTAINER(event_box),pixmap);
		gtk_table_attach(GTK_TABLE(table),event_box,0,1,1,3,GTK_FILL,0,0,0);
	}
	else
	{
		gtk_table_attach(GTK_TABLE(table),pixmap,0,1,1,3,GTK_FILL,0,0,0);
	}
	label = gtk_label_new(_("User number:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1, .5);
	gtk_table_attach(GTK_TABLE(table),label,1,2,1,2,GTK_FILL,0,0,0);
	label = gtk_label_new(_("User nick:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1, .5);
	gtk_table_attach(GTK_TABLE(table),label,1,2,2,3,GTK_FILL,0,0,0);
	entry = gtk_entry_new();
	updateinfo->uin_entry = entry;
	sprintf(msg,"%lu@%s",info->uin,info->domain);
	gtk_entry_set_text(GTK_ENTRY(entry),msg);
	gtk_widget_set_size_request (entry, 120, -1);
	gtk_table_attach(GTK_TABLE(table),entry,2,4,1,2,GTK_FILL,0,2,0);
	entry = gtk_entry_new();
	updateinfo->nick = entry;
	str = g_locale_to_utf8(info->nick,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(entry),str);
	g_free(str);
	gtk_widget_set_size_request (entry, 120, -1);
	gtk_table_attach(GTK_TABLE(table),entry,2,4,2,3,GTK_FILL,0,2,2);
	label = gtk_label_new(_("Country/Region"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,2,3,4,GTK_FILL,0,2,0);
	label = gtk_label_new(_("Age"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,2,3,3,4,GTK_FILL,0,2,0);
	label = gtk_label_new(_("Gender"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,3,4,3,4,GTK_FILL,0,2,0);
	combo = gtk_combo_new();
	cbitems_str = g_strdup(_("America\nBelgium\nChina\nEngland\nFrance\nGermany\nJapan"));
	cbitems = get_list_by_str(cbitems_str);
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), cbitems);
	g_list_free(cbitems);
	cbitems = NULL;
	g_free(cbitems_str);
	updateinfo->country = GTK_COMBO(combo)->entry;
	str = g_locale_to_utf8(info->country,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),str);
	g_free(str);
	gtk_widget_set_size_request (combo, 150, -1);
	gtk_table_attach(GTK_TABLE(table),combo,0,2,4,5,GTK_FILL,0,2,0);
	entry = gtk_entry_new();
	updateinfo->age = entry;
	sprintf(msg,"%d",info->age);
	gtk_entry_set_text(GTK_ENTRY(entry),msg);
	gtk_widget_set_size_request (entry, 40, -1);
	gtk_table_attach(GTK_TABLE(table),entry,2,3,4,5,GTK_FILL,0,2,0);
	combo = gtk_combo_new();
	cbitems = g_list_append (cbitems, "-");
	cbitems = g_list_append (cbitems, _("Male"));
	cbitems = g_list_append (cbitems, _("Female"));
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), cbitems);
	g_list_free(cbitems);
	cbitems = NULL;
	updateinfo->gender = GTK_COMBO(combo)->entry;
	gtk_widget_set_size_request (combo, 60, -1);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),myicq_get_gender_str(info->gender));
	gtk_editable_set_editable(GTK_EDITABLE(GTK_COMBO(combo)->entry),FALSE);
	gtk_table_attach(GTK_TABLE(table),combo,3,4,4,5,GTK_FILL,0,2,0);
	label = gtk_label_new(_("Province"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,2,5,6,GTK_FILL,0,2,2);
	label = gtk_label_new(_("City"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,2,4,5,6,GTK_FILL,0,2,2);
	combo = gtk_combo_new();
	cbitems_str = g_strdup(_("province\nlist"));
	cbitems = get_list_by_str(cbitems_str);
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), cbitems);
	g_list_free(cbitems);
	cbitems = NULL;
	g_free(cbitems_str);
	updateinfo->province = GTK_COMBO(combo)->entry;
	str = g_locale_to_utf8(info->province,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),str);
	g_free(str);
	gtk_widget_set_size_request (combo, 150, -1);
	gtk_table_attach(GTK_TABLE(table),combo,0,2,6,7,GTK_FILL,0,2,0);
	entry = gtk_entry_new();
	updateinfo->city = entry;
	gtk_widget_set_size_request (entry, 120, -1);
	str = g_locale_to_utf8(info->city,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(entry),str);
	g_free(str);
	gtk_table_attach(GTK_TABLE(table),entry,2,4,6,7,GTK_FILL,0,2,0);
	return hbox;
}

static GtkWidget *
createpage2 (int is_myself,struct ContactInfo *info, struct gaim_connection *gc,struct _updatingContactInfo *updateinfo)
{
	gchar *str;
	GtkWidget *hbox1;
	GtkWidget *entry;
	GtkWidget *label;
	GtkWidget *hbox;
	GtkWidget *radio;
	GtkWidget *table;
	GtkWidget *vbox1;
	GtkWidget *frame;
	
	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),createleftvbox(is_myself,1,info,gc,updateinfo),FALSE,FALSE,3);
	vbox1 = gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox1,TRUE,TRUE,0);
	frame = gtk_frame_new(_("Connection method"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox1),frame,TRUE,TRUE,0);
	table = gtk_table_new(2,4,FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 5);
	gtk_container_add (GTK_CONTAINER (frame), table);
	label = gtk_label_new(_("Email:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,0,1,GTK_FILL,0,0,0);
	label = gtk_label_new(_("Address:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,1,2,GTK_FILL,0,0,0);
	label = gtk_label_new(_("Zip Code:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,2,3,GTK_FILL,0,0,0);
	label = gtk_label_new(_("Telphone:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,3,4,GTK_FILL,0,0,0);

	entry = gtk_entry_new();
	updateinfo->email = entry;
	str = g_locale_to_utf8(info->email,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(entry),str);
	g_free(str);
	gtk_table_attach(GTK_TABLE(table),entry,1,2,0,1,GTK_FILL,0,0,0);
	entry = gtk_entry_new();
	updateinfo->address = entry;
	str = g_locale_to_utf8(info->address,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(entry),str);
	g_free(str);
	gtk_table_attach(GTK_TABLE(table),entry,1,2,1,2,GTK_FILL,0,0,2);
	entry = gtk_entry_new();
	updateinfo->zipcode = entry;
	str = g_locale_to_utf8(info->zipcode,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(entry),str);
	g_free(str);
	gtk_table_attach(GTK_TABLE(table),entry,1,2,2,3,0,0,0,0);
	entry = gtk_entry_new();
	updateinfo->tel = entry;
	str = g_locale_to_utf8(info->tel,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(entry),str);
	g_free(str);
	gtk_table_attach(GTK_TABLE(table),entry,1,2,3,4,0,0,0,2);

	frame = gtk_frame_new(_("These information"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_widget_set_sensitive(frame,FALSE);
	gtk_box_pack_start(GTK_BOX(vbox1),frame,FALSE,FALSE,0);
	
	hbox1 = gtk_hbox_new(FALSE,5);
	gtk_container_add (GTK_CONTAINER (frame), hbox1);
	radio = gtk_radio_button_new_with_label(NULL,_("complete open"));
	gtk_box_pack_start(GTK_BOX(hbox1),radio,FALSE,FALSE,0);
	radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio),_("only friends can see"));
	gtk_box_pack_start(GTK_BOX(hbox1),radio,FALSE,FALSE,0);
	radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio),_("complte close"));
	gtk_box_pack_start(GTK_BOX(hbox1),radio,FALSE,FALSE,0);	

	return hbox;
}

static GtkWidget *
createpage3 (int is_myself,struct ContactInfo *info, struct gaim_connection *gc,struct _updatingContactInfo *updateinfo)
{
	gchar *str;
	GtkWidget *text;
	GtkWidget *hbox;
	GtkWidget *frame;
	GList *cbitems = NULL;
	gchar *cbitems_str;
	GtkWidget *combo;
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget *entry;
	GtkWidget *scrolled_window;
	
	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),createleftvbox(is_myself,2,info,gc,updateinfo),FALSE,FALSE,3);
	frame = gtk_frame_new(_("Detail information"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(hbox),frame,TRUE,TRUE,0);
	table = gtk_table_new(8,2,FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 5);
	gtk_container_add (GTK_CONTAINER (frame), table);
	label = gtk_label_new(_("Real name"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,0,1,GTK_FILL,0,2,2);
	label = gtk_label_new(_("Blood type"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,1,2,0,1,GTK_FILL,0,2,2);
	label = gtk_label_new(_("College"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,2,3,GTK_FILL,0,2,2);
	label = gtk_label_new(_("Occupation"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,1,2,2,3,GTK_FILL,0,2,2);
	label = gtk_label_new(_("Home page:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,2,4,5,GTK_FILL,0,2,2);
	label = gtk_label_new(_("Self-Introduce:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,2,6,7,GTK_FILL,0,2,2);

	entry = gtk_entry_new();
	updateinfo->name = entry;
	str = g_locale_to_utf8(info->name,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(entry),str);
	g_free(str);
	gtk_table_attach(GTK_TABLE(table),entry,0,1,1,2,GTK_FILL,0,2,0);
	entry = gtk_entry_new();
	updateinfo->college = entry;
	str = g_locale_to_utf8(info->college,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(entry),str);
	g_free(str);
	gtk_table_attach(GTK_TABLE(table),entry,0,1,3,4,GTK_FILL,0,2,2);
	entry = gtk_entry_new();
	updateinfo->homepage = entry;
	str = g_locale_to_utf8(info->homepage,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(entry),str);
	g_free(str);
	gtk_table_attach(GTK_TABLE(table),entry,0,2,5,6,GTK_FILL,0,2,0);

	combo = gtk_combo_new();
	cbitems = g_list_append (cbitems, "-");
	cbitems = g_list_append (cbitems, "A");
	cbitems = g_list_append (cbitems, "B");
	cbitems = g_list_append (cbitems, "O");
	cbitems = g_list_append (cbitems, "AB");
	cbitems = g_list_append (cbitems, _("Else"));
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), cbitems);
	g_list_free(cbitems);
	updateinfo->blood = GTK_COMBO(combo)->entry;
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),myicq_get_blood_str(info->blood));
	gtk_widget_set_size_request (combo, 90, -1);
	gtk_editable_set_editable(GTK_EDITABLE(GTK_COMBO(combo)->entry),FALSE);
	gtk_table_attach(GTK_TABLE(table),combo,1,2,1,2,GTK_FILL,0,2,0);
	combo = gtk_combo_new();
	cbitems_str = g_strdup(_("occupation\nlist"));
	cbitems = get_list_by_str(cbitems_str);
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), cbitems);
	g_list_free(cbitems);
	cbitems = NULL;
	g_free(cbitems_str);
	updateinfo->occupation = GTK_COMBO(combo)->entry;
	str = g_locale_to_utf8(info->occupation,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),str);
	g_free(str);
	gtk_widget_set_size_request (combo, 90, -1);
	gtk_table_attach(GTK_TABLE(table),combo,1,2,3,4,GTK_FILL,0,2,0);

	text = gtk_text_view_new();
	updateinfo->intro = text;
	gtk_widget_set_size_request (text, -1, 50);
	str = g_locale_to_utf8(info->intro,-1,NULL,NULL,NULL);
	gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(text)),str,-1);
	g_free(str);

	scrolled_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(scrolled_window),text);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolled_window), GTK_SHADOW_IN);
	gtk_text_view_set_left_margin (GTK_TEXT_VIEW (text), 2);
	gtk_text_view_set_right_margin (GTK_TEXT_VIEW (text), 2);
	
	gtk_table_attach(GTK_TABLE(table),scrolled_window,0,2,7,8,GTK_FILL,0,2,0);
	return hbox;
}

static GtkWidget *
createpage4 (int is_myself,struct ContactInfo *info, struct gaim_connection *gc,struct _updatingContactInfo *updateinfo)
{
	GtkWidget *label;
	label = gtk_label_new(_("gaim-myicq-0.6.0\n\nmyicq is maintaind by ZhangYong <z-yong163@163.com>\nhttp://myicq.cosoft.org.cn\n\ngaim's myicq plug-in is maintaind by\nHuZheng <huzheng_001@163.com>\nhttp://forlinux.yeah.net\n\nReleased under the GNU Public License"));
	return label;
}

static void change_passwd_checkbutton_callback(GtkWidget *widget,struct _updatingContactInfo *updateinfo)
{
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
	{
		gtk_widget_set_sensitive(updateinfo->old_password,TRUE);
		gtk_widget_set_sensitive(updateinfo->password[0],TRUE);
		gtk_widget_set_sensitive(updateinfo->password[1],TRUE);
	}
	else
	{
		gtk_widget_set_sensitive(updateinfo->old_password,FALSE);
		gtk_widget_set_sensitive(updateinfo->password[0],FALSE);
		gtk_widget_set_sensitive(updateinfo->password[1],FALSE);
	}
}

static GtkWidget *
createpage5 (int is_myself,struct ContactInfo *info, struct gaim_connection *gc,struct _updatingContactInfo *updateinfo)
{
	GtkWidget *hbox;
	GtkWidget *frame;
	GtkWidget *vbox2;
	GtkWidget *entry;
	GtkWidget *vbox1;
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget *check_button;
	GtkWidget *radio;
	
	
	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),createleftvbox(is_myself,3,info,gc,updateinfo),FALSE,FALSE,3);
	vbox1 = gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),vbox1,TRUE,TRUE,0);
	check_button = gtk_check_button_new_with_label(_("i want to make my personal detail information securately"));
	gtk_box_pack_start(GTK_BOX(vbox1),check_button,FALSE,FALSE,5);
	gtk_widget_set_sensitive(check_button,FALSE);
	frame = gtk_frame_new(_("Change password"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox1),frame,FALSE,FALSE,0);
	table = gtk_table_new(2,4,FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 5);
	gtk_container_add (GTK_CONTAINER (frame), table);
	label = gtk_label_new(_("Old password:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,1,2,0,1,GTK_FILL,0,2,2);
	label = gtk_label_new(_("New password:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,0,1,2,3,GTK_FILL,0,2,2);
	label = gtk_label_new(_("Password confirm:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_table_attach(GTK_TABLE(table),label,1,2,2,3,GTK_FILL,0,2,2);

	check_button = gtk_check_button_new_with_label(_("Change password"));
	updateinfo->is_modify_passwd = check_button;
	g_signal_connect (G_OBJECT (check_button),
   			   "toggled", G_CALLBACK (change_passwd_checkbutton_callback), updateinfo);   			   
	gtk_table_attach(GTK_TABLE(table),check_button,0,1,1,2,GTK_FILL,0,2,0);
	
	entry = gtk_entry_new();
	gtk_entry_set_visibility(GTK_ENTRY(entry),FALSE);
	gtk_widget_set_sensitive(entry,FALSE);
	updateinfo->old_password = entry;
	gtk_widget_set_size_request (entry, 120, -1);
	gtk_table_attach(GTK_TABLE(table),entry,1,2,1,2,GTK_FILL,0,2,0);
	entry = gtk_entry_new();
	gtk_entry_set_visibility(GTK_ENTRY(entry),FALSE);
	gtk_widget_set_sensitive(entry,FALSE);
	updateinfo->password[0] = entry;
	gtk_widget_set_size_request (entry, 120, -1);
	gtk_table_attach(GTK_TABLE(table),entry,0,1,3,4,GTK_FILL,0,2,2);
	entry = gtk_entry_new();
	gtk_entry_set_visibility(GTK_ENTRY(entry),FALSE);
	gtk_widget_set_sensitive(entry,FALSE);
	updateinfo->password[1] = entry;
	gtk_widget_set_size_request (entry, 120, -1);
	gtk_table_attach(GTK_TABLE(table),entry,1,2,3,4,GTK_FILL,0,2,0);

	frame = gtk_frame_new(_("Authorization"));
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_box_pack_start(GTK_BOX(vbox1),frame,FALSE,FALSE,0);
	
	vbox2 = gtk_vbox_new(FALSE,1);
	gtk_container_add (GTK_CONTAINER (frame), vbox2);
	radio = gtk_radio_button_new_with_label(NULL,_("anyone can add me to their contact lists"));
	updateinfo->auth_radio[0] = radio;
	gtk_box_pack_start(GTK_BOX(vbox2),radio,FALSE,FALSE,0);
	radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio),_("authorization is required"));
	if (info->auth == 1)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio),TRUE);
	updateinfo->auth_radio[1] = radio;
	gtk_box_pack_start(GTK_BOX(vbox2),radio,FALSE,FALSE,0);
	radio = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(radio),_("none can add me to their contact lists"));
	updateinfo->auth_radio[2] = radio;
	if (info->auth == 2)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio),TRUE);
	gtk_box_pack_start(GTK_BOX(vbox2),radio,FALSE,FALSE,0);	

	return hbox;
}

void
myicq_show_contact_info_dialog(struct ContactInfo *info, struct gaim_connection *gc,struct _updatingContactInfo *updateinfo)
{
	int is_myself;
	GtkWidget *label;	
	GtkWidget *window;
	GtkWidget *notebook;
	
	is_myself = ((info->uin== atol(gc->username)) && (!strcasecmp(info->domain,strchr(gc->username,'@')+1)));
	
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	
	updateinfo->window = window;

	g_signal_connect (G_OBJECT (window), "delete_event",
			    G_CALLBACK(info_window_deleteevent), NULL);
	g_signal_connect (G_OBJECT (window), "destroy",
			    G_CALLBACK(info_window_destroy), gc);
	gtk_window_set_resizable (GTK_WINDOW (window), FALSE);
	if (is_myself)
		gtk_window_set_title (GTK_WINDOW (window), _("View my information"));
	else
		gtk_window_set_title (GTK_WINDOW (window), _("View contact's information"));
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);

	notebook= gtk_notebook_new();
	gtk_container_add (GTK_CONTAINER (window), notebook);
	
	
	//gtk_widget_realize(window); //in createpage1,it need to create pixmap,so need window realize.
	label = gtk_label_new (_("Basic information"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), createpage1 (is_myself,info,gc,updateinfo), label);

	label = gtk_label_new (_("Connection method"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), createpage2 (is_myself,info,gc,updateinfo), label);

	label = gtk_label_new (_("Detail information"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), createpage3 (is_myself,info,gc,updateinfo), label);

	if (is_myself)
	{
		label = gtk_label_new (_("Network safety"));
		gtk_notebook_append_page (GTK_NOTEBOOK (notebook), createpage5 (is_myself,info,gc,updateinfo), label);
	}
	else
	{
		updateinfo->refresh_button[3] = NULL;
		label = gtk_label_new (_("About myicq"));
		gtk_notebook_append_page (GTK_NOTEBOOK (notebook), createpage4 (is_myself,info,gc,updateinfo), label);
	}
	
	gtk_widget_show_all(window);
}

void
myicq_refresh_contact_info_dialog(struct ContactInfo *info, struct gaim_connection *gc,struct _updatingContactInfo *updateinfo)
{
	char msg[256];
	GdkPixbuf *pixbuf;
	gchar *text;
	
	gtk_widget_set_sensitive(updateinfo->refresh_button[0],TRUE);
	gtk_widget_set_sensitive(updateinfo->refresh_button[1],TRUE);
	gtk_widget_set_sensitive(updateinfo->refresh_button[2],TRUE);
	if (updateinfo->refresh_button[3]) //is view myself's information
	{
		gtk_widget_set_sensitive(updateinfo->refresh_button[3],TRUE);
		g_object_set_data(G_OBJECT(updateinfo->face),"user_data",GINT_TO_POINTER((gint)info->face));
		if (info->auth == 0)
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(updateinfo->auth_radio[0]),TRUE);
		else if (info->auth == 1)
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(updateinfo->auth_radio[1]),TRUE);
		else
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(updateinfo->auth_radio[2]),TRUE);
	}
	
	pixbuf = get_face_gdkpixbuf((info->face)*3);
	gtk_image_set_from_pixbuf(GTK_IMAGE(updateinfo->face),pixbuf);
	g_object_unref(pixbuf);
	
	sprintf(msg,"%lu@%s",info->uin,info->domain);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->uin_entry),msg);
	text = g_locale_to_utf8(info->nick,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->nick),text);
	g_free(text);
	text = g_locale_to_utf8(info->country,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->country),text);
	g_free(text);
	sprintf(msg,"%d",info->age);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->age),msg);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->gender),myicq_get_gender_str(info->gender));
	text = g_locale_to_utf8(info->province,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->province),text);
	g_free(text);
	text = g_locale_to_utf8(info->city,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->city),text);
	g_free(text);
	text = g_locale_to_utf8(info->email,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->email),text);
	g_free(text);
	text = g_locale_to_utf8(info->address,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->address),text);
	g_free(text);
	text = g_locale_to_utf8(info->zipcode,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->zipcode),text);
	g_free(text);
	text = g_locale_to_utf8(info->tel,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->tel),text);
	g_free(text);
	text = g_locale_to_utf8(info->name,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->name),text);
	g_free(text);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->blood),myicq_get_blood_str(info->blood));	
	text = g_locale_to_utf8(info->college,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->college),text);
	g_free(text);
	text = g_locale_to_utf8(info->occupation,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->occupation),text);
	g_free(text);
	text = g_locale_to_utf8(info->homepage,-1,NULL,NULL,NULL);
	gtk_entry_set_text(GTK_ENTRY(updateinfo->homepage),text);
	g_free(text);
	text = g_locale_to_utf8(info->intro,-1,NULL,NULL,NULL);
	gtk_text_buffer_set_text (gtk_text_view_get_buffer(GTK_TEXT_VIEW(updateinfo->intro)), text, -1);
	g_free(text);
}
	
static void
sendfile_window_stop (GtkWidget * widget, gpointer data)
{
	myicq_tcpfileconnection_kill((struct myicq_tcpfileconnection *)data);
}

static void
sendfile_window_delete_event (GtkWidget * widget, GdkEvent  *event, gpointer data)
{
	myicq_tcpfileconnection_kill((struct myicq_tcpfileconnection *)data);
}

void
myicq_show_send_file_progress(struct myicq_tcpfileconnection *mtfc)
{
	GtkWidget *label,*button;	
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *progressbar;
	char text[256];
	gchar *filename;
	
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	
	mtfc->window = window;

	g_signal_connect (G_OBJECT (window), "delete_event",
			    G_CALLBACK(sendfile_window_delete_event), mtfc);
	gtk_window_set_resizable (GTK_WINDOW (window), FALSE);
	if (mtfc->isSend)
		gtk_window_set_title (GTK_WINDOW (window), _("Sending file"));
	else
		gtk_window_set_title (GTK_WINDOW (window), _("Receiving file"));
	gtk_container_set_border_width (GTK_CONTAINER (window), 8);

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add (GTK_CONTAINER (window), vbox);
	
	filename = g_filename_to_utf8(mtfc->filename,-1,NULL,NULL,NULL);
	if (mtfc->isSend)
		sprintf(text,_("Sending file. %s size: %lu bytes"),filename,mtfc->filesize);
	else
		sprintf(text,_("Receiving file. %s size: %lu bytes"),filename,mtfc->filesize);
	g_free(filename);
	label = gtk_label_new(text);
	gtk_box_pack_start_defaults(GTK_BOX(vbox),label);
	
	progressbar = gtk_progress_bar_new();
	mtfc->progressbar = progressbar;
	gtk_box_pack_start_defaults(GTK_BOX(vbox),progressbar);
	
	label = gtk_label_new(_("Waiting..."));
	mtfc->speed_label = label;
	gtk_box_pack_start_defaults(GTK_BOX(vbox),label);
	
	button = gtk_button_new_with_label(_("stop"));
	gtk_box_pack_start_defaults(GTK_BOX(vbox),button);
	g_signal_connect (G_OBJECT (button), "clicked",
			    G_CALLBACK(sendfile_window_stop), mtfc);
	
	gtk_widget_show_all(window);
}
