#!/usr/bin/env python
# -*- coding: utf-8 -*-
import gobject
import gtk
from gtk import gdk
from gtk import glade
from canvas import Canvas
from clipboard import clipboard

#   columns
(
COLUMN_NUMBER,
COLUMN_STROKE,
) = range (2)

targets = [
	('MY_TREE_MODEL_ROW', gtk.TARGET_SAME_WIDGET, 0),
]

class WorkView (gtk.Frame):
	
	__gsignals__ = {
	'strokes-changed': (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE,
				())
	}

	def __init__ (self, config):
		gtk.Frame.__init__ (self)
		self._xml = glade.XML ("ui/workview.glade")
		self._workview = self._xml.get_widget("work_view")
		self._workview.reparent (self)
		self._xml.signal_autoconnect (self)
		self._canvas = Canvas (config)
		self.set_chars (u" ")
		self._canvas.set_flags (gtk.HAS_DEFAULT)
		self._canvas.connect ("strokes-changed", self.strokes_changed_cb)
		self._canvas.show ()
		self._xml.get_widget("hbox1").add (self._canvas)
		self._treeview = self._xml.get_widget ("treeview")
		self._treeview.set_size_request (200, 400)
		self._treeview.get_selection().connect ("changed", self.treeview_selection_changed_cb)
		self._treeview.get_selection().set_mode(gtk.SELECTION_MULTIPLE)
		self._treeview.enable_model_drag_source (gtk.gdk.BUTTON1_MASK, 
							 targets,
							 gdk.ACTION_COPY|
							 gdk.ACTION_MOVE)
		self._treeview.enable_model_drag_dest (targets, 
						       gdk.ACTION_MOVE)
		self._treeview.connect ("drag_data_get", 
					self._treeview_drag_data_get_cb)
		self._treeview.connect ("drag_data_received", 
					self._treeview_drag_data_received_cb)
		self.__init_treeview ()
		self._button_delete = self._xml.get_widget ("button_delete")
		self._button_go_down = self._xml.get_widget ("button_go_down")
		self._button_go_up = self._xml.get_widget ("button_go_up")

	def __init_treeview (self):
		tv = self._treeview
		model = tv.get_model ()
		
		# number column
		renderer = gtk.CellRendererText ()
		renderer.set_data ("column", COLUMN_NUMBER)
		column = gtk.TreeViewColumn ("N", renderer, text=COLUMN_NUMBER)
		tv.append_column (column)

		# stroke column
		renderer = gtk.CellRendererText ()
		renderer.set_data ("stroke", COLUMN_STROKE)
		column = gtk.TreeViewColumn ("stroke", renderer, text=COLUMN_STROKE)
		tv.append_column (column)

	def get_selection(self):
		return self._treeview.get_selection()

	def set_chars (self, chars, strokes = [], modified = False):
		"""set_chars (self, chars, strokes = [])
		chars: unicode string
		strokes: strokes data
		"""
		self._chars = chars
		self._canvas.set_chars (self._chars, strokes, modified)
	
	def set_font (self, font):
		"""set_font (sefl, font)
		font: font description string, example: New Courier 24 
		"""
		self._canvas.set_font (font)
	
	def get_font (self):
		"""set_font (sefl)
		return font. example: New Courier 24
		"""
		return self._canvas.get_font ()
	
	def get_strokes (self):
		"""get_strokes (self)
		return: strokes data
		"""
		return self._canvas.get_strokes ()
	def is_modified (self):
		return self._canvas.is_modified ()

	def set_strokes (self, strokes, modified = False):
		self._canvas.set_strokes (strokes, modified)

	def select_all (self):
		selection = self._treeview.get_selection ()
		selection.select_all()

	def __sync_treeview (self):
		model = gtk.ListStore (
				gobject.TYPE_INT,
				gobject.TYPE_STRING
				)
		i = 0
		for stroke in self._canvas.get_strokes ():
			i = i + 1
			iter = model.append ()
			model.set (iter, 
				COLUMN_NUMBER, i,
				COLUMN_STROKE, "%d pts" % len (stroke))

		self._treeview.set_model (model)
	
	def __get_treeview_selection (self):
		retval = -1
		rows = self._treeview.get_selection().get_selected_rows()
		print rows
		return rows

	def __set_treeview_selection (self, i):
		selection = self._treeview.get_selection ()
		model = self._treeview.get_model ()
		selection.select_iter (model[i].iter)

	def treeview_selection_changed_cb (self, selection):
		list, rows = selection.get_selected_rows ()
		
		strokes = []
		for row in rows:
			strokes.append(row[0])
		self._canvas.set_selection (strokes)

		self._button_delete.set_sensitive (False)
		self._button_go_down.set_sensitive (False)
		self._button_go_up.set_sensitive (False)
		if len(rows) >= 1:
			self._button_delete.set_sensitive (True)
		if len(rows) != 1:
			return
		pos = rows[0][0]
		if pos != 0:
			self._button_go_up.set_sensitive (True)
		if pos != len(self._canvas.get_strokes()) - 1:
			self._button_go_down.set_sensitive (True)
	
	def copy_selected_strokes (self):
		list, rows = self._treeview.get_selection().get_selected_rows()
		copy_strokes = []
		strokes = self._canvas.get_strokes()
		
		if len(rows) == 0:
			return

		for row in rows:
			copy_strokes.append(strokes[row[0]])
		
		clipboard.set_data (1, copy_strokes)

	def paste_strokes (self):
		type, strokes = clipboard.get_data ()

		if type == -1 or strokes == None:
			return

		strokes = self._canvas.get_strokes () + strokes
		self._canvas.set_strokes (strokes, True)


	def delete_selected_strokes (self):
		list, rows = self._treeview.get_selection().get_selected_rows()
		strokes = []
		for row in rows:
			strokes.append(row[0])
		self._canvas.delete_strokes (strokes)


	def stroke_delete_cb (self, widget):
		self.delete_selected_strokes()

	def stroke_go_down_cb (self, widget):
		list, rows = self._treeview.get_selection().get_selected_rows()
		self._canvas.swap_strokes (rows[0][0])
		#while gtk.events_pending ():
		#	gtk.main_iteration ()
		self.__set_treeview_selection (rows[0][0] + 1)

	def stroke_go_up_cb (self, widget):
		list, rows = self._treeview.get_selection().get_selected_rows()
		self._canvas.swap_strokes (rows[0][0] - 1)
		#while gtk.events_pending ():
		#	gtk.main_iteration ()
		self.__set_treeview_selection (rows[0][0] - 1)

	def strokes_changed_cb (self, source):
		self.__sync_treeview ()
		self.emit ("strokes-changed")

	def _treeview_drag_data_get_cb (self, treeview, context, 
					selection, target_id, etime):
		return
		treeselection = treeview.get_selection()
		model, iter = treeselection.get_selected()
		data = model.get_value(iter, 0)
		selection.set(selection.target, 8, str(data))
	
	def _treeview_drag_data_received_cb(self, treeview, 
					    context, x, y, selection,
					    info, etime):
		model = treeview.get_model()
		data = selection.data
		drop_info = treeview.get_dest_row_at_pos(x, y)
		pos = -1
		if drop_info:
			path, position = drop_info
			iter = model.get_iter(path)
			pos = model.get_value (iter, 0)
			if (position == gtk.TREE_VIEW_DROP_BEFORE
				or position == gtk.TREE_VIEW_DROP_INTO_OR_BEFORE):
				pos = pos - 1
		list, rows = self._treeview.get_selection().get_selected_rows()
		strokes = self._canvas.get_strokes ()
		selected_strokes = []
		for row in rows:
			selected_strokes.append(strokes[row[0]])
			strokes[row[0]] = "delete"

		if pos == -1:
			pos = len(strokes)
		new_strokes = strokes[0:pos] + selected_strokes + strokes[pos:]

		try:
			while True:
				new_strokes.remove("delete")
		except:
			pass
		self._canvas.set_strokes (new_strokes, True)

gobject.type_register (WorkView)
