/*
    Pirate Bulletin Board System
    Copyright (C) 1990, Edward Luke, lush@Athena.EE.MsState.EDU
    Eagles Bulletin Board System
    Copyright (C) 1992, Raymond Rocker, rocker@rock.b11.ingr.com
                        Guy Vega, gtvega@seabass.st.usm.edu
                        Dominic Tynes, dbtynes@seabass.st.usm.edu
    Firebird Bulletin Board System
    Copyright (C) 1996, Hsien-Tsung Chang, Smallpig.bbs@bbs.cs.ccu.edu.tw
                        Peng Piaw Foong, ppfoong@csie.ncu.edu.tw

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
*/
/*
$Id: read.c,v 1.1.1.1 2000/08/25 14:20:33 deardragon Exp $
*/

#include "bbs.h"

#define PUTCURS   move(3+locmem->crs_line-locmem->top_line,0);prints(">");
#define RMVCURS   move(3+locmem->crs_line-locmem->top_line,0);prints(" ");

struct fileheader SR_fptr;
int     SR_BMDELFLAG = NA;
char   *pnt;

extern int	noreply;
extern int local_article;

struct keeploc {
	char   *key;
	int     top_line;
	int     crs_line;
	struct keeploc *next;
};

/*struct fileheader *files = NULL;*/
char    currdirect[STRLEN];
char    keyword[STRLEN];	/* for  */
int     screen_len;
int     last_line;

struct keeploc *
getkeep(s, def_topline, def_cursline)
char   *s;
int     def_topline;
int     def_cursline;
{
	static struct keeploc *keeplist = NULL;
	struct keeploc *p;
	for (p = keeplist; p != NULL; p = p->next) {
		if (!strcmp(s, p->key)) {
			if (p->crs_line < 1)
				p->crs_line = 1;	/* DAMMIT! - rrr */
			return p;
		}
	}
	p = (struct keeploc *) malloc(sizeof(*p));
	p->key = (char *) malloc(strlen(s) + 1);
	strcpy(p->key, s);
	p->top_line = def_topline;
	p->crs_line = def_cursline;
	p->next = keeplist;
	keeplist = p;
	return p;
}

void
fixkeep(s, first, last)
char   *s;
int     first, last;
{
	struct keeploc *k;
	k = getkeep(s, 1, 1);
	if (k->crs_line >= first) {
		k->crs_line = (first == 1 ? 1 : first - 1);
		k->top_line = (first < 11 ? 1 : first - 10);
	}
}

void
modify_locmem(locmem, total)
struct keeploc *locmem;
int     total;
{
	if (locmem->top_line > total) {
		locmem->crs_line = total;
		locmem->top_line = total - t_lines / 2;
		if (locmem->top_line < 1)
			locmem->top_line = 1;
	} else if (locmem->crs_line > total) {
		locmem->crs_line = total;
	}
}

int
move_cursor_line(locmem, mode)
struct keeploc *locmem;
int     mode;
{
	int     top, crs;
	int     reload = 0;
	top = locmem->top_line;
	crs = locmem->crs_line;
	if (mode == READ_PREV) {
		if (crs <= top) {
			top -= screen_len - 1;
			if (top < 1)
				top = 1;
			reload = 1;
		}
		crs--;
		if (crs < 1) {
			crs = 1;
			reload = -1;
		}
	} else if (mode == READ_NEXT) {
		if (crs + 1 >= top + screen_len) {
			top += screen_len - 1;
			reload = 1;
		}
		crs++;
		if (crs > last_line) {
			crs = last_line;
			reload = -1;
		}
	}
	locmem->top_line = top;
	locmem->crs_line = crs;
	return reload;
}

void
draw_title(dotitle)
int     (*dotitle) ();
{
	clear();
	(*dotitle) ();
}

void
draw_entry(doentry, locmem, num, ssize)
char   *(*doentry) ();
struct keeploc *locmem;
int     num, ssize;
{
	char   *str;
	int     base, i;
	base = locmem->top_line;
	move(3, 0);
	clrtobot();
	for (i = 0; i < num; i++) {
		str = (*doentry) (base + i, &pnt[i * ssize]);
		if (!check_stuffmode())
			prints("%s", str);
		else
			showstuff(str);
		prints("\n");
	}
	move(t_lines - 1, 0);
	clrtoeol();
	update_endline();
}


void
i_read(cmdmode, direct, dotitle, doentry, rcmdlist, ssize)
int     cmdmode;
char   *direct;
int     (*dotitle) ();
char   *(*doentry) ();
struct one_key *rcmdlist;
int     ssize;
{
	extern int talkrequest;
	extern int friendflag;
	struct keeploc *locmem;
	char    lbuf[11];
	char    *ptr;
	int     lbc, recbase, mode, ch;
	int     num, entries;
	screen_len = t_lines - 4;
	modify_user_mode(cmdmode);
	ptr = pnt = calloc(screen_len, ssize);
	strcpy(currdirect, direct);
	draw_title(dotitle);
	last_line = get_num_records(currdirect, ssize);

	if (last_line == 0) {
		if (cmdmode == RMAIL) {
			prints("ûκż...");
			pressreturn();
			clear();
		} else if (cmdmode == GMENU) {
			char    desc[5];
			char    buf[40];
			if (friendflag)
				strcpy(desc, "");
			else
				strcpy(desc, "");
			sprintf(buf, "ûκ%s (A)%s (Q)뿪[Q] ", desc, desc);
			getdata(t_lines - 1, 0, buf, genbuf, 4, DOECHO, YEA);
			if (genbuf[0] == 'a' || genbuf[0] == 'A')
				(friendflag) ? friend_add() : reject_add();
		} else {
			getdata(t_lines - 1, 0, "³ (P) (Q)뿪[Q] ",
				genbuf, 4, DOECHO, YEA);
			if (genbuf[0] == 'p' || genbuf[0] == 'P')
				do_post();
		}
		free(pnt);
		return;
	}
	num = last_line - screen_len + 2;
	locmem = getkeep(currdirect, num < 1 ? 1 : num, last_line);
	modify_locmem(locmem, last_line);
	recbase = locmem->top_line;
	entries = get_records(currdirect, pnt, ssize, recbase, screen_len);
	draw_entry(doentry, locmem, entries, ssize);
	PUTCURS;
	lbc = 0;
	mode = DONOTHING;
	while ((ch = egetch()) != EOF) {
		if (talkrequest) {
			talkreply();
			mode = FULLUPDATE;
		} else if (ch >= '0' && ch <= '9') {
			if (lbc < 9)
				lbuf[lbc++] = ch;
		} else if (lbc > 0 && (ch == '\n' || ch == '\r')) {
			lbuf[lbc] = '\0';
			lbc = atoi(lbuf);
			if (cursor_pos(locmem, lbc, 10))
				mode = PARTUPDATE;
			lbc = 0;
		} else {
			lbc = 0;
			mode = i_read_key(rcmdlist, locmem, ch, ssize);

			while (mode == READ_NEXT || mode == READ_PREV) {
				int     reload;
				reload = move_cursor_line(locmem, mode);
				if (reload == -1) {
					mode = FULLUPDATE;
					break;
				} else if (reload) {
					recbase = locmem->top_line;
					entries = get_records(currdirect, pnt, ssize,
						recbase, screen_len);
					if (entries <= 0) {
						last_line = -1;
						break;
					}
				}
				num = locmem->crs_line - locmem->top_line;
				mode = i_read_key(rcmdlist, locmem, ch, ssize);
			}
			modify_user_mode(cmdmode);
		}
		if (mode == DOQUIT)
			break;
		if (mode == GOTO_NEXT) {
			cursor_pos(locmem, locmem->crs_line + 1, 1);
			mode = PARTUPDATE;
		}
		switch (mode) {
		case NEWDIRECT:
		case DIRCHANGED:
		case MODECHANGED: // chenhao бŵ
			recbase = -1;
                        if (mode == MODECHANGED) { // chenhao
                                setbdir(currdirect, currboard);
                                pnt = ptr;
                        }
			last_line = get_num_records(currdirect, ssize);
			if (last_line == 0 && digestmode > 0) {
					acction_mode();
			}
			if (mode == NEWDIRECT) {
				num = last_line - screen_len + 1;
				locmem = getkeep(currdirect, num < 1 ? 1 : num, last_line);
			}
		case FULLUPDATE:
			draw_title(dotitle);
		case PARTUPDATE:
			if (last_line < locmem->top_line + screen_len) {
				num = get_num_records(currdirect, ssize);
				if (last_line != num) {
					last_line = num;
					recbase = -1;
				}
			}
			if (last_line == 0) {
				prints("No Messages\n");
				entries = 0;
			} else if (recbase != locmem->top_line) {
				recbase = locmem->top_line;
				if (recbase > last_line) {
					recbase = last_line - screen_len / 2;
					if (recbase < 1)
						recbase = 1;
					locmem->top_line = recbase;
				}
				entries = get_records(currdirect, pnt, ssize,
					recbase, screen_len);
			}
			if (locmem->crs_line > last_line)
				locmem->crs_line = last_line;
			draw_entry(doentry, locmem, entries, ssize);
			PUTCURS;
			break;
		default:
			break;
		}
		mode = DONOTHING;
		if (entries == 0)
			break;
	}
	clear();
	free(pnt);
}

int
i_read_key(rcmdlist, locmem, ch, ssize)
struct one_key *rcmdlist;
struct keeploc *locmem;
int     ch, ssize;
{
	int     i, mode = DONOTHING,savemode;
	switch (ch) {
	case 'q':
	case 'e':
	case KEY_LEFT:
		//if ( digestmode )
		if( digestmode && uinfo.mode != RMAIL ) //chenhao
			return acction_mode();
		else
			return DOQUIT;
	case Ctrl('L'):
		redoscr();
		break;
	case 'M':
		savemode = uinfo.mode;
		m_new();
		modify_user_mode(savemode);
		return FULLUPDATE;
        case 'u':
                savemode = uinfo.mode;
		modify_user_mode(QUERY);
                t_query();
                modify_user_mode(savemode);
                return FULLUPDATE;
        case 'H': 
                show_help("0Announce/bbslist/day");
                return FULLUPDATE;
        case 'O':
                if (!strcmp("guest", currentuser.userid))
                        break;
                move(23, 0);
                if (askyn("ѵ", NA, NA) == NA)
                        return PARTUPDATE;
		friend_add();
		return FULLUPDATE;
	case 'k':
	case KEY_UP:
		if (cursor_pos(locmem, locmem->crs_line - 1, screen_len - 1))
			return PARTUPDATE;
		break;
	case 'j':
	case KEY_DOWN:
		if (cursor_pos(locmem, locmem->crs_line + 1, 0))
			return PARTUPDATE;
		break;
	case 'l':		/* ppfoong */
		show_allmsgs();
		return FULLUPDATE;
        case 'L':		//chenhao бʱŵ
		if(uinfo.mode == RMAIL) return DONOTHING;
                savemode = uinfo.mode;
                m_read();
                modify_user_mode(savemode);
                return MODECHANGED;
	case 'N':
	case Ctrl('F'):
	case KEY_PGDN:
	case ' ':
		if (last_line >= locmem->top_line + screen_len) {
			locmem->top_line += screen_len - 1;
			locmem->crs_line = locmem->top_line;
			return PARTUPDATE;
		}
		RMVCURS;
		locmem->crs_line = last_line;
		PUTCURS;
		break;
	case 'P':
	case Ctrl('B'):
	case KEY_PGUP:
		if (locmem->top_line > 1) {
			locmem->top_line -= screen_len - 1;
			if (locmem->top_line <= 0)
				locmem->top_line = 1;
			locmem->crs_line = locmem->top_line;
			return PARTUPDATE;
		} else {
			RMVCURS;
			locmem->crs_line = locmem->top_line;
			PUTCURS;
		}
		break;
	case KEY_HOME:
		locmem->top_line = 1;
		locmem->crs_line = 1;
		return PARTUPDATE;
	case '$':
	case KEY_END:
		if (last_line >= locmem->top_line + screen_len) {
			locmem->top_line = last_line - screen_len + 1;
			if (locmem->top_line <= 0)
				locmem->top_line = 1;
			locmem->crs_line = last_line;
			return PARTUPDATE;
		}
		RMVCURS;
		locmem->crs_line = last_line;
		PUTCURS;
		break;
	case 'S':		/* youzi */
		if (!HAS_PERM(PERM_MESSAGE))
			break;
		s_msg();
		return FULLUPDATE;
		break;
	case 'f':		/* youzi */
		if (!HAS_PERM(PERM_BASIC))
			break;
		t_friends();
		return FULLUPDATE;
		break;
	case '!':		/* youzi leave */
		return Goodbye();
		break;
	case '\n':
	case '\r':
	case KEY_RIGHT:
		ch = 'r';
		/* lookup command table */
	default:
		for (i = 0; rcmdlist[i].fptr != NULL; i++) {
			if (rcmdlist[i].key == ch) {
				mode = (*(rcmdlist[i].fptr)) (locmem->crs_line,
					&pnt[(locmem->crs_line - locmem->top_line) * ssize],
					currdirect);
				break;
			}
		}
	}
	return mode;
}

int
auth_search_down(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	struct keeploc *locmem;
	locmem = getkeep(direct, 1, 1);
	if (search_author(locmem, 1, fileinfo->owner))
		return PARTUPDATE;
	else
		update_endline();
	return DONOTHING;
}

int
auth_search_up(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	struct keeploc *locmem;
	locmem = getkeep(direct, 1, 1);
	if (search_author(locmem, -1, fileinfo->owner))
		return PARTUPDATE;
	else
		update_endline();
	return DONOTHING;
}


int
post_search_down(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	struct keeploc *locmem;
	locmem = getkeep(direct, 1, 1);
	if (search_post(locmem, 1))
		return PARTUPDATE;
	else
		update_endline();
	return DONOTHING;
}

int
post_search_up(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	struct keeploc *locmem;
	locmem = getkeep(direct, 1, 1);
	if (search_post(locmem, -1))
		return PARTUPDATE;
	else
		update_endline();
	return DONOTHING;
}

int
show_author(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	t_query(fileinfo->owner);
	return FULLUPDATE;
}

int SR_BMfunc(int ent, struct fileheader *fileinfo, char *direct)
{
   int     i, dotype = 0, result = 0, full =0;
   int	   has_yinyan=0; //Add by everlove ϼ
   char    buf[80], ch[4], BMch, annpath[512];
   struct keeploc *locmem;
   char SR_BMitems[7][8] = 
      {"ɾ", "", "ժ", "", "ݴ浵","RE","ϼ"};//change by everlove for combine
   char subBMitems[3][9] = 
      {"ͬ", "ͬ", ""};
   
   if (!strcmp(currboard, "deleted") || !strcmp(currboard, "junk"))
      return DONOTHING;
   if (fileinfo->owner[0] == '-') return DONOTHING;
   if (!chk_currBM(currBM)) return DONOTHING;
   saveline(t_lines - 1, 0);
   move(t_lines - 1, 0);
   clrtoeol();
   ch[0] = '\0';
   getdata(t_lines - 1, 0, 
      "ִ: 1) ͬ  2) ͬ 3)  0) ȡ [0]: ", 
      ch, 3, DOECHO, YEA);
   dotype = atoi(ch); 
   if (dotype < 1 || dotype > 3) {
      saveline(t_lines - 1, 1);
      return DONOTHING;
   }
   sprintf(buf, "%s ", subBMitems[dotype - 1]); 
   for (i = 0; i < 7; i++) //change by everlove for combine
      sprintf(buf, "%s(%d)%s ", buf, i + 1, SR_BMitems[i]); 
   strcat(buf, "? [0]: ");
   getdata(t_lines - 1, 0, buf, ch, 3, DOECHO, YEA);
   BMch = atoi(ch);
   if(BMch<=0||BMch>7||(digestmode>1&&BMch==3)||(digestmode==1&&BMch==3)
      ||(digestmode>2&&BMch<3)){
      saveline(t_lines - 1, 1);
      return DONOTHING;
   }
   move(t_lines - 1, 0);
   sprintf(buf,"ȷҪִ%s[%s]",subBMitems[dotype-1],SR_BMitems[BMch-1]);
   if (askyn(buf, NA, NA) == 0) {
      saveline(t_lines - 1, 1);
      return DONOTHING;
   } 
   
   
   if(BMch == 4){
      FILE *fn;
      sethomefile(annpath, currentuser.userid,".announcepath");
      if((fn = fopen(annpath, "r")) == NULL ) {
         presskeyfor("Բ, û趨˿·.  f 趨˿·.",t_lines-1);
	 saveline(t_lines - 1, 1);
	 return DONOTHING;
      }
      fscanf(fn,"%s",annpath);
      fclose(fn);
      if (!dashd(annpath)) {
         presskeyfor("趨˿·Ѷʧ,  f 趨.",t_lines-1);
	 saveline(t_lines - 1, 1);
	 return DONOTHING;
      }
   } else if( BMch == 5 ){
      if(askyn("[ݴ浵ģʽ: һ/] þʽ",YEA,YEA)==NA)
        full = 1;
   }
   /* Add by everlove ϼ */
   if( (dotype == 1 || dotype == 3) && BMch == 7) {
      move(t_lines-1,0);
      if (askyn("ĺϼҪ", NA, NA) == YEA)
            has_yinyan=1;
        }
	/*The End */

   if (dotype == 3) {
      strcpy(keyword, "");
      getdata(t_lines - 1, 0, "ؼ: ", keyword, 50, DOECHO, YEA);
      if (keyword[0] == '\0') {
         saveline(t_lines - 1, 1);
	 return DONOTHING;
      }
   } else if (dotype == 1) {
      strcpy(keyword, fileinfo->title);
   } else {
      strcpy(keyword, fileinfo->owner);
   }
   /* Add by everlove ϼ */
   if( (dotype == 1 || dotype == 3) && BMch == 7)
        {
         sprintf(buf, "tmp/%s.combine", currentuser.userid);
         if(dashf(buf)) unlink(buf);
        }
   /* The End */

   move(t_lines - 1, 0);
   sprintf(buf, "Ƿ%sһƪʼ%s (Y)һƪ (N)Ŀǰһƪ", 
      (dotype == 2) ? "" : "", SR_BMitems[BMch - 1]);
   if(askyn(buf, YEA, NA) == YEA) {
      result = locate_the_post(fileinfo, keyword,5,dotype-1,0);
   } else if(dotype == 3) {
      result = locate_the_post(fileinfo, keyword,1,2,0);
   } else {
      memcpy(&SR_fptr, fileinfo, sizeof(SR_fptr));
   }   
   if( result == -1 ){
      saveline(t_lines - 1, 1);
      return DONOTHING;
   }   
   while(1){
      locmem = getkeep(currdirect, 1, 1);
      switch(BMch){
         case 1:
	    SR_BMDELFLAG = YEA;
	    result = del_post(locmem->crs_line, &SR_fptr, currdirect);
	    SR_BMDELFLAG = NA;
	    if(result == -1)
	       return DIRCHANGED;
	    if (result != DONOTHING) {
	       last_line--;
	       locmem->crs_line--;
	    }   
	    break;
         case 2:
	    mark_post(locmem->crs_line, &SR_fptr, currdirect);
	    break;
	 case 3:
	    digest_post(locmem->crs_line, &SR_fptr, currdirect);
	    break;
	 case 4:
	    a_Import("0Announce",currboard, &SR_fptr,annpath, YEA);
	    break;
	 case 5:
	    a_Save("0Announce", currboard, &SR_fptr, YEA, full);
	    break;
	 case 6: 
	    underline_post(locmem->crs_line,&SR_fptr,currdirect); 
	    break;
    /* Add by everlove ϼ */
	 case 7:
	    Add_Combine(currboard,&SR_fptr,has_yinyan);
        break; 
	 /* The End */

      }
      if(locmem->crs_line <= 0){
         result = locate_the_post(fileinfo, keyword,5,dotype-1,0);
      } else {
         result = locate_the_post(fileinfo, keyword,1,dotype-1,0);
      }
      if(result == -1) break;
   }
 /* Add by everlove ϼ */
     if( (dotype == 1 || dotype == 3) && BMch == 7) // add by jieer 2001.06.23
      { if( !strncmp(keyword, "Re: ", 4)||!strncmp(keyword,"RE: ",4) )
	 { sprintf(buf, "ϼ%s", keyword + 4); }
          else sprintf(buf, "ϼ%s", keyword);
        strcpy(keyword, buf);
        sprintf(buf, "tmp/%s.combine", currentuser.userid);
        Postfile( buf,currboard,keyword,2);
	unlink(buf);
      }    
	/* The End */  
	
   return DIRCHANGED;
}

int SR_first_new(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	if(locate_the_post(fileinfo, fileinfo->title,5,0,1)!=-1){
	   sread(1, 0, &SR_fptr);
	   return FULLUPDATE;
	}   
	return PARTUPDATE;
}

int
SR_last(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	locate_the_post(fileinfo, fileinfo->title,3,0,0);
	return PARTUPDATE;
}

int
SR_first(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	locate_the_post(fileinfo, fileinfo->title,5,0,0);
	return PARTUPDATE;
}

int
SR_read(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	sread(1, 0, fileinfo);
	return FULLUPDATE;
}

int
SR_author(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	sread(1, 1, fileinfo);
	return FULLUPDATE;
}

int
search_author(locmem, offset, powner)
struct keeploc *locmem;
int     offset;
char   *powner;
{
	static char author[IDLEN + 1];
	char    ans[IDLEN + 1], pmt[STRLEN];
	char    currauth[STRLEN];
	strcpy(currauth, powner);

	sprintf(pmt, "%sѰ [%s]: ", offset > 0 ? "" : "ǰ", currauth);
	move(t_lines - 1, 0);
	clrtoeol();
	getdata(t_lines - 1, 0, pmt, ans, IDLEN, DOECHO, YEA);
	if (ans[0] != '\0')
		strcpy(author, ans);
	else
		strcpy(author, currauth);

	return search_articles(locmem, author, offset, 1,0);
}

int
auth_post_down(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	struct keeploc *locmem;
	locmem = getkeep(direct, 1, 1);
	if (search_author(locmem, 1, fileinfo->owner))
		return PARTUPDATE;
	else
		update_endline();
	return DONOTHING;
}

int
auth_post_up(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	struct keeploc *locmem;
	locmem = getkeep(direct, 1, 1);
	if (search_author(locmem, -1, fileinfo->owner))
		return PARTUPDATE;
	else
		update_endline();
	return DONOTHING;
}

int
t_search_down(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	struct keeploc *locmem;
	locmem = getkeep(direct, 1, 1);
	if (search_title(locmem, 1))
		return PARTUPDATE;
	else
		update_endline();
	return DONOTHING;
}

int
t_search_up(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	struct keeploc *locmem;
	locmem = getkeep(direct, 1, 1);
	if (search_title(locmem, -1))
		return PARTUPDATE;
	else
		update_endline();
	return DONOTHING;
}
int
thread_up(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	struct keeploc *locmem;
	locmem = getkeep(direct, 1, 1);
	if (search_thread(locmem, -1, fileinfo->title)) {
		update_endline();
		return PARTUPDATE;
	}
	update_endline();
	return DONOTHING;
}

int
thread_down(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	struct keeploc *locmem;
	locmem = getkeep(direct, 1, 1);
	if (search_thread(locmem, 1, fileinfo->title)) {
		update_endline();
		return PARTUPDATE;
	}
	update_endline();
	return DONOTHING;
}

int
search_post(locmem, offset)
struct keeploc *locmem;
int     offset;
{
	static char query[STRLEN];
	char    ans[STRLEN], pmt[STRLEN];
	strcpy(ans, query);
	sprintf(pmt, "Ѱ%s [%s]: ", offset > 0 ? "" : "ǰ", ans);
	move(t_lines - 1, 0);
	clrtoeol();
	getdata(t_lines - 1, 0, pmt, ans, 50, DOECHO, YEA);
	if (ans[0] != '\0')
		strcpy(query, ans);

	return search_articles(locmem, query, offset, -1, 0);
}


int
search_title(locmem, offset)
struct keeploc *locmem;
int     offset;
{
	static char title[STRLEN];
	char    ans[STRLEN], pmt[STRLEN];
	strcpy(ans, title);
	sprintf(pmt, "%sѰ [%.16s]: ", offset > 0 ? "" : "ǰ", ans);
	move(t_lines - 1, 0);
	clrtoeol();
	getdata(t_lines - 1, 0, pmt, ans, 46, DOECHO, YEA);
	if (*ans != '\0')
		strcpy(title, ans);
	return search_articles(locmem, title, offset, 2, 0);
}

int
search_thread(locmem, offset, title)
struct keeploc *locmem;
int     offset;
char   *title;
{

	if (title[0] == 'R' && (title[1] == 'e' || title[1] == 'E') && title[2] == ':')
		title += 4;
	setqtitle(title);
	return search_articles(locmem, title, offset, 0, 0);
}

int sread(int readfirst, int auser, struct fileheader *ptitle)
{
   struct keeploc *locmem;
   int     rem_top, rem_crs, ch;
   int     isend = 0, isstart = 0, isnext = 1;
   char    tempbuf[STRLEN], title[STRLEN];
  
   if (readfirst){
      isstart = 1;
   } else {
      isstart = 0;
      move(t_lines - 1, 0);
      clrtoeol();
      prints("[1;44;31m[%8s] [33mһ <Space>,<Enter>,һ ,U                              [m", auser ? "ͬ" : "Ķ");
      switch (egetch()) {
         case ' ':
	 case '\n':
	 case KEY_DOWN:
	    isnext = 1;
	    break;
	 case KEY_UP:
	 case 'u':
	 case 'U':
	    isnext = -1;
	    break;
	 default:
	    isend = 1;
	    break;
      }
   }
   locmem = getkeep(currdirect, 1, 1);
   rem_top = locmem->top_line;
   rem_crs = locmem->crs_line;
   if (auser == 0) {
      strcpy(title, ptitle->title);
      setqtitle(title);
   } else {
      strcpy(title, ptitle->owner);
      setqtitle(ptitle->title);
   }
   if (!strncmp(title, "Re: ", 4)){
      strcpy(title, title + 4);
   }
   memcpy(&SR_fptr, ptitle, sizeof(SR_fptr));
   while (!isend) {
      if (!isstart) {
         if(search_articles(locmem, title, isnext, auser, 0)==-1) break;
      }
      if (uinfo.mode != RMAIL)
         setbfile(tempbuf, currboard, SR_fptr.filename);
      else
         sprintf(tempbuf, "mail/%c/%s/%s", toupper(currentuser.userid[0]), 
	    currentuser.userid, SR_fptr.filename);
      setquotefile(tempbuf);
      ch = ansimore(tempbuf, NA);
      brc_addlist(SR_fptr.filename);
      isstart = 0;
      if( ch == KEY_UP || ch == 'u' || ch == 'U') {
         readfirst = (ch == KEY_UP);
	 isnext = -1;
	 continue;
      }
      move(t_lines - 1, 0);
      clrtoeol();
      prints("\033[1;44;31m[%8s] \033[33m R   Q, һ ,Enterһ ,U  ^R ظ   \033[m", auser ? "ͬ" : "Ķ");
      switch (ch = egetch()) {
	 case KEY_LEFT:
         case 'N':
	 case 'Q':
	 case 'n':
	 case 'q':
	    isend = 1;
	    break;
	 case 'Y':
	 case 'R':
	 case 'y':
	 case 'r': { 
	    struct shortfile *bp;
	    extern struct shortfile *getbcache();
	    
	    bp = getbcache(currboard);
	    noreply=ptitle->accessed[0]&FILE_NOREPLY||bp->flag&NOREPLY_FLAG;
	    if(!noreply || HAS_PERM(PERM_SYSOP)||chk_currBM(currBM)){
	       local_article=!(ptitle->filename[STRLEN-1]=='S');
	       do_reply(ptitle->title,ptitle->owner);
            } else {
	       clear();
	       move(5, 6);
	       prints("Բ, в RE , 㲻ܻظ(RE) ƪ.");
	       pressreturn();
	    }
	    break;
	 }
	 case ' ':
	 case '\n':
	 case KEY_DOWN:
	    readfirst = (ch == KEY_DOWN);
	    isnext = 1;
	    break;
	 case Ctrl('A'):
	    clear();
	    show_author(0, &SR_fptr, currdirect);
	    isnext = 1;
	    break;
	 case KEY_UP:
	 case 'u':
	 case 'U':
	    readfirst = (ch == KEY_UP);
	    isnext = -1;  
	    break;
	 case Ctrl('R'):
	    post_reply(0, &SR_fptr, (char *) NULL);
	    break;
	 case 'g':
	    digest_post(0, &SR_fptr, currdirect);
	    break;
	 default:
	    break;
      }
   }
   if (readfirst == 0) {
      RMVCURS;
      locmem->top_line = rem_top;
      locmem->crs_line = rem_crs;
      PUTCURS;
   }
   return 1;
}

int
searchpattern(filename, query)
char   *filename;
char   *query;
{
	FILE   *fp;
	char    buf[256];
	if ((fp = fopen(filename, "r")) == NULL)
		return 0;
	while (fgets(buf, 256, fp) != NULL) {
		if (strstr(buf, query)) {
			fclose(fp);
			return YEA;
		}
	}
	fclose(fp);
	return NA;
}

int search_articles(locmem, query, offset, aflag, newflag)
struct keeploc *locmem;
char   *query;
int     offset, aflag, newflag;
{
   char   *ptr;
   int     ent, fd;
   int     complete_search, oldent, lastent = 0;
   int     ssize = sizeof(struct fileheader); 
   
   if (*query == '\0')return 0; 
   if (aflag >= 2) {
      complete_search = 0;
      aflag -= 2;
   } else {
      complete_search = 1;
   } 
   if(aflag != -1 && offset > 2){
      ent = 0;
      oldent = 0;
      offset -= 4;
   } else {
      ent = locmem->crs_line;
      oldent = locmem->crs_line;
   }   
   move(t_lines - 1, 0);
   clrtoeol();
   prints("[1;44;33mѰУԺ....                                                             [m");
   refresh();
   if ((fd = open(currdirect, O_RDONLY, 0)) == -1) return -1;
   if(aflag !=-1 && offset < 0) ent = 0;
   if(ent){
      if(aflag == -1 && offset < 0) ent -= 2;
      if(ent<0 || lseek(fd,(off_t)(ent*ssize),SEEK_SET)==-1){
         close(fd);
         return -1;
      }
   }
   if(aflag != - 1 && offset > 0) ent = oldent;
   if(aflag == -1 && offset < 0) ent += 2;
   while (read(fd,&SR_fptr,ssize)==ssize) {
      if(aflag == -1 && offset < 0) ent --;
      else ent ++;
      if(aflag != -1 && offset < 0 && oldent > 0  && ent >= oldent)break;
      if(newflag && !brc_unread(SR_fptr.filename)) continue;
      if (aflag == -1) {
         char    p_name[256];
	 if (uinfo.mode != RMAIL)
	    setbfile(p_name, currboard, SR_fptr.filename);
	 else
	    sprintf(p_name, "mail/%c/%s/%s",toupper(currentuser.userid[0]),
	       currentuser.userid, SR_fptr.filename);
	 if (searchpattern(p_name, query)) {
	    lastent = ent;
	    break;
	 } else if(offset > 0) continue;
	 else {
	    if(lseek(fd,(off_t)(-2*ssize),SEEK_CUR)==-1){
	       close(fd);
	       return -1;
	    }
	    continue;
	 }   
      }
      ptr = aflag ? SR_fptr.owner : SR_fptr.title;
      if (complete_search == 1) {
         if((*ptr=='R'||*ptr=='r')&&(*(ptr+1)=='E'||*(ptr+1)=='e')
	 && (*(ptr + 2) == ':') && (*(ptr + 3) == ' ')) {
	    ptr = ptr + 4;
	 }
	 if (!strncmp(ptr, query,40)) {  
	    lastent = ent;
	    if(offset > 0) break;
	 }
      } else {
         char    upper_ptr[STRLEN], upper_query[STRLEN];
	 strtoupper(upper_ptr, ptr);
	 strtoupper(upper_query, query);
	 if (strstr(upper_ptr, upper_query) != NULL) {
	    if(aflag){
	       if(strcmp(upper_ptr,upper_query)) continue;
	    }   
	    lastent = ent;
	    if(offset > 0)break;
	 }
      }
   }
   move(t_lines - 1, 0);
   clrtoeol();
   close(fd);
   if(lastent == 0) return -1;
   get_record(currdirect, &SR_fptr, sizeof(SR_fptr), lastent);
   last_line = get_num_records(currdirect, ssize);
   return (cursor_pos(locmem, lastent, 10));
}

int locate_the_post(fileinfo, query, offset, aflag, newflag)
struct fileheader *fileinfo;
char	*query;
int	offset; //-1 ǰ  1 ǰ  3 һƪ 5 һƪ
int     aflag;  // 1 owner  0 ͬ   2 
int	newflag; // 1 Ϊ   0 ¾ɾ
{
   struct keeploc *locmem;
   locmem = getkeep(currdirect, 1, 1);
   if (query[0]=='R'&&(query[1]=='e'||query[1]=='E')&&query[2]==':')
      query += 4;
   setqtitle(query);
   return search_articles(locmem, query, offset, aflag, newflag);
}
/* calc cursor pos and show cursor correctly -cuteyu */
int 
cursor_pos(locmem, val, from_top)
struct keeploc *locmem;
int     val;
int     from_top;
{
	if (val > last_line) {
		val = DEFINE(DEF_CIRCLE) ? 1 : last_line;
	}
	if (val <= 0) {
		val = DEFINE(DEF_CIRCLE) ? last_line : 1;
	}
	//if(val>=locmem->top_line&&val<locmem->top_line+screen_len-1){
	if(val>=locmem->top_line&&val<locmem->top_line+screen_len){
		RMVCURS;
		locmem->crs_line = val;
		PUTCURS;
		return 0;
	}
	locmem->top_line = val - from_top;
	if (locmem->top_line <= 0)
		locmem->top_line = 1;
	locmem->crs_line = val;
	return 1;
}
