/*
    Pirate Bulletin Board System
    Copyright (C) 1990, Edward Luke, lush@Athena.EE.MsState.EDU
    Eagles Bulletin Board System
    Copyright (C) 1992, Raymond Rocker, rocker@rock.b11.ingr.com
                        Guy Vega, gtvega@seabass.st.usm.edu
                        Dominic Tynes, dbtynes@seabass.st.usm.edu
    Firebird Bulletin Board System
    Copyright (C) 1996, Hsien-Tsung Chang, Smallpig.bbs@bbs.cs.ccu.edu.tw
                        Peng Piaw Foong, ppfoong@csie.ncu.edu.tw

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
*/
/*
$Id: bbs.c,v 1.1.1.1 2000/08/25 14:20:33 deardragon Exp $
*/
#include "bbs.h"
#include <time.h>
#if defined(BSD44)
#include <stdlib.h>

#elif defined(LINUX)
/* include nothing :-) */
#else

#include <rpcsvc/rstat.h>
#endif

#ifndef DLM
#undef	ALLOWGAME
#endif

#ifdef ALLOWGAME
int  post_word;
int  post_time;
#endif

int     mot;
struct postheader header;
//static int quiting;
extern int numofsig;
int     continue_flag;
int     readpost;
int     digestmode;
int	local_article;
struct userec currentuser;
int     usernum=0;
char    currboard[STRLEN - BM_LEN];
char    currBM[BM_LEN - 1];
int     selboard = 0;
char	someoneID[31];
char    ReadPost[STRLEN] = "";
char    ReplyPost[STRLEN] = "";
char    save_filename[STRLEN];
int     FFLL = 0;

int 	getlist(char *,char **,int, char **, int, char **, int, char **, int);
char   * filemargin();
void    report();
void    board_usage();
void    cancelpost();
void    add_crossinfo();
int     thesis_mode();
/*For read.c*/
int     auth_search_down();
int     auth_search_up();
int     t_search_down();
int     t_search_up();
int     post_search_down();
int     post_search_up();
int     thread_up();
int     thread_down();
int     deny_user();
int 	post_cross(char islocal, int mode);
#ifdef BOARD_CONTROL
int     control_user();
#endif
int     show_author();
int     SR_first_new();
int     SR_last();
int     SR_first();
int     SR_read();
int     SR_read();
int     SR_author();
int     SR_BMfunc();
int     Q_Goodbye();
int     t_friends();
int     s_msg();
int     b_notes_passwd();
//int	read_letter();

extern int SR_BMDELFLAG;
extern int numboards;
extern time_t login_start_time;
extern char BoardName[];
extern int cmpbnames();
extern int toggle1, toggle2;
extern char fromhost[];

int noreply = 0;
#ifdef MARK_X_FLAG
int markXflag = 0;
#endif
int mailtoauther = 0;

char    genbuf[1024];
char    quote_title[120], quote_board[120];
char    quote_file[120], quote_user[120];

#ifndef NOREPLY
char    replytitle[STRLEN];
#endif

struct shortfile *getbcache();
int     totalusers, usercounter;

int
check_stuffmode()
{
	if (uinfo.mode == RMAIL || (uinfo.mode == READING && junkboard()))
		return YEA;
	else
		return NA;
}

#ifndef BBSD
void
get_load(load)
double  load[];
{
#if defined(LINUX)
	FILE   *fp;
	fp = fopen("/proc/loadavg", "r");
	if (!fp)
		load[0] = load[1] = load[2] = 0;
	else {
		float   av[3];
		fscanf(fp, "%g %g %g", av, av + 1, av + 2);
		fclose(fp);
		load[0] = av[0];
		load[1] = av[1];
		load[2] = av[2];
	}
#elif defined(BSD44)
	getloadavg(load, 3);
#else
	struct statstime rs;
	rstat("localhost", &rs);
	load[0] = rs.avenrun[0] / (double) (1 << 8);
	load[1] = rs.avenrun[1] / (double) (1 << 8);
	load[2] = rs.avenrun[2] / (double) (1 << 8);
#endif
}
#endif

int
set_safe_record()
{
	struct userec tmp;
	extern int ERROR_READ_SYSTEM_FILE;
	if (get_record(PASSFILE, &tmp, sizeof(currentuser), usernum) == -1) {
		char    buf[STRLEN];
		sprintf(buf, "Error:Read Passfile %4d %12.12s", usernum, currentuser.userid);
		report(buf);
		ERROR_READ_SYSTEM_FILE = YEA;
		abort_bbs();
		return -1;
	}
	currentuser.numposts = tmp.numposts;
	currentuser.userlevel = tmp.userlevel;
	currentuser.numlogins = tmp.numlogins;
#ifdef ALLOWGAME
	currentuser.medals = tmp.medals;
	currentuser.money = tmp.money;
	currentuser.inbank = tmp.inbank;
#endif
	currentuser.stay = tmp.stay;
	return;
}

char   *
sethomepath(buf, userid)
char   *buf, *userid;
{
	sprintf(buf, "home/%c/%s", toupper(userid[0]), userid);
	return buf;
}
/*Add by SmallPig*/
void
setqtitle(stitle)
char   *stitle;
{
	FFLL = 1;
	if (strncmp(stitle, "Re: ", 4) != 0 ) {
		sprintf(ReplyPost, "Re: %s", stitle);
		strcpy(ReadPost, stitle);
	} else {
		strcpy(ReplyPost, stitle);
		strcpy(ReadPost, ReplyPost + 4);
	}
}

int
chk_currBM(BMstr)
char    BMstr[STRLEN - 1];
{
   char   *ptr;
   char    BMstrbuf[STRLEN - 1];
   
   if (HAS_PERM(PERM_BLEVELS)) return YEA;
   if (!HAS_PERM(PERM_BOARDS|PERM_PERSONAL)) return NA;
   
   strcpy(BMstrbuf, BMstr);
   ptr = strtok(BMstrbuf, ",: ;|&()\0\n");
   while (1) {
      if (ptr == NULL) return NA;
      if (!strcmp(ptr, currentuser.userid)) return YEA;
      ptr = strtok(NULL, ",: ;|&()\0\n");
   }
}

void
setquotefile(filepath)
char    filepath[];
{
	strcpy(quote_file, filepath);
}

char   *
sethomefile(buf, userid, filename)
char   *buf, *userid, *filename;
{
	sprintf(buf, "home/%c/%s/%s", toupper(userid[0]), userid, filename);
	return buf;
}

char   *
setuserfile(buf, filename)
char   *buf, *filename;
{
	sprintf(buf, "home/%c/%s/%s", toupper(currentuser.userid[0]), currentuser.userid, filename);
	return buf;
}

char   *
setbpath(buf, boardname)
char   *buf, *boardname;
{
	strcpy(buf, "boards/");
	strcat(buf, boardname);
	return buf;
}

char   *
setbdir(buf, boardname)
char   *buf, *boardname;
{
	char    dir[STRLEN];
	switch (digestmode) {
	case NA:
		strncpy(dir, DOT_DIR, STRLEN);
		break;
	case YEA:
		strncpy(dir, DIGEST_DIR, STRLEN);
		break;
	case 2:
		strncpy(dir, THREAD_DIR, STRLEN);
		break;
        case 3:
                strncpy(dir, MARKED_DIR, STRLEN);
                break;
        case 4:
                strncpy(dir, AUTHOR_DIR, STRLEN);
                break;
	case 5: /* ͬ */
	case 6: /* ͬ */
	case 7: /* ؼ */
	}
	dir[STRLEN - 1] = '\0';
	if( digestmode == 5 || digestmode == 6)
		sprintf(buf, "boards/%s/SOMEONE.%s.DIR.%d",boardname,someoneID,digestmode-5);
	else if ( digestmode == 7 )
		sprintf(buf, "boards/%s/KEY.%s.DIR",boardname,currentuser.userid);
	else
		sprintf(buf, "boards/%s/%s", boardname, dir);
	return buf;
}

char   *
setbfile(buf, boardname, filename)
char   *buf, *boardname, *filename;
{
	sprintf(buf, "boards/%s/%s", boardname, filename);
	return buf;
}

void setmfile(char *buf,char *userid, char *filename)
{
        sprintf(buf,"mail/%c/%s/%s",toupper(userid[0]),userid, filename);
}

char *
setmdir(buf,userid)
char *buf,*userid;
{
	sprintf(buf,"mail/%c/%s/.DIR",toupper(userid[0]),userid);
	return buf;
}

int
deny_me( char * bname)
{
	char    buf[STRLEN];
	setbfile(buf, bname, "deny_users");
	return seek_in_file(buf, currentuser.userid);
}
/*Add by SmallPig*/
void
shownotepad()
{
	modify_user_mode(NOTEPAD);
	ansimore("etc/notepad",YEA);
	return;
}

int
uleveltochar(buf, lvl)
char   *buf;
unsigned int lvl;
{
	if (!(lvl & PERM_BASIC)) {
		strcpy(buf, "--------- ");
		return 0;
	}
	if (lvl < PERM_DEFAULT) {
		strcpy(buf, "- -------- ");
		return 1;
	}
	buf[10]= '\0';
        buf[9] = (lvl & (PERM_BOARDS)) ? 'B' : ' ';
        buf[8] = (lvl & (PERM_CLOAK)) ? 'C' : ' ';
        buf[7] = (lvl & (PERM_SEECLOAK)) ? '#' : ' ';
        buf[6] = (lvl & (PERM_XEMPT)) ? 'X' : ' ';
        buf[5] = (lvl & (PERM_CHATCLOAK)) ? 'M' : ' ';
        buf[4] = (lvl & (PERM_ACCOUNTS)) ? 'A' : ' ';
        buf[3] = (lvl & (PERM_ANNOUNCE)) ? 'N' : ' ';
        buf[2] = (lvl & (PERM_OBOARDS)) ? 'O' : ' ';
        buf[1] = (lvl & (PERM_DENYPOST)) ? 'D' : ' ';
        buf[0] = (lvl & (PERM_SYSOP)) ? 'S' : ' ';
	return 1;
}

void
printutitle()
{
	move(2, 0);
	prints("[1;44m    ʹߴ   %-19s #%-4s #%-4s %8s    %-12s  [m\n",
#if defined(ACTS_REALNAMES)
		HAS_PERM(PERM_SYSOP) ? "ʵ" : "ʹǳ",
#else
		"ʹǳ",
#endif
#ifdef ALLOWGAME
		(toggle2 == 0) ? "վ" : (toggle2 == 1) ? "" : "",
		(toggle2 == 0) ? "ʱ" : (toggle2 == 1) ? "" : "ż",
#else
                (toggle2 == 0) ? "վ" :  "" ,
                (toggle2 == 0) ? "ʱ" :  "ż" ,
#endif
		HAS_PERM(PERM_SEEULEVELS) ? "    " : "",
		(toggle1 == 0) ? "" :
		(toggle1 == 1) ? "ٵص" : "ʺŽ");
}


int
g_board_names(fhdrp)
struct boardheader *fhdrp;
{
	if ((fhdrp->level & PERM_POSTMASK) || HAS_PERM(fhdrp->level)
		|| (fhdrp->level & PERM_NOZAP)) {
		AddToNameList(fhdrp->filename);
	}
	return 0;
}

void
make_blist()
{
	CreateNameList();
	apply_boards(g_board_names);
}

int
Select()
{
	modify_user_mode(SELECT);
	do_select(0, NULL, genbuf);
	return 0;
}

int
junkboard()
{
	if (strstr(JUNKBOARDS, currboard))
		return 1;
	else
		return seek_in_file("etc/junkboards",currboard);
}

int
Post()
{
	if (!selboard) {
		prints("\n\n (S)elect ȥѡһ\n");
		pressreturn();
		clear();
		return 0;
	}
#ifndef NOREPLY
	*replytitle = '\0';
#endif
	do_post();
	return 0;
}

int
Postfile(filename, nboard, posttitle, mode)
char   *filename, *nboard, *posttitle;
int     mode;
{
	char    bname[STRLEN];
	char    dbname[STRLEN];
	struct boardheader fh;
	if (search_record(BOARDS, &fh, sizeof(fh), cmpbnames, nboard) <= 0) {
		sprintf(bname, "%s Ҳ", nboard);
		report(bname);
		return -1;
	}
	in_mail = NA;
	strcpy(quote_board, nboard);
	strcpy(dbname, currboard);
	strcpy(currboard, nboard);
	strcpy(quote_file, filename);
	strcpy(quote_title, posttitle);
	post_cross('l', mode);
	strcpy(currboard, dbname);
	return;
}

int
get_a_boardname(bname, prompt)
char   *bname, *prompt;
{
	struct boardheader fh;
	make_blist();
	namecomplete(prompt, bname);
	if (*bname == '\0') {
		return 0;
	}
	if (search_record(BOARDS, &fh, sizeof(fh), cmpbnames, bname) <= 0) {
		move(1, 0);
		prints("\n");
		pressreturn();
		move(1, 0);
		return 0;
	}
	return 1;
}
/* Add by SmallPig */
int
do_cross(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	char    bname[STRLEN];
	char    dbname[STRLEN];
	char    ispost[10];
	if(digestmode) return DONOTHING;
	set_safe_record();
	if (!HAS_PERM(PERM_POST)) return DONOTHING;
	if (uinfo.mode != RMAIL)
		sprintf(genbuf, "boards/%s/%s", currboard, fileinfo->filename);
	else
		sprintf(genbuf, "mail/%c/%s/%s", toupper(currentuser.userid[0]), currentuser.userid, fileinfo->filename);
	strncpy(quote_file, genbuf, sizeof(quote_file));
	quote_file[sizeof(quote_file) - 1] = '\0';
	strcpy(quote_title, fileinfo->title);

	clear();
	prints("[1;33mϧվԴתغɾҪ£лл \n[1;32mң㲻ܽתص壬òĻվϵ[m\n\n");
	prints("ѡתص: [[1;33m%s[m]\n",quote_title);
	if(!get_a_boardname(bname, "ȷҪתصĻҪת(ȡת밴س): ")) {
		return FULLUPDATE;
	}
	if(!strcmp(bname,currboard)&&uinfo.mode != RMAIL) {
	        move(8,8);
		prints("Բ𣬱ľҪתصİϣתء");
                pressreturn();
                clear();
                return FULLUPDATE;
        }
#ifdef BOARD_CONTROL
        if(!HAS_PERM(PERM_SYSOP)){
		char filename[STRLEN];
		setbfile(filename, bname, "board.allow");
		if(dashf(filename)&&!seek_in_file(filename,currentuser.userid)){
			move(8,8);
			prints("ܱǸ, 棬ǸðԱ");
			pressanykey();
			return FULLUPDATE;
	   	}
	}
#endif
#ifdef BOARD_READDENY
	if(!HAS_PERM(PERM_SYSOP)){ 
		char filename[STRLEN];
		setbfile(filename, bname, "board.deny"); 
		if(dashf(filename)&&seek_in_file(filename,currentuser.userid)){ 
			move(8,8); 
			prints("ԲĿǰֹͣ뱾Ȩ"); 
			pressanykey(); 
			return FULLUPDATE; 
		}
	}
#endif	
	move(3, 0);
	clrtoeol();
	prints("ת ' %s '  %s  ", quote_title, bname);
	move(4, 0);
	getdata(4, 0, "(S)ת (L)վ (A)ȡ? [L]: ", ispost, 9, DOECHO, YEA);
	if(ispost[0]=='a'||ispost[0]=='A') prints("ȡ");
	else {
		strcpy(quote_board, currboard);
		strcpy(dbname, currboard);
		strcpy(currboard, bname);
		if(ispost[0]!='s'&&ispost[0]!='S')ispost[0]='L';
		if (post_cross(ispost[0], 0) == -1) {
			pressreturn();
			move(2, 0);
			strcpy(currboard, dbname);
			return FULLUPDATE;
		}
		strcpy(currboard, dbname);
		prints("\nѰ \'%s\' ת %s \n", quote_title, bname);
	}
	move(2, 0);
	pressreturn();
	return FULLUPDATE;
}

void
readtitle()
{
	struct shortfile *bp;
        int i,j,bnum,tuid;
        struct user_info uin;
        char tmp[40],bmlists[3][16];
        extern int t_cmpuids();

	char    header[STRLEN], title[STRLEN];
	char    readmode[11];
	bp = getbcache(currboard);
	memcpy(currBM, bp->BM, BM_LEN - 1);
        bnum = 0;
        for (i =0,j =0 ;currBM[i] != '\0';i++) {
                if( currBM[i] == ' ' ) {
                	bmlists[bnum][j] = '\0';
                        bnum ++;
                        j = 0;
                } else
			 bmlists[bnum][j++] = currBM[i];
        } 
        bmlists[bnum++][j] = '\0';
	if (currBM[0] == '\0' || currBM[0] == ' ') {
		strcpy(header, "");
	} else {
		strcpy(header, ": ");
		for(i = 0 ; i< bnum; i++) {
		      	tuid=getuser(bmlists[i]);
       			search_ulist(&uin,t_cmpuids,tuid);
			if (uin.active && uin.pid && !uin.invisible ) {
				sprintf(tmp,"[32m%s[33m ",bmlists[i]);
			} else if(uin.active && uin.pid && uin.invisible && (HAS_PERM(PERM_SEECLOAK)||usernum == uin.uid)) {
				sprintf(tmp,"[36m%s[33m ",bmlists[i]);
			} else 	sprintf(tmp,"%s ",bmlists[i]); 
			strcat(header,tmp);
		}
	}
	if (chkmail())
		strcpy(title, "[ż M ]");
	else if ((bp->flag & VOTE_FLAG))
		sprintf(title, "ͶƱ, v ͶƱ");
	else
		strcpy(title, bp->title + 8);

	showtitle(header, title);
	prints("뿪[[1;32m[m,[1;32me[m] ѡ[[1;32m[m,[1;32m[m] Ķ[[1;32m[m,[1;32mRtn[m] [[1;32mCtrl-P[m] [[1;32md[m] ¼[[1;32mTAB[m] [[1;32mh[m]\n");
	if (digestmode == 0) {
		if (DEFINE(DEF_THESIS))	/* youzi 1997.7.8 */
			strcpy(readmode, "");
		else
			strcpy(readmode, "һ");
	} else if (digestmode == 1)
		strcpy(readmode, "ժ");
	else if (digestmode == 2)
		strcpy(readmode, "");
	else if (digestmode == 3)
		strcpy(readmode,"MARK");
	else if (digestmode == 4)
		strcpy(readmode,"ԭ");
	else if (digestmode == 7)
		strcpy(readmode,"ؼ");
	if (DEFINE(DEF_THESIS) && digestmode == 0)
		prints("[1;37;44m    %-12s %6s %-38s[%4sʽ] [m\n", "  ", "  ", "   ", readmode);
	else if (digestmode == 5 || digestmode == 6)
		prints("[1;37;44m    %-12s %6s %-10s (ؼ: [32m%-12s[37m) [[33m%s[37mͬĶ] [m\n","  ", "  ", "   ", someoneID,(digestmode==5)?"ģ":"ȷ");
	else if (digestmode == 7 )
		prints("[1;37;44m    %-12s %6s %-32s[%10sʽ] [m\n", "  ", "  ", "   ", readmode);
	else
		prints("[1;37;44m    %-12s %6s %-40s[%4sģʽ] [m\n", "  ", "  ", "   ", readmode);
	clrtobot();
}

char   *
readdoent(num, ent)    // б 
int     num;
struct fileheader *ent;
{
	static char buf[128];
	struct shortfile *bp;
	time_t  filetime;
	char   *date;
	char   *TITLE, color[10];
	int     type;
#ifdef COLOR_POST_DATE
	struct tm *mytm;
#endif
	type = brc_unread(ent->filename) ? 
			(!DEFINE(DEF_NOT_N_MASK)?'N':'+') : ' ';
	if ((ent->accessed[0] & FILE_DIGEST) /* && HAS_PERM(PERM_MARKPOST) */ ) {
		if (type == ' ')
			type = 'g';
		else
			type = 'G';
	}
	if (ent->accessed[0] & FILE_MARKED) {
		switch (type) {
		case ' ':
			type = 'm';
			break;
		case 'N': case '+':
			type = 'M';
			break;
		case 'g':
			type = 'b';
			break;
		case 'G':
			type = 'B';
			break;
		}
	}
	if(ent->accessed[0] & FILE_DELETED  && chk_currBM(currBM)) {
		if(brc_unread(ent->filename))type = 'X'; // deardragon 0729
		else type = 'x';
	}	
	bp = getbcache(currboard);
	if ( ent->accessed[0] & FILE_NOREPLY || bp->flag & NOREPLY_FLAG)
		 noreply = 1;
	else noreply = 0;
	filetime = atoi(ent->filename + 2);
	if (filetime > 740000000) {
		date = ctime(&filetime) + 4;
	} else {
		date = "";
	}

#ifdef COLOR_POST_DATE
	mytm = localtime(&filetime);
	strftime(buf, 5, "%w", mytm);
	sprintf(color, "[1;%dm", 30 + atoi(buf) + 1);
#else
	strcpy(color, "");
#endif

	/* Re-Write By Excellent */

	/* 990604.edwardc ˳һ .. */

	TITLE = ent->title;

	if ( TITLE[47] )
		strcpy(TITLE + 44, "...");  /* Ѷŵ string  */
		
   if (FFLL == 0) {
      if (!strncmp("Re: ", ent->title, 4)) {
          sprintf(buf, " %4d %c %-12.12s %s%6.6s[m %s%-.48s ", num, type,
	  ent->owner, color, date, noreply?"[0;1;4;33mx[m":" ",TITLE);
      } else {
          sprintf(buf, " %4d %c %-12.12s %s%6.6s[m %s %-.45s ", num, type,
	  ent->owner, color, date, noreply?"[0;1;4;33mx[m":" ",TITLE);
      }
   } else {
      if (!strncmp("Re: ", ent->title, 4)) {
          if (strncmp(ReplyPost, ent->title, 40) == 0) {
	     sprintf(buf, 
	         " [1;36m%4d[m %c %-12.12s %s%6.6s.%s[1;36m%-.48s[m ",
		 num, type, ent->owner, color, date, 
		 noreply?"[0;1;4;33mx[m":" ",TITLE);
	  } else {
	     sprintf(buf, " %4d %c %-12.12s %s%6.6s[m %s%-.48s ", num, type,
	     ent->owner, color, date, noreply?"[0;1;4;33mx[m":" ",TITLE);
          }
       } else {
          if (strncmp(ReadPost, ent->title, 40) == 0) {
	      sprintf(buf,
	         " [1;32m%4d[m %c %-12.12s %s%6.6s.%s[1;32m %-.45s[m "
		 ,num, type, ent->owner, color, date, 
		 noreply?"[0;1;4;33mx[m":" ",TITLE);
	   } else {
	      sprintf(buf, " %4d %c %-12.12s %s%6.6s[m %s %-.45s ",num,type,
	      ent->owner, color, date, noreply?"[0;1;4;33mx[m":" ",TITLE);
	   }
       }
   }
   noreply = 0;
   return buf;
}

char    currfile[STRLEN];

int
cmpfilename(fhdr)
struct fileheader *fhdr;
{
	if (!strncmp(fhdr->filename, currfile, STRLEN))
		return 1;
	return 0;
}

int
cmpdigestfilename(digest_name,fhdr)
char *digest_name;
struct fileheader *fhdr ;
{
    if(!strcmp(fhdr->filename,digest_name))
        return 1 ;
    return 0 ;
}     /* comapare file names for dele_digest function. Luzi 99.3.30 */

int cpyfilename( struct fileheader *fhdr )
{
   char    buf[STRLEN];
   time_t  tnow;
   struct tm *now;
   
   tnow = time(0);
   now = localtime(&tnow); 
   sprintf(buf, "-%s", fhdr->owner);
   strncpy(fhdr->owner, buf, IDLEN + 2);
   sprintf(buf, "<< ı %s  %d/%d %d:%02d:%02d ɾ >>",
      currentuser.userid, now->tm_mon + 1, now->tm_mday,
      now->tm_hour, now->tm_min, now->tm_sec);
   strncpy(fhdr->title, buf, STRLEN);
   fhdr->filename[STRLEN - 1] = 'L';
   fhdr->filename[STRLEN - 2] = 'L';
   return 0;
}

int
read_post(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	char   *t;
	char    buf[512];
	int     ch;
	int     cou;
	brc_addlist(fileinfo->filename);
	if (fileinfo->owner[0] == '-')
		return FULLUPDATE;
	clear();
	strcpy(buf, direct);
	if ((t = strrchr(buf, '/')) != NULL)
		*t = '\0';
	sprintf(genbuf, "%s/%s", buf, fileinfo->filename);
	if(!dashf(genbuf)) {
		clear();
		move(10,30);
		prints("Բ𣬱ݶʧ");
		pressanykey();
		return FULLUPDATE; //deardragon 0729
	}
	strncpy(quote_file, genbuf, sizeof(quote_file));
	strcpy(quote_board, currboard);
	strcpy(quote_title, fileinfo->title);
	quote_file[255] = fileinfo->filename[STRLEN - 2];
	strcpy(quote_user, fileinfo->owner);
#ifndef NOREPLY
	ch = ansimore(genbuf, NA);
#else
	ch = ansimore(genbuf, YEA);
#endif
#ifndef NOREPLY
	move(t_lines - 1, 0);
	clrtoeol();
	if (haspostperm(currboard)) {
		prints("[1;44;31m[Ķ]  [33m R   Q, һ һ <Space>,Ķ ^Xp [m");
	} else {
		prints("[1;44;31m[Ķ]  [33m Q, һ һ <Space>,<Enter>,Ķ ^X  p [m");
	}

	/* Re-Write By Excellent */

	FFLL = 1;
	if (strncmp(fileinfo->title, "Re:", 3) != 0) {
		strcpy(ReplyPost, "Re: ");
		strncat(ReplyPost, fileinfo->title, STRLEN - 4);
		strcpy(ReadPost, fileinfo->title);
	} else {
		strcpy(ReplyPost, fileinfo->title);
		for (cou = 0; cou < STRLEN; cou++)
			ReadPost[cou] = ReplyPost[cou + 4];
	}

	refresh();
#ifndef BBSD
	sleep(1);
#endif	
	if (!(ch == KEY_RIGHT || ch == KEY_UP || ch == KEY_PGUP))
		ch = egetch();

	switch (ch) {
	case 'N':
	case 'Q':
	case 'n':
	case 'q':
	case KEY_LEFT:
		break;
	case ' ':
	case 'j':
	case KEY_RIGHT:
		if (DEFINE(DEF_THESIS)) {	/* youzi */

			sread(0, 0, fileinfo);
			break;
		} else
			return READ_NEXT;
	case KEY_DOWN:
	case KEY_PGDN:
		return READ_NEXT;
	case KEY_UP:
	case KEY_PGUP:
		return READ_PREV;
	case 'Y':
	case 'R':
	case 'y':
	case 'r':
                 {	 struct shortfile *bp;
                        bp = getbcache(currboard);
			noreply = fileinfo->accessed[0] & FILE_NOREPLY 
					||bp->flag & NOREPLY_FLAG ;
			local_article=(fileinfo->filename[STRLEN-2]=='L');
                        if(!noreply || HAS_PERM(PERM_SYSOP) ||chk_currBM(currBM))
                                do_reply(fileinfo->title,fileinfo->owner);
                        else {
				clear();
                        	prints("\n\n    Բ, в RE , 㲻ܻظ(RE) ƪ.    ");
                        pressreturn();
                        clear();
                        }
		}
		break;
	case Ctrl('R'):
		post_reply(ent, fileinfo, direct);
		break;
	case 'g':
		digest_post(ent, fileinfo, direct);
		break;
	case Ctrl('U'):
		sread(1, 1, fileinfo);
		break;
	case Ctrl('N'):
		locate_the_post(fileinfo, fileinfo->title,5,0,1);
		sread(1, 0, fileinfo);
		break;
	case Ctrl('S'):
	case Ctrl('X'):
	case 'p':		/* Add by SmallPig */
		sread(0, 0, fileinfo);
		break;
	case Ctrl('A'):	/* Add by SmallPig */
		clear();
		show_author(0, fileinfo, '\0');
		return READ_NEXT;
		break;
	case 'S':		/* by youzi */
		if (!HAS_PERM(PERM_MESSAGE))
			break;
		clear();
		s_msg();
		break;
	default:
		break;
	}
#endif
	return FULLUPDATE;
}

int
skip_post(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	brc_addlist(fileinfo->filename);
	return GOTO_NEXT;
}

int
do_select(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	char    bname[STRLEN], bpath[STRLEN];
	struct stat st;
	move(0, 0);
	clrtoeol();
	prints("ѡһ (ӢĸСдԿ)\n");
	prints(" (հ׼ԶѰ): ");
	clrtoeol();

	make_blist();
	namecomplete((char *) NULL, bname);
	if(*bname == '\0') return FULLUPDATE;
	setbpath(bpath, bname);
	if (/* (*bname == '\0') || */(stat(bpath, &st) == -1)) {
		move(2, 0);
		prints("ȷ.\n");
		pressreturn();
		return FULLUPDATE;
	}
	if (!(st.st_mode & S_IFDIR)) {
		move(2, 0);
		prints("ȷ.\n");
		pressreturn();
		return FULLUPDATE;
	}
#ifdef BOARD_CONTROL
        if(!HAS_PERM(PERM_SYSOP)){
	   setbfile(genbuf, bname, "board.allow");
	   if(dashf(genbuf)&&!seek_in_file(genbuf,currentuser.userid)){
	      clear();
	      move(5,10);
	      prints("ܱǸ, 棬ǸðԱ");
	      pressanykey();
	      return FULLUPDATE;
	   }
        }
#endif
#ifdef BOARD_READDENY
        if(!HAS_PERM(PERM_SYSOP)){
	   setbfile(genbuf, bname, "board.deny");
	   if(dashf(genbuf)&&seek_in_file(genbuf,currentuser.userid)){
	      clear();
	      move(5,20);
	      prints("ԲĿǰֹͣ뱾Ȩ");
	      pressanykey();
	      return FULLUPDATE;
	   }
  	}
#endif
	selboard = 1;
	brc_initial(bname);

	move(0, 0);
	clrtoeol();
	move(1, 0);
	clrtoeol();
	setbdir(direct, currboard);
	return NEWDIRECT;
}

/*

int
read_letter(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	setmdir(direct,currentuser.userid);
	return NEWDIRECT;
}
*/

void
do_acction(type)
int type;
{
	char    buf[STRLEN];
	move(t_lines - 1, 0);
	clrtoeol();
	prints("[1;5mϵͳ, Ժ...[m\n");
	refresh();
	switch(type) {
		case 2:
			sprintf(buf, "bin/thread %s", currboard);
			system(buf);
			break;
		case 3:
		case 4:
		case 5: /* ͬ */
		case 6: /* ͬ  ȷ */
		case 7: /* ؼ */
			marked_all(type-3);
			break;
	}
}

int acction_mode()
{
	int type;
        extern char currdirect[STRLEN];
	char ch[4];

        if (digestmode != NA) {
		if(digestmode == 5 || digestmode == 6 ) {
			sprintf(genbuf,"boards/%s/SOMEONE.%s.DIR.%d",currboard,someoneID,digestmode-5);
			unlink(genbuf);
		} else if (digestmode == 7 ) {
			sprintf(genbuf,"boards/%s/KEY.%s.DIR",currboard,currentuser.userid);
			unlink(genbuf);
		}
                digestmode = NA;
                setbdir(currdirect, currboard);
        } else {
                saveline(t_lines - 1, 0);
                move(t_lines - 1, 0);
                clrtoeol();
	        ch[0] = '\0';
	        getdata(t_lines - 1, 0, "лģʽ: 1)ժ 2)ͬ 3) m  4)ԭ 5)ͬ 6)ؼ [1]: ", ch, 3, DOECHO, YEA);
		if ( ch[0] == '\0' ) ch[0] = '1';
	        type = atoi(ch);

	        if (type < 1 || type > 6) {
        	        saveline(t_lines - 1, 1);
                	return PARTUPDATE;
                } else if ( type == 6 ) {
                        getdata(t_lines-1,0,"ҵ±ؼ: ",
				someoneID,30,DOECHO,YEA);
			if(someoneID[0] == '\0') {
				saveline(t_lines-1,1);
				return PARTUPDATE;
			}
			type = 7;
	        } else if ( type == 5 ) {
			getdata(t_lines-1,0,"λѵ? ",someoneID,13,DOECHO,YEA);
			if(someoneID[0] == '\0' ) {
				saveline(t_lines -1 , 1);
				return PARTUPDATE;
			}
			getdata(t_lines-1,37, "ȷҰ Y ģس[Enter]",ch,2,DOECHO,YEA);
			if( ch[0] == 'y' || ch[0] == 'Y') type = 6;
		} 

                digestmode = type;
                setbdir(currdirect, currboard);
                if( digestmode != 1 )do_acction(type);
                if (!dashf(currdirect)) {
                        digestmode = NA;
                        setbdir(currdirect, currboard);
                        return PARTUPDATE;
                }
        }
        return NEWDIRECT;
}

int
dele_digest(dname, direc)
char   *dname;
char   *direc;
{
	char    digest_name[STRLEN];
	char    new_dir[STRLEN];
	char    buf[STRLEN];
	char   *ptr;
	struct fileheader fh;
	int     pos;
	strncpy(digest_name, dname,STRLEN);
	strcpy(new_dir, direc);
	digest_name[0] = 'G';
	ptr = strrchr(new_dir, '/') + 1;
	strcpy(ptr, DIGEST_DIR);
	strncpy(buf, currfile,STRLEN);
	strncpy(currfile, digest_name,STRLEN);
	pos = search_record(new_dir, &fh, sizeof(fh), cmpdigestfilename, digest_name);
	if (pos <= 0) {
		return;
	}
	delete_file(new_dir, sizeof(struct fileheader), pos, cmpfilename);
	strncpy(currfile, buf,STRLEN);
	*ptr = '\0';
	sprintf(buf, "%s%s", new_dir, digest_name);
	unlink(buf);
	return;
}

int
digest_post(ent, fhdr, direct)
int     ent;
struct fileheader *fhdr;
char   *direct;
{

	if (!chk_currBM(currBM)) {
		return DONOTHING;
	}
	if (digestmode == YEA)
		return DONOTHING;

	if (fhdr->accessed[0] & FILE_DIGEST) {
		fhdr->accessed[0] = (fhdr->accessed[0] & ~FILE_DIGEST);
		dele_digest(fhdr->filename, direct);
	} else {
		struct fileheader digest;
		char   *ptr, buf[64];
		memcpy(&digest, fhdr, sizeof(digest));
		digest.filename[0] = 'G';
		strcpy(buf, direct);
		ptr = strrchr(buf, '/') + 1;
		ptr[0] = '\0';
		sprintf(genbuf, "%s%s", buf, digest.filename);
		if (dashf(genbuf)) {
			fhdr->accessed[0] = fhdr->accessed[0] | FILE_DIGEST;
			substitute_record(direct, fhdr, sizeof(*fhdr), ent);
			return PARTUPDATE;
		}
		digest.accessed[0] = 0;
		sprintf(&genbuf[512], "%s%s", buf, fhdr->filename);
		link(&genbuf[512], genbuf);
		strcpy(ptr, DIGEST_DIR);
		if (get_num_records(buf, sizeof(digest)) > MAX_DIGEST) {
			move(3, 0);
			clrtobot();
			move(4, 10);
			prints("ǸժѾ %d ƪ޷ټ...\n", MAX_DIGEST);
			pressanykey();
			return PARTUPDATE;
		}
		append_record(buf, &digest, sizeof(digest));
		fhdr->accessed[0] = fhdr->accessed[0] | FILE_DIGEST;
		fhdr->accessed[0] &= ~FILE_DELETED;	
	}
	substitute_record(direct, fhdr, sizeof(*fhdr), ent);
	return PARTUPDATE;
}
#ifndef NOREPLY
int
do_reply(title,id)
char   *title,*id;
{
	strcpy(replytitle, title);
	post_article(currboard,id);
	replytitle[0] = '\0';
	return FULLUPDATE;
}
#endif

int
garbage_line(str)
char   *str;
{
	int     qlevel = 0;
	while (*str == ':' || *str == '>') {
		str++;
		if (*str == ' ')
			str++;
		if (qlevel++ >= 1)
			return 1;
	}
	while (*str == ' ' || *str == '\t')
		str++;
	if (qlevel >= 1)
		if (strstr(str, "ᵽ:\n") || strstr(str, ": \n") || strncmp(str, "==>", 3) == 0 || strstr(str, " "))
			return 1;
	return (*str == '\n');
}
/* this is a  for bad people to cover my program to his */

int
Origin2(text)
char    text[256];
{
        char    tmp[STRLEN];
        sprintf(tmp, ":%s %s[FROM:", BoardName, BBSHOST);
        if (strstr(text, tmp))
                return 1;
        else
                return 0;
}

/* When there is an old article that can be included -jjyang */
void do_quote(char *filepath, char quote_mode)
{
   FILE   *inf, *outf;
   char   *qfile, *quser;
   char    buf[256], *ptr;
   char    op;
   int     bflag, i;
   
   qfile = quote_file;
   quser = quote_user;
   bflag = strncmp(qfile, "mail", 4);
   outf = fopen(filepath, "w");
   if (quote_mode!='\0'&&*qfile!='\0'&&(inf=fopen(qfile, "r"))!=NULL){
      op = quote_mode;
      if (op != 'N') {
         fgets(buf, 256, inf);
	 if ((ptr = strrchr(buf, ')')) != NULL) {
	    ptr[1] = '\0';
	    if ((ptr = strchr(buf, ':')) != NULL) {
	       quser = ptr + 1;
	       while (*quser == ' ') quser++;
	    }
	 }
	 if (bflag)
	    fprintf(outf, "\n  %-.55s Ĵᵽ: \n", quser);
	 else
	    fprintf(outf, "\n  %-.55s ᵽ: \n", quser); 
	 if (op == 'A') {
	    while (fgets(buf, 256, inf) != NULL) {
	       fprintf(outf, ": %s", buf);
	    }
	 } else if (op == 'R') {
	    while (fgets(buf, 256, inf) != NULL){
	       if (buf[0] == '\n') break;
	    }   
	    while (fgets(buf, 256, inf) != NULL) {
	       if (Origin2(buf)) continue;
	       fprintf(outf, "%s", buf);
	    }
	 } else {
	    while (fgets(buf, 256, inf) != NULL){
	       if (buf[0] == '\n') break;
	    }   
	    i = 0;
	    while (fgets(buf, 256, inf) != NULL) {
	       if (strcmp(buf, "--\n") == 0) break;
	       if (buf[250] != '\0')
	          strcpy(buf + 250, "\n");
	       if (!garbage_line(buf)){
	          if(op == 'S' && i >= 10 ) {
		     fprintf(outf,": .................ʡԣ");
		     break;
		  } 
		  i ++;
	          fprintf(outf, ": %s", buf);
               }
            }
	 }
      }
      fprintf(outf, "\n");
      fclose(inf);
   }
   *quote_file = '\0';
   *quote_user = '\0'; 
   if (!(currentuser.signature == 0 || header.chk_anony == 1)) {
      addsignature(outf, 1);
   }
   fclose(outf);
}
/* Add by SmallPig */
void getcross(char *filepath, int mode)
{
   FILE   *inf, *of;
   char    buf[256];
   char    owner[248];
   int     count, owner_found = 0;
   #ifndef TIMECOUNTER
   time_t  now;
   #endif
   
   inf = fopen(quote_file, "r");
   of = fopen(filepath, "w");
   if (inf == NULL || of == NULL) {
      if(inf)fclose(inf);/* add fclose here and below by quickmouse 01/03/09 */
      if(of) fclose(of);
      report("Cross Post error");
      return;
   }
   if (mode == 0) {
      if (in_mail == YEA) {
         in_mail = NA;
	 write_header(of, 1 /* д .posts */ );
	 in_mail = YEA;
      } else
         write_header(of, 1 /* д .posts */ );
      if (fgets(buf, 256, inf) != NULL){
         if(strncmp(&buf[2],": ",6)) {
	    owner_found = 0;
	    strcpy(owner, "Unkown User");
	 } else {
	    for(count=8;buf[count]!=' '&&buf[count]!='\n'&&buf[count]!='\0';count++)
	       owner[count - 8] = buf[count];
	    owner[count - 8] = '\0';
	    owner_found = 1;
	 }
      }	 
      if (in_mail == YEA)
         fprintf(of, "[1;37m ת [32m%s [37m \n", 
	    currentuser.userid);
      else
         fprintf(of, "[1;37m ת [32m%s [37m \n", 
	    quote_board);
      if(owner_found) { /* Clear Post header */
         if(fgets(buf, 256, inf) != NULL) 
	    if (buf[0] != '\n') fgets(buf, 256, inf);
	 fprintf(of, " ԭ[32m %s[37m  [m\n", owner);
      } else fseek( inf, (long) 0, SEEK_SET);
   } else if (mode == 1) {
      fprintf(of,"[1;41;33m: %s (Զϵͳ), : %s%*s[m\n",
         BBSID,quote_board,48-strlen(BBSID)-strlen(quote_board)," ");
      fprintf(of, "  : %s\n", quote_title);
      #ifndef TIMECOUNTER
      now = time(0);
      getdatestring(now,NA);
      #else
      getnowdatestring();
      #endif
      fprintf(of, "վ: %s[33mԶϵͳ[m(%s)\n\n", 
         BoardName, datestring);
   } else if (mode == 2) {
      write_header(of, 0 /* д .posts */ );
   }
   while (fgets(buf, 256, inf) != NULL) {
      if ((strstr(buf," ת ")&&strstr(buf, " "))
       || (strstr(buf, " ԭ") && strstr(buf, " ")))
          continue;
      else
         fprintf(of, "%s", buf);
   }
   fclose(inf);
   fclose(of);
   *quote_file = '\0';
}


int
do_post()
{
	*quote_file = '\0';
	*quote_user = '\0';
	local_article = YEA;
	return post_article(currboard,(char *)NULL);
}
/*ARGSUSED*/
int
post_reply(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	char    uid[STRLEN];
	char    title[STRLEN];
	char   *t;
	FILE   *fp;
	if (!strcmp(currentuser.userid, "guest"))
		return DONOTHING;
	clear();
	if (check_maxmail()) {
		pressreturn();
		return FULLUPDATE;
	}
	modify_user_mode(SMAIL);

/* indicate the quote file/user */
	setbfile(quote_file, currboard, fileinfo->filename);
	strcpy(quote_user, fileinfo->owner);

/* find the author */
	if (!getuser(quote_user)) {
		genbuf[0] = '\0';
		fp = fopen(quote_file, "r");
		if (fp != NULL) {
			fgets(genbuf, 255, fp);
			fclose(fp);
		}
		t = strtok(genbuf, ":");
		if (strncmp(t, "", 6) == 0 ||
			strncmp(t, "", 6) == 0 ||
			strncmp(t, "Posted By", 9) == 0 ||
			strncmp(t, "  ", 6) == 0) {
			while (t != NULL) {
				t = (char *) strtok(NULL, " \r\t\n<>");
				if (t == NULL)
					break;
				if (!invalidaddr(t))
					break;
			}
			if (t != NULL)
				strncpy(uid, t, STRLEN);
		} else {
			prints("Բ𣬸ʺѾڡ\n");
			pressreturn();
		}
	} else
		strcpy(uid, quote_user);
	/* make the title */
	if (toupper(fileinfo->title[0]) != 'R' || fileinfo->title[1] != 'e' ||
		fileinfo->title[2] != ':')
		strcpy(title, "Re: ");
	else
		title[0] = '\0';
	strncat(title, fileinfo->title, STRLEN - 5);

/* edit, then send the mail */
	switch (do_send(uid, title)) {
	case -1:
		prints("ϵͳ޷\n");
		break;
	case -2:
		prints("ŶѾֹ\n");
		break;
	case -3:
		prints("ʹ '%s' ޷\n", uid);
		break;
	case -4: 
		prints("ʹ '%s' ޷ţ\n",uid);
		break;
	default:
		prints("żѳɹؼĸԭ %s\n", uid);
	}
	pressreturn();
	return FULLUPDATE;
}
/* Add by SmallPig */
int post_cross(char islocal, int mode)
{
   struct fileheader postfile;
   struct shortfile *bp;
   char    filepath[STRLEN], fname[STRLEN];
   char    buf[256], buf4[STRLEN], whopost[IDLEN + 2];
   int     fp, count;
   time_t  now;
   
   if (!haspostperm(currboard) && !mode) {
      prints("\n\nȨ %s 巢£ȡת\n", currboard);
      return -1;
   }
   memset(&postfile, 0, sizeof(postfile));
   strncpy(save_filename, fname, STRLEN); 
   now = time(0);
   sprintf(fname, "M.%d.A", now);
   if (!mode) {
      if (!strstr(quote_title,"(ת)"))sprintf(buf4,"%.70s(ת)",quote_title);
      else strcpy(buf4, quote_title);
   } else strcpy(buf4, quote_title);
   strncpy(save_title, buf4, STRLEN);
   setbfile(filepath, currboard, fname);
   count = 0; 
   while ((fp = open(filepath, O_CREAT | O_EXCL | O_WRONLY, 0644)) == -1) {
      now++;
      sprintf(fname, "M.%d.A", now);
      setbfile(filepath, currboard, fname);
      if (count++ > MAX_POSTRETRY) return -1;
   }
   close(fp);
   strcpy(postfile.filename, fname);
   if (mode == 1) strcpy(whopost, BBSID);
   else strcpy(whopost, currentuser.userid); 
   strncpy(postfile.owner, whopost, STRLEN);
   setbfile(filepath, currboard, postfile.filename); 
   bp = getbcache(currboard);
   local_article = YEA;
   if ((islocal == 'S' || islocal == 's') && (bp->flag & OUT_FLAG))
      local_article = NA;
   modify_user_mode(POSTING); 
   getcross(filepath, mode); 
   strncpy(postfile.title, save_title, STRLEN);
   if(mode==1) postfile.accessed[0] |= FILE_MARKED;
   if (local_article == YEA || !(bp->flag & OUT_FLAG)) {
      postfile.filename[STRLEN - 1] = 'L';
      postfile.filename[STRLEN - 2] = 'L';
   } else {
      postfile.filename[STRLEN - 1] = 'S';
      postfile.filename[STRLEN - 2] = 'S';
      outgo_post(&postfile, currboard);
   }
   setbdir(buf, currboard);
   if (append_record(buf, &postfile, sizeof(postfile)) == -1) {
      if (!mode) {
         sprintf(buf, "cross_posting '%s' on '%s': append_record failed!",
	    postfile.title, quote_board);
      } else {
         sprintf(buf, "Posting '%s' on '%s': append_record failed!",
	    postfile.title, quote_board);
      }
      report(buf);
      pressreturn();
      clear();
      return 1;
   }
   if (!mode) {
      add_crossinfo(filepath, 1);
      sprintf(buf, "cross_posted '%s' on '%s'", postfile.title, currboard);
      report(buf);
   }
   return 1;
}

void 
add_crossinfo(filepath, mode)
char   *filepath;
int     mode;
{
	FILE   *fp;
	int     color;
	color = (currentuser.numlogins % 7) + 31;
	if ((fp = fopen(filepath, "a")) == NULL)
		return;
	fprintf(fp, "--\n[m[1;%2dm ת%s:%s %s[FROM: %-.20s][m\n"
		,color, (mode == 1) ? "" : "", BoardName, BBSHOST, fromhost);
	fclose(fp);
	return;
}

int
show_board_notes(bname, command)
char    bname[30];
{
	char    buf[256];
	sprintf(buf, "vote/%s/notes", bname);
	if (dashf(buf)) {
		if (command == 1) {
			ansimore2(buf, NA, 0, 19);
		} else {
			ansimore(buf);
		}
		return 1;
	} else if (dashf("vote/notes")) {
		if (command == 1) {
			ansimore2("vote/notes", NA, 0, 19);
		} else {
			ansimore("vote/notes", NA, 0, 19);
		}
		return 1;
	}
	return -1;
}

int
show_user_notes()
{
	char    buf[256];
	setuserfile(buf, "notes");
	if (dashf(buf)) {
		ansimore(buf);
		return FULLUPDATE;
	}
	clear();
	move(10, 15);
	prints("δ InfoEdit->WriteFile ༭˱¼\n");
	pressanykey();
	return FULLUPDATE;
}


int
outgo_post(fh, board)
struct fileheader *fh;
char   *board;
{
	char    buf[256];
	sprintf(buf, "%s\t%s\t%s\t%s\t%s\n", board,
		fh->filename, header.chk_anony ? board : currentuser.userid,
		header.chk_anony ? "ʹ" : currentuser.username, save_title);
	file_append("innd/out.bntp", buf);

}

int
post_article(postboard,mailid)
char   *postboard,*mailid;
{
	struct fileheader postfile;
	struct shortfile *bp;
	char    filepath[STRLEN], fname[STRLEN], buf[STRLEN];
	int     fp, aborted, count;
	time_t  now = time(0);
	static  time_t  lastposttime = 0;
	static  int  failure = 0;

	modify_user_mode(POSTING);
	//added by soff ֹˮ 2000.10.08
	if((abs(now-lastposttime)<3 || failure >= 9999)&&
	   (!HAS_PERM(PERM_SYSOP))) { 
	   clear();
	   move(5,10);
	   failure++;
	   if(failure > 9999){
	      if( failure >= 10020 ) abort_bbs();
	      prints("ԲڱȰε£Բͼġ");
	      move(6,10);
	      prints("Ŀǰϵͳ϶Ϊˮ˳µ½[%d/20]",
	         failure - 9999);
	   } else {   
	      prints("̫ˣȺȱЪ3 Ӻٷ¡\n");
	      if( failure > 5 ) {
	         move(6,10);
	         prints("ڱȰԾͼ¡[%d/20]",
		   failure-5);
	         if (failure >= 25) {
	            securityreport("ͼ£ϵͳжΪˮ");
		    failure = 9999;
	         }
	      }
	      lastposttime = now;
	   }   
	   pressreturn();
	   clear();
	   return FULLUPDATE;
	}
	if (!haspostperm(postboard)) {
		move(5, 10);
		clrtobot();
		if (digestmode == NA) {
		   prints("Ψ, Ȩڴ˷¡");
		} else {
		   prints("Ŀǰժģʽ, ܷ ( ENTER ٰ뿪ģʽ)");
		}
		pressreturn();
		clear();
		return FULLUPDATE;
	} 
	memset(&postfile, 0, sizeof(postfile));
	clear();
	show_board_notes(postboard, 1);
	bp = getbcache(postboard);
	if(bp->flag&OUT_FLAG && replytitle[0] == '\0') local_article = NA;
#ifndef NOREPLY
	if (replytitle[0] != '\0') {
		if (strncmp(replytitle, "Re: ", 4) == 0)
			strcpy(header.title, replytitle);
		else
			sprintf(header.title, "Re: %s", replytitle);
		header.reply_mode = 1;
	} else
#endif
	{
		header.title[0] = '\0';
		header.reply_mode = 0;

	}
	strcpy(header.ds, postboard);
	header.postboard = YEA;
	if (post_header(&header) == YEA) {
		strcpy(postfile.title, header.title);
		strncpy(save_title, postfile.title, STRLEN);
		strncpy(save_filename, fname, STRLEN);
	} else
		return FULLUPDATE;
	now = time(0);
	lastposttime = now;//added by soff ֹˮ 2000.10.08
	failure = 0;
	sprintf(fname, "M.%d.A", now);
	setbfile(filepath, postboard, fname);
	count = 0;
	while ((fp = open(filepath, O_CREAT | O_EXCL | O_WRONLY, 0644)) == -1) {
		now++;
		sprintf(fname, "M.%d.A", now);
		setbfile(filepath, postboard, fname);
		if (count++ > MAX_POSTRETRY) {
			return -1;
		}
	}
	fchmod(fp, 0644);	/* youzi 1999.1.8 */
	close(fp);
	strcpy(postfile.filename, fname);
	in_mail = NA;
	strncpy(postfile.owner, (header.chk_anony) ?
		postboard : currentuser.userid, STRLEN);
	setbfile(filepath, postboard, postfile.filename);
	modify_user_mode(POSTING);
	do_quote(filepath, header.include_mode);
#ifdef ALLOWGAME	
	post_time = time(0);
	post_word = 0;
#endif	
	aborted = vedit(filepath, YEA, YEA);
#ifdef ALLOWGAME	
	post_time = time(0) - post_time;
#endif	
	strncpy(postfile.title, save_title, STRLEN);
	if ((local_article == YEA) || !(bp->flag & OUT_FLAG)) {
		postfile.filename[STRLEN - 1] = 'L';
		postfile.filename[STRLEN - 2] = 'L';
	} else {
		postfile.filename[STRLEN - 1] = 'S';
		postfile.filename[STRLEN - 2] = 'S';
		outgo_post(&postfile, postboard);
	}
	/* Anony=0; *//* Inital For ShowOut Signature */
	if (aborted == -1) {
		unlink(filepath);
		clear();
		return FULLUPDATE;
	}
	setbdir(buf, postboard);
        if ( noreply ) {
                postfile.accessed[0] |= FILE_NOREPLY;
                noreply = 0;
        }
#ifdef MARK_X_FLAG
	if( markXflag ) {
		postfile.accessed[0] |= FILE_DELETED;
		markXflag = 0;
	} else  postfile.accessed[0] &= ~FILE_DELETED;
#endif
	if( mailtoauther ) {
		if(header.chk_anony)
			prints("ԲʹüŸԭ߹ܡ");
		else if(!mail_file(filepath,mailid,postfile.title))
			prints("żѳɹؼĸԭ %s",mailid);
		else prints("żʼʧܣ%s ޷š",mailid);
		mailtoauther = 0;
		pressanykey();
	}
	if (append_record(buf, &postfile, sizeof(postfile)) == -1) {
		sprintf(buf, "posting '%s' on '%s': append_record failed!",
			postfile.title, currboard);
		report(buf);
		pressreturn();
		clear();
		return FULLUPDATE;
	}
	brc_addlist(postfile.filename);

	sprintf(buf, "posted '%s' on '%s'", postfile.title, currboard);
	report(buf);

   if (!junkboard()) {
      set_safe_record();
      currentuser.numposts++;
#ifdef ALLOWGAME
      post_word /= 10;
      if(post_time < post_word) post_word = post_time;
      if(post_word > 50) post_word = 50;
      currentuser.money += post_word;
#endif
      substitute_record(PASSFILE, &currentuser, sizeof(currentuser), usernum);
#ifdef ALLOWGAME
   } else {
      set_safe_record();
      currentuser.money += 1;
      substitute_record(PASSFILE, &currentuser, sizeof(currentuser), usernum);
#endif
   }   
	return FULLUPDATE;
}

int IsTheFileOwner(struct fileheader *fileinfo)
{
   char    buf[512];
   int	posttime;
   
   if(fileinfo->owner[0] == '-'||strstr(fileinfo->owner, ".")) return 0;
   if(strcmp(currentuser.userid, fileinfo->owner)) return 0;
   strcpy(buf,&(fileinfo->filename[2]));
   buf[strlen(buf)-2] = '\0';
   posttime = atoi(buf);
   if( posttime < currentuser.firstlogin ) return 0;
   return 1;
}   

int change_title(char *fname, char *title)
{
   FILE   *fp, *out;
   char    buf[256], outname[STRLEN];
   int newtitle = 0 ;
   
   if ((fp = fopen(fname, "r")) == NULL) return 0; 
   sprintf(outname, "tmp/editpost.%s.%05d", currentuser.userid, uinfo.pid);
   if ((out = fopen(outname, "w")) == NULL){
      fclose(fp); /* add by quickmouse 01/03/09 */
      return 0; 
   } 
   while ((fgets(buf, 256, fp)) != NULL) {
      if (!strncmp(buf, "  : ", 8) && newtitle ==0){ 
         fprintf(out, "  : %s\n", title);
	 newtitle = 1;
         continue;
      }
      fputs(buf, out);
   }
   fclose(fp);
   fclose(out);
   rename(outname, fname);
   chmod(fname, 0644);
   return;
}

int edit_post(int ent, struct fileheader *fileinfo, char *direct)
{
   char    buf[512];
   char   *t;
   extern char currmaildir[STRLEN];
   int		isBM = 0;
   
   isBM = chk_currBM(currBM)?YEA:NA;
   /* wujian 2000.8.1 */
   if (digestmode != NA && isBM == NA) return DONOTHING;
   /* end */
   if (!in_mail) {
      if (isBM == NA) {
         struct shortfile *bp;
	 if(!IsTheFileOwner(fileinfo)) return DONOTHING;
	 bp = getbcache(currboard);
	 if ((bp->flag & ANONY_FLAG) && !strcmp(fileinfo->owner, currboard))
	    return DONOTHING;
      }
   }
   modify_user_mode(EDIT);
   clear();
   if (in_mail) strcpy(buf, currmaildir);
   else strcpy(buf, direct);
   if ((t = strrchr(buf, '/')) != NULL) *t = '\0';
   sprintf(genbuf, "%s/%s", buf, fileinfo->filename);
   if (vedit(genbuf, NA, NA) == -1)  return FULLUPDATE;
#ifdef MARK_X_FLAG
   if( markXflag ) {
      fileinfo->accessed[0] |= FILE_DELETED;
      markXflag = 0;
   } else  fileinfo->accessed[0] &= ~FILE_DELETED;
   substitute_record(direct, fileinfo, sizeof(*fileinfo), ent);
#endif
   if (!in_mail) {
      sprintf(genbuf, "edited post '%s' on %s", fileinfo->title, currboard);
      report(genbuf);
   }
   return FULLUPDATE;
}

int
edit_title(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	char    buf[STRLEN];
	long   i;
	struct fileheader xfh;

	if (!chk_currBM(currBM)) {
		struct shortfile *bp;
		if(digestmode != NA) return DONOTHING;
		if(!IsTheFileOwner(fileinfo)) return DONOTHING;
		bp = getbcache(currboard);
		if ((bp->flag & ANONY_FLAG) && !strcmp(fileinfo->owner, currboard))
			return DONOTHING;
	}
	strcpy(buf,fileinfo->title);
	getdata(t_lines - 1, 0, "±: ", buf, 50, DOECHO, NA);
	if(!strcmp(buf,fileinfo->title)) return PARTUPDATE;
	check_title(buf);
	if (buf[0] != '\0') {
		char    tmp[STRLEN * 2], *t;
		strcpy(fileinfo->title, buf);
		strcpy(tmp, direct);
		if ((t = strrchr(tmp, '/')) != NULL)
			*t = '\0';
		sprintf(genbuf, "%s/%s", tmp, fileinfo->filename);
 		change_title(genbuf, buf);
		/* Leeward 99.07.12 added below to fix a big bug */
		setbdir(buf, currboard);
		for (i = ent; i > 0; i --) {
		   if (0 == get_record(buf, &xfh, sizeof(xfh), i)) {
		      if (0 == strcmp(xfh.filename, fileinfo->filename)) {
		         ent = i;
			 break;
		      }
		   }
	  	}
		if (0 == i) return PARTUPDATE;
		/* Leeward 99.07.12 added above to fix a big bug */
		substitute_record(direct, fileinfo, sizeof(*fileinfo), ent);
	}
	return PARTUPDATE;
}

int
underline_post(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	if(!chk_currBM(currBM)&&!IsTheFileOwner(fileinfo)) {
                return DONOTHING;
        }
        if (fileinfo->accessed[0] & FILE_NOREPLY)
	{
                fileinfo->accessed[0] &= ~FILE_NOREPLY;
        } else {
                fileinfo->accessed[0] |= FILE_NOREPLY;
	}
        substitute_record(direct, fileinfo, sizeof(*fileinfo), ent);
        return PARTUPDATE;
}

int
makeDELETEDflag(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
        if (!(chk_currBM(currBM))||
		fileinfo->accessed[0] & (FILE_MARKED|FILE_DIGEST))
 	{
                return DONOTHING;
        }
        if (fileinfo->accessed[0] & FILE_DELETED)
        {
                fileinfo->accessed[0] &= ~FILE_DELETED;
        } else {
                fileinfo->accessed[0] |= FILE_DELETED;
        }
        substitute_record(direct, fileinfo, sizeof(*fileinfo), ent);
        return PARTUPDATE;
}

int
mark_post(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	if (!chk_currBM(currBM)) {
		return DONOTHING;
	}
	if (fileinfo->accessed[0] & FILE_MARKED)
		fileinfo->accessed[0] &= ~FILE_MARKED;
	else {
		fileinfo->accessed[0] |= FILE_MARKED;
		fileinfo->accessed[0] &= ~FILE_DELETED;	
	}	
	substitute_record(direct, fileinfo, sizeof(*fileinfo), ent);
	return PARTUPDATE;
}

int del_range(int ent, struct fileheader *fileinfo, char *direct)
{
   char    num[8];
   int     inum1, inum2;
   
   if (uinfo.mode == READING){
      if (!chk_currBM(currBM)) {
         return DONOTHING;
      }
   }   
   if (digestmode > 1) return DONOTHING;
   getdata(t_lines - 1, 0, "ƪ±: ", num, 6, DOECHO, YEA);
   inum1 = atoi(num);
   if (inum1 <= 0) {
      move(t_lines - 1, 50);
      prints("...");
      egetch();
      return PARTUPDATE;
   }
   getdata(t_lines - 1, 25, "ĩƪ±: ", num, 6, DOECHO, YEA);
   inum2 = atoi(num);
   if (inum2 < inum1 + 1) {
      move(t_lines - 1, 50);
      prints("...");
      egetch();
      return PARTUPDATE;
   }
   move(t_lines - 1, 50);
   if (askyn("ȷɾ", NA, NA) == YEA) {
      delete_range(direct, inum1, inum2);
      fixkeep(direct, inum1, inum2);
      if (uinfo.mode == READING) {
         sprintf(genbuf, "Range delete %d-%d on %s", inum1, inum2, currboard);
	 securityreport(genbuf);
      } else {
         sprintf(genbuf, "Range delete %d-%d in mailbox", inum1, inum2);
      }
      report(genbuf);
      return DIRCHANGED;
   }
   move(t_lines - 1, 50);
   clrtoeol();
   prints("ɾ...");
   egetch();
   return PARTUPDATE;
}
int
UndeleteArticle(ent,fileinfo,direct)  /* undelete һƪ Leeward 98.05.18 */
int ent;
struct fileheader *fileinfo;
char *direct;
{
    char *p, buf[1024];
    char UBoard[48] = "deleted";
    char UTitle[128];
    struct fileheader UFile;
    int i;
#ifdef KEEP_DELETED_HEADER
	int kind = 0;
#endif
    FILE *fp;

    if (strcmp(currboard, "deleted")&&strcmp(currboard,"junk")) {
#ifdef KEEP_DELETED_HEADER
        if( fileinfo->owner[0] != '-') return DONOTHING;
	kind = 1;
#else
	return DONOTHING;
#endif
    }
    sprintf(buf, "boards/%s/%s", currboard, fileinfo->filename);
    fp = fopen(buf, "r");
    if (!fp)
      return DONOTHING;

    strcpy(UTitle, fileinfo->title);
    if (p = strrchr(UTitle, '-'))
    { /* create default article title */
      *p = 0;
      for (i = strlen(UTitle) - 1; i >= 0; i --)
      {
        if (UTitle[i] != ' ')
          break;
        else
          UTitle[i] = 0;
      }
    }

    i = 0;
    while (!feof(fp) && i < 2)
    {
      fgets(buf, 1024, fp);
      if (feof(fp))
        break;
      if (strstr(buf, ": ") && (p = strstr(buf, "), : ")))
      {
        i ++;
        strcpy(UBoard, p + 9);
        if (p = strchr(UBoard, ' '))
          *p = 0;
        else if (p = strchr(UBoard, '\n'))
          *p = 0;
      }
  else if (strstr(buf, "  : "))
      {
        i ++;
        strcpy(UTitle, buf + 8);
        if (p = strchr(UTitle, '\n'))
          *p = 0;
      }
    }
    fclose(fp);

#ifdef KEEP_DELETED_HEADER
    if(kind) {
	strncpy(fileinfo->owner,&(fileinfo->owner[1]),IDLEN + 2 );
	strncpy(fileinfo->title,UTitle,STRLEN);
        fileinfo->filename[STRLEN - 1] = 'L';
        fileinfo->filename[STRLEN - 2] = 'L';
	substitute_record(direct, fileinfo, sizeof(*fileinfo), ent);
        if (!strcmp(fileinfo->owner,currentuser.userid)) {
                        set_safe_record();
                        if (!junkboard())
                                currentuser.numposts++;
                        substitute_record(PASSFILE, &currentuser,
                                sizeof(currentuser), usernum);
        } else if (!strstr(fileinfo->owner, ".") && BMDEL_DECREASE) {
             int     id;
             if (id = getuser(fileinfo->owner))
        	     if (!junkboard()) {
                            lookupuser.numposts++;
                            substitute_record(PASSFILE, &lookupuser,
				 sizeof(struct userec), id);
                     }
        }
	return DIRCHANGED;
    }
#endif
    
    if (fileinfo->accessed[0] & FILE_FORWARDED)
    {
      if(SR_BMDELFLAG!=YEA) {
         clear();
	 move(2,0);
	 prints("ѻָ\n");
	 pressreturn();
      }
      return FULLUPDATE;
    }

    UFile.accessed[0] = 0;
    strcpy(UFile.owner, fileinfo->owner);
    strcpy(UFile.title, UTitle);
    strcpy(UFile.filename, fileinfo->filename);

    sprintf(buf, "/bin/cp -f boards/%s/%s boards/%s/%s",
      currboard, fileinfo->filename, UBoard, UFile.filename);
    system(buf);

    sprintf(buf, "boards/%s/.DIR", UBoard);
    append_record(buf, &UFile, sizeof(UFile));

    fileinfo->accessed[0] |= FILE_FORWARDED;
    substitute_record(direct, fileinfo, sizeof(*fileinfo),ent) ;
    sprintf(buf,"undeleted %s's %s on %s", UFile.owner, UFile.title, UBoard);
    report(buf);
    if(SR_BMDELFLAG != YEA){
       clear();
       move(2,0);
       prints("'%s' ѻָ %s  \n", UFile.title, UBoard);
       pressreturn();
    }
    return FULLUPDATE;
}

int del_post(int ent, struct fileheader *fileinfo, char *direct)
{
   char    buf[512];
   char    usrid[STRLEN];
   char   *t;
   int     owned=0, fail, IScurrent=0;
   int 	posttime;
   
   if (fileinfo->accessed[0] & (FILE_MARKED|FILE_DIGEST)) return DONOTHING;
   if (digestmode>1||!strcmp(currboard,"deleted")||!strcmp(currboard,"junk"))
      return DONOTHING;
   if (fileinfo->owner[0] == '-') return DONOTHING;
   strcpy(usrid, fileinfo->owner);
   if ( !strstr(usrid, ".") )
      IScurrent = !strcmp(usrid, currentuser.userid);
   
   strcpy(buf,&(fileinfo->filename[2]));
   buf[strlen(buf)-2] = '\0';
   posttime = atoi(buf);
   if( !IScurrent ) {
      owned = getuser(usrid);
      if( owned!=0 ) {
         if(posttime < lookupuser.firstlogin) owned = 0;
      }	 
   } else owned =  posttime > currentuser.firstlogin; 
   
   if (!chk_currBM(currBM)) {
      struct shortfile *bp;
      if (! (owned && IScurrent)) return DONOTHING;
      bp = getbcache(currboard);
      if ((bp->flag & ANONY_FLAG) && !strcmp(usrid, currboard))
         return DONOTHING;
#ifdef ALLOWGAME	 
      if(currentuser.money < 50) return DONOTHING;	 
#endif      
   }
   if (!SR_BMDELFLAG) {
      sprintf(genbuf, "ɾ [%-.55s]", fileinfo->title);
      if (askyn(genbuf, NA, YEA) == NA) {
         move(t_lines - 1, 0);
	 prints("ɾ...");
	 clrtoeol();
	 egetch();
	 return PARTUPDATE;
      }
   }
   strncpy(currfile, fileinfo->filename, STRLEN);
#ifndef KEEP_DELETED_HEADER
   fail = delete_file(direct, sizeof(struct fileheader), ent, cmpfilename);
#else
   fail = update_file(direct, sizeof(struct fileheader), ent, cmpfilename,
			cpyfilename);
#endif
   if (!fail) {
      strcpy(buf, direct);
      if ((t = strrchr(buf, '/')) != NULL) *t = '\0';
      sprintf(genbuf, "Del '%s' on '%s'", fileinfo->title, currboard);
      report(genbuf);   

      cancelpost(currboard, currentuser.userid, fileinfo, owned && IScurrent);

      sprintf(genbuf, "%s/%s", buf, fileinfo->filename);
#ifndef KEEP_DELETED_HEADER
      unlink(genbuf);
#endif
#ifndef ALLOWGAME
      if ( !junkboard() && !digestmode) {
#endif      
         if (owned && IScurrent) {
	    set_safe_record();
	    if (currentuser.numposts > 0 ) currentuser.numposts--;
#ifdef ALLOWGAME
            if(currentuser.money > 50) currentuser.money -= 50;
            else currentuser.money = 0;
#endif
	    substitute_record(PASSFILE,&currentuser,sizeof(currentuser),usernum);
         } else if ( owned && BMDEL_DECREASE) {
	    if (lookupuser.numposts > 0) lookupuser.numposts--;
#ifdef ALLOWGAME
            if(lookupuser.money > 50) lookupuser.money -= 50;
            else lookupuser.money = 0;
#endif
	    substitute_record(PASSFILE,&lookupuser,sizeof(struct userec),owned);
	 }
#ifndef ALLOWGAME
      }
#endif      
      return DIRCHANGED;
   } else if(SR_BMDELFLAG){
      return -1;
   }
   move(t_lines - 1, 0);
   prints("ɾʧ...");
   clrtoeol();
   egetch();
   return PARTUPDATE;
}

#ifdef QCLEARNEWFLAG
#define BRC_MAXNUM 60
int flag_clearto(int ent, char *direct, int clearall)
{
   int i, fd, posttime, size;
   char filename[20];
   struct fileheader f_info;
   if(uinfo.mode != READING) return DONOTHING;
   if( (fd = open(direct, O_RDONLY, 0)) == -1 ) return DONOTHING;
   size = sizeof(struct fileheader);
   if(clearall)
      lseek(fd, (off_t)(-size), SEEK_END);
   else
      lseek(fd, (off_t)((ent-1)*size), SEEK_SET);
   read(fd, &f_info, size);
   close(fd);
   posttime = atoi(&(f_info.filename[2])) - BRC_MAXNUM + 1;
   for(i = 0; i < BRC_MAXNUM; i ++){
      sprintf(filename,"M.%d.A",posttime++);
      brc_addlist(filename);
   }
   return PARTUPDATE;
}
#else
int flag_clearto(int ent, char *direct, int clearall)
{
   int fd, i;
   struct fileheader f_info;
   if(uinfo.mode != READING) return DONOTHING;
   if( (fd = open(direct, O_RDONLY, 0)) == -1 ) return DONOTHING;
   for(i = 0; clearall || i < ent; i ++){
      if(read(fd, &f_info, sizeof(f_info)) != sizeof(f_info))
         break;
      brc_addlist(f_info.filename);
   }
   close(fd);
   return PARTUPDATE;
}
#endif

int new_flag_clearto(int ent, struct fileheader *fileinfo, char *direct)
{
	return flag_clearto(ent, direct, NA);
}

int new_flag_clear(int ent, struct fileheader *fileinfo, char *direct)
{
	return flag_clearto(ent, direct, YEA);
}

/* Added by netty to handle post saving into (0)Announce */
int full_Save_post(int ent, struct fileheader *fileinfo, char *direct)
{
   return Save_post(ent, fileinfo, direct,1);
}

int part_Save_post(int ent, struct fileheader *fileinfo, char *direct)
{
   return Save_post(ent, fileinfo, direct,0);
}

int Save_post(int ent, struct fileheader *fileinfo, char *direct, int full)
{
   if (!chk_currBM(currBM)) return DONOTHING;
   return (a_Save("0Announce", currboard, fileinfo, NA, full));
}
/* Added by netty to handle post saving into (0)Announce */
int Import_post(int ent, struct fileheader *fileinfo, char *direct)
{
   FILE *fn;
   char annpath[512];
   if (!HAS_PERM(PERM_BOARDS|PERM_PERSONAL)) return DONOTHING;
   sethomefile(annpath, currentuser.userid,".announcepath");
   if((fn = fopen(annpath, "r")) == NULL ) {
      presskeyfor("Բ, û趨˿·.  f 趨˿·.",t_lines-1);
      return 1;
   }
   fscanf(fn,"%s",annpath);
   fclose(fn);
   if (!dashd(annpath)) {
      presskeyfor("趨˿·Ѷʧ,  f 趨.",t_lines-1);
      return 1;
   }
   if(fileinfo->accessed[0] & FILE_VISIT){
      if(askyn("˾, ڻҪٷ",YEA,YEA)==NA) return 1;
   } else {
      fileinfo->accessed[0] |= FILE_VISIT;  /* ־λ */
      substitute_record(direct, fileinfo, sizeof(*fileinfo), ent);
   }
   return (a_Import("0Announce", currboard, fileinfo, annpath, NA));
}

int
check_notespasswd()
{
	FILE   *pass;
	char    passbuf[20], prepass[STRLEN];
	char    buf[STRLEN];
	setvfile(buf, currboard, "notespasswd");
	if ((pass = fopen(buf, "r")) != NULL) {
		fgets(prepass, STRLEN, pass);
		fclose(pass);
		prepass[strlen(prepass) - 1] = '\0';
		getdata(2, 0, "ܱ¼: ", passbuf, 19, NOECHO, YEA);
		if (passbuf[0] == '\0' || passbuf[0] == '\n')
			return NA;
		if (!checkpasswd(prepass, passbuf)) {
			move(3, 0);
			prints("ܱ¼...");
			pressanykey();
			return NA;
		}
	}
	return YEA;
}

int
show_b_secnote()
{
	char    buf[256];
	clear();
	setvfile(buf, currboard, "secnotes");
	if (dashf(buf)) {
		if (!check_notespasswd())
			return FULLUPDATE;
		clear();
		ansimore(buf, NA);
	} else {
		move(3, 25);
		prints("ޡܱ¼");
	}
	pressanykey();
	return FULLUPDATE;
}

int
show_b_note()
{
	clear();
	if (show_board_notes(currboard, 2) == -1) {
		move(3, 30);
		prints("ޡ¼");
		pressanykey();
	}
	return FULLUPDATE;
}

int
into_announce()
{
	char	found[STRLEN];
	if (a_menusearch("0Announce", currboard, found)){ 
		a_menu("",found, 
			((HAS_PERM(PERM_ANNOUNCE) || HAS_PERM(PERM_SYSOP) 
			|| HAS_PERM(PERM_OBOARDS)) ? PERM_BOARDS : 0),0);
		//return FULLUPDATE;
		return MODECHANGED;
	}
	return DONOTHING;
}
int into_myAnnounce()
{
        Personal("*");
        return FULLUPDATE;
}

int into_PAnnounce()
{
        Personal(NULL);
        return FULLUPDATE;
}

int Personal(char *userid)
{
   char    found[256], lookid[IDLEN+6];
   int     id; 
   
   if(!userid) {
      clear();
      move(2, 0);
      usercomplete( "뿴˭ĸļ: " , lookid);
      if (lookid[0] == '\0') {
         clear();
	 return 1;
      }
   }  else strcpy(lookid, userid);
   if(lookid[0] == '*'){
      sprintf(lookid,"/%c/%s",
         toupper(currentuser.userid[0]),currentuser.userid);
   } else {
      if (!(id = getuser(lookid))){
         lookid[1] = toupper(lookid[0]);
	 if(lookid[1] < 'A' || lookid[1] > 'Z')lookid[0] = '\0';
	 else {
	    lookid[0] = '/';
            lookid[2] = '\0';
	 }   
      } else {
         sprintf(lookid, "/%c/%s",
	    toupper(lookupuser.userid[0]),lookupuser.userid);
      }	    
   }
   sprintf(found,"0Announce/groups/GROUP_0/PersonalCorpus/%s",lookid);
   if(!dashd(found)) 
      sprintf(found,"0Announce/groups/GROUP_0/PersonalCorpus");
   a_menu("",found,((HAS_PERM(PERM_ANNOUNCE) || HAS_PERM(PERM_SYSOP)
                           || HAS_PERM(PERM_OBOARDS)) ? PERM_BOARDS : 0),0);
   return 1;
}

#ifdef INTERNET_EMAIL
int
forward_post(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	if (strcmp("guest", currentuser.userid) == 0)
		return DONOTHING;
	return (mail_forward(ent, fileinfo, direct));
}

int
forward_u_post(ent, fileinfo, direct)
int     ent;
struct fileheader *fileinfo;
char   *direct;
{
	if (strcmp("guest", currentuser.userid) == 0)
		return DONOTHING;
	return (mail_u_forward(ent, fileinfo, direct));
}
#endif

extern int 
mainreadhelp();
extern int b_vote();
extern int b_results();
extern int b_vote_maintain();
extern int b_notes_edit();
extern int Rangefunc();

struct one_key read_comms[] = {
	'_', underline_post,
	'w', makeDELETEDflag, 
        'Y', UndeleteArticle,
	'r', read_post,
	'K', skip_post,
//	'G', range_do,
/*	'u', skip_post, *//* Key 'u' use to query user's info */
	'd', del_post,
	'D', del_range,
	'm', mark_post,
	'E', edit_post,
	Ctrl('G'), acction_mode, 
	'`', acction_mode, 
	'g', digest_post,
	'T', edit_title,
	's', do_select,
	Ctrl('C'), do_cross,
	Ctrl('P'), do_post,
	'C', new_flag_clearto,	/* δǵǰλ */
	'c', new_flag_clear,  /* ȫδ */
#ifdef INTERNET_EMAIL
	'F', forward_post,
	'U', forward_u_post,
	Ctrl('R'), post_reply,
#endif
	'i', full_Save_post,
	'J', part_Save_post,
	'I', Import_post,
	'R', b_results,
	'v', b_vote,
	'V', b_vote_maintain,
//	'M', b_vote_maintain,
	'W', b_notes_edit,
	Ctrl('W'), b_notes_passwd,
	'h', mainreadhelp,
	Ctrl('J'), mainreadhelp,
	KEY_TAB, show_b_note,
	'z', show_b_secnote,
	'x', into_announce,
	'X', into_myAnnounce,
	Ctrl('X'), into_PAnnounce,
	'a', auth_search_down,
	'A', auth_search_up,
	'/', t_search_down,
	'?', t_search_up,
	'\'', post_search_down,
	'\"', post_search_up,
	']', thread_down,
	'[', thread_up,
	Ctrl('D'), deny_user,
#ifdef BOARD_CONTROL
	Ctrl('K'), control_user,
#endif	
	Ctrl('A'), show_author,
	Ctrl('N'), SR_first_new,
	'n', SR_first_new,
	'\\', SR_last,
	'=', SR_first,
	Ctrl('S'), SR_read,
	'p', SR_read,
	Ctrl('U'), SR_author,
	'b', SR_BMfunc,
	'B', Rangefunc,
	Ctrl('T'), acction_mode,
	't', thesis_mode,	/* youzi 1997.7.8 */
	'!', Q_Goodbye,
	'S', s_msg,
	'f', t_friends,
	'\0', NULL
};

int
Read()
{
	char    buf[STRLEN];
	char    notename[STRLEN];
	time_t  usetime;
	struct stat st;
	if (!selboard) {
		move(2, 0);
		prints("ѡ\n");
		pressreturn();
		move(2, 0);
		clrtoeol();
		return -1;
	}
	in_mail = NA;
	brc_initial(currboard);
	setbdir(buf, currboard);

	setvfile(notename, currboard, "notes");
	if (stat(notename, &st) != -1) {
		if (st.st_mtime < (time(NULL) - 7 * 86400)) {
			utimes(notename, NULL);
			setvfile(genbuf, currboard, "noterec");
			unlink(genbuf);
		}
	}
#ifdef ALWAYS_SHOW_BRDNOTE
	if (dashf(notename))
		ansimore3(notename, YEA);
#else
	if (vote_flag(currboard, '\0', 1 /* µı¼û */ ) == 0) {
		if (dashf(notename)) {
			ansimore3(notename, YEA);
			vote_flag(currboard, 'R', 1 /* дµı¼ */ );
		}
	}
#endif

#ifdef BOARD_CONTROL
	if(!HAS_PERM(PERM_SYSOP)&&!chk_currBM(currBM)){
	   setbfile(notename, currboard, "board.allow");
	   if(dashf(notename)&&!seek_in_file(notename,currentuser.userid)){
	      clear();
	      move(5,10);
	      prints("ܱǸ, 棬ǸðԱ");
	      pressanykey();
	      return 0;
	   }
	}   
#endif
#ifdef BOARD_READDENY
	if(!HAS_PERM(PERM_SYSOP)&&!chk_currBM(currBM)){
	   setbfile(notename, currboard, "board.deny");
	   if(dashf(notename)&&seek_in_file(notename,currentuser.userid)){
	      clear();
	      move(5,20);
	      prints("ԲĿǰֹͣ뱾Ȩ");
	      pressanykey();
	      return 0;
	   }	
	}	
#endif
	usetime = time(0);
	i_read(READING, buf, readtitle, readdoent, &read_comms[0], sizeof(struct fileheader));
	board_usage(currboard, time(0) - usetime);

	brc_update();
	return 0;
}
/*Add by SmallPig*/
void
notepad()
{
	char    tmpname[STRLEN], note1[4];
	char    note[3][STRLEN - 4];
	char    tmp[STRLEN];
	FILE   *in;
	int     i, n;
	time_t  thetime = time(0);
	extern int talkrequest;


	clear();
	move(0, 0);
	prints("ʼ԰ɣĿԴ....\n");
	modify_user_mode(WNOTEPAD);
	sprintf(tmpname, "tmp/notepad.%s.%05d", currentuser.userid, uinfo.pid);
	if ((in = fopen(tmpname, "w")) != NULL) {
		for (i = 0; i < 3; i++)
			memset(note[i], 0, STRLEN - 4);
		while (1) {
			for (i = 0; i < 3; i++) {
				getdata(1 + i, 0, ": ", note[i], STRLEN - 5, DOECHO, NA);
				if (note[i][0] == '\0')
					break;
			}
			if (i == 0) {
				fclose(in);
				unlink(tmpname);
				return;
			}
			getdata(5, 0, "ǷĴ԰ (Y)ǵ (N)Ҫ (E)ٱ༭ [Y]: ", note1, 3, DOECHO, YEA);
			if (note1[0] == 'e' || note1[0] == 'E')
				continue;
			else
				break;
		}
		if (note1[0] != 'N' && note1[0] != 'n') {
			sprintf(tmp, "[1;32m%s[37m%.18s", currentuser.userid, currentuser.username);

			fprintf(in, "[1;34m[44m[36m[32m[33m[31m[37m[34m[44m[m\n");
			getdatestring(thetime,NA);
			fprintf(in, "[1;34m[32;44m %-44s[32m [36m%23.23s[32m 뿪ʱµĻ  [m\n", tmp, datestring+6);
			for (n = 0; n < i; n++) {
				if (note[n][0] == '\0')
					break;
				fprintf(in, "[1;34m[33;44m %-75.75s[1;34m[m \n", note[n]);
			}
			fprintf(in,  "[1;34m[44m  [m \n");
			catnotepad(in, "etc/notepad");
			fclose(in);
			rename(tmpname, "etc/notepad");
		} else {
			fclose(in);
			unlink(tmpname);
		}
	}
	if (talkrequest) {
		talkreply();
	}
	clear();
	return;
}
/* youzi quick goodbye */
int
Q_Goodbye()
{
	extern int started;
	extern int *zapbuf;
	char    fname[STRLEN];
	int     logouts;
#ifdef ALLOWGAME
	extern int NowInGame;
#endif

	free(zapbuf);

	setuserfile(fname, "msgfile");

#ifdef LOG_MY_MESG
	unlink(fname);
	setuserfile(fname, "msgfile.me");
#endif

	/* edwardc.990423 ѶϢ */
	if (dashf(fname)) {
		clear();
		mesgmore(fname, NA, 0, 9999);
	}
	clear();
	prints("\n\n\n\n");

	setuserfile(fname, "notes");
	if (dashf(fname))
		ansimore(fname, YEA);

	setuserfile(fname, "logout");
	if (dashf(fname)) {
		logouts = countlogouts(fname);
		if (logouts >= 1) {
			user_display(fname,
				(logouts == 1) ? 1 : (currentuser.numlogins % (logouts)) + 1, YEA);
		}
	} else {
		if (fill_shmfile(2, "etc/logout", "GOODBYE_SHMKEY"))
			show_goodbyeshm();
	}
#ifdef ALLOWGAME
	if(NowInGame==YEA){
	   char inGame[STRLEN];
	   setuserfile(inGame,"inGame");
	   if(dashf(inGame)) unlink(inGame);
	}
#endif
	pressreturn(); // sunner Ľ
	report("exit");

	if (started) {
		time_t  stay;
		stay = time(0) - login_start_time;
		sprintf(genbuf, "Stay:%3ld (%s)", stay / 60, currentuser.username);
		log_usies("EXIT ", genbuf);
		u_exit();
	}
/*	{ char buf[200],path[80],*t;
 	setuserfile(path, ".lastread");
	t = strstr(path,".");
	*t = '\0';
	sprintf(buf,"cp %s/.lastread %s/.lastread.backup",path,path);
	system(buf);
        sprintf(buf,"cp %s/.boardrc %s/.boardrc.backup",path,path);
        system(buf);
	} 
*/
	//pressreturn();
#ifdef CHK_FRIEND_BOOK
	if (num_user_logins(currentuser.userid) == 0 &&
		strcmp(currentuser.userid, "guest")) {
		FILE   *fp;
		char    buf[STRLEN], *ptr;
		if ((fp = fopen("friendbook", "r")) != NULL) {
			while (fgets(buf, sizeof(buf), fp) != NULL) {
				char    uid[14];
				ptr = strstr(buf, "@");
				if (ptr == NULL) {
					del_from_file("friendbook", buf);
					continue;
				}
				ptr++;
				strcpy(uid, ptr);
				ptr = strstr(uid, "\n");
				*ptr = '\0';
				if (!strcmp(uid, currentuser.userid))
					del_from_file("friendbook", buf);
			}
			fclose(fp);
		}
	}
#endif
	sleep(1);
#ifndef BBSD	
	reset_tty();
#endif	
	exit(0);
	return -1;
}

int
Goodbye()
{
	char    sysoplist[20][15], syswork[20][21], buf[STRLEN];
	int     i, num_sysop, choose;
	FILE   *sysops;
	char	*ptr;
	*quote_file = '\0';
	i = 0;
	if ((sysops = fopen("etc/sysops", "r")) != NULL) {
		while (fgets(buf, STRLEN, sysops) != NULL && i <= 19) {
			if(buf[0]=='#')continue;
			ptr = strtok(buf," \n\r\t");
			if(ptr){
				strncpy(sysoplist[i],ptr,14);
				ptr = strtok(NULL, " \n\r\t");
				if(ptr){
					strncpy(syswork[i],ptr,20);
				} else strcpy(syswork[i],"[ְ]");
				i ++;
			}
		}
		fclose(sysops);
	}

	num_sysop = i;
	move(1, 0);
	alarm(0);
	clear();
	move(0, 0);
	prints("Ҫ뿪 %s ʲὨ\n", BoardName);
	prints("[[1;33m1[m] ŸԱ\n");
	prints("[[1;33m2[m] һҪ\n");
#ifdef USE_NOTEPAD
	if (strcmp(currentuser.userid, "guest") != 0) {
		prints("[[1;33m3[m] дд[1;32m[33m[35m[m\n");
	}
#endif
	prints("[[1;33m4[m][1;32m ѷϢ ;)[m\n");
	prints("[[1;33m5[m] ޣҪ뿪\n");
	sprintf(buf, "ѡ [[1;32m5[m]");
	getdata(8, 0, buf, genbuf, 4, DOECHO, YEA);
	clear();
	choose = genbuf[0] - '0';
	if (choose == 1) {
		prints("     վ ID       ְ \n");
		prints("     ============ =====================\n");
		for (i = 1; i <= num_sysop; i++) {
			prints("[[1;33m%2d[m] %-12s %s\n", i, sysoplist[i - 1]
				,syswork[i - 1]);
		}
		prints("[[1;33m%2d[m] ޣ\n",num_sysop + 1);
		sprintf(buf, "ѡ [[1;32m%d[m]", num_sysop + 1);
		getdata(num_sysop + 5, 0, buf, genbuf, 4, DOECHO, YEA);
		choose = atoi(genbuf);
		if (choose >= 1 && choose <= num_sysop)
			do_send(sysoplist[choose - 1], "ʹ߼Ľ");
		choose = -1;
	}
	if (choose == 2)
		return FULLUPDATE;
	if (strcmp(currentuser.userid, "guest") != 0) {
#ifdef USE_NOTEPAD
		if (HAS_PERM(PERM_POST) && choose == 3)
			notepad();
#endif
		if( choose == 4)
			friend_wall();
	}
	return Q_Goodbye();

}

void
do_report(filename,s)
char   *s,*filename;
{
	char    buf[512];
	time_t  dtime;
	time(&dtime);
	getdatestring(dtime,NA);
	sprintf(buf, "%s %16.16s %s\n", currentuser.userid, datestring+6, s);
	file_append(filename, buf);
}
void 
report(s)
char	*s;
{
	do_report("trace",s);
}

void
gamelog(s)
char 	*s;
{
	do_report("game/trace",s);
}

void
board_usage(mode, usetime)
char   *mode;
time_t  usetime;
{
        #ifndef TIMECOUNTER
	time_t  now;
        #endif
	char    buf[256];
	#ifndef TIMECOUNTER
	now = time(0);
	getdatestring(now,NA);
	#else
	getnowdatestring();
	#endif
	sprintf(buf, "%.22s USE %-20.20s Stay: %5ld (%s)\n", datestring, mode, usetime, currentuser.userid);
	file_append("use_board", buf);
}


int
Info()
{
	modify_user_mode(XMENU);
	ansimore("Version.Info", YEA);
	clear();
	return 0;
}

int
Conditions()
{
	modify_user_mode(XMENU);
	ansimore("COPYING", YEA);
	clear();
	return 0;
}

int
Welcome()
{
	char    ans[3];
	modify_user_mode(XMENU);
	if (!dashf("Welcome2"))
		ansimore("Welcome", YEA);
	else {
		clear();
		stand_title("ۿվ");
		for (;;) {
			getdata(1, 0, "(1)վ  (2)վվ ? : ",
				ans, 2, DOECHO, YEA);

/* skyo.990427 modify   Enter   */
			if (ans[0] == '\0') {
				clear();
				return 0;
			}
			if (ans[0] == '1' || ans[0] == '2')
				break;
		}
		if (ans[0] == '1')
			ansimore("Welcome", YEA);
		else
			ansimore("Welcome2", YEA);
	}
	clear();
	return 0;
}

int
cmpbnames(bname, brec)
char   *bname;
struct fileheader *brec;
{
	if (!ci_strncmp(bname, brec->filename, sizeof(brec->filename)))
		return 1;
	else
		return 0;
}

void cancelpost(char *board, char *userid, struct fileheader *fh, int owned)
{
   struct fileheader postfile;
   FILE   *fin, *fout;
   char    from[STRLEN], path[STRLEN];
   char    fname[STRLEN], *ptr, *brd;
   int     len, count;
   time_t  now;
   
   setbfile(genbuf, board, fh->filename);
   if ((fin = fopen(genbuf, "r")) != NULL) {
      brd = (owned) ? "junk" : "deleted";
      now = time(0);
      sprintf(fname, "M.%d.A", now);
      setbfile(genbuf, brd, fname);
      count = 0;
      while (dashf(genbuf)) {
         now++;
	 sprintf(fname, "M.%d.A", now);
	 setbfile(genbuf, brd, fname);
	 if (count++ > MAX_POSTRETRY){
	    fclose(fin);
	    return;
	 }   
      }
      if ((fout = fopen(genbuf, "w")) != NULL) {
         memset(&postfile, 0, sizeof(postfile));
	 sprintf(genbuf, "%-32.32s - %s", fh->title, userid);
	 strcpy(postfile.filename, fname);
	 strncpy(postfile.owner, fh->owner, IDLEN + 2);
	 strncpy(postfile.title, genbuf, STRLEN);
	 postfile.filename[STRLEN - 1] = 'D';
	 postfile.filename[STRLEN - 2] = 'D';
      }
      from[0] = '\0';
      while (fgets(genbuf, sizeof(genbuf), fin) != NULL) {
         if (fout != NULL) {
	    fputs(genbuf, fout);
	 }
	 len = strlen(genbuf) - 1;
	 genbuf[len] = '\0';
	 if (len <= 8) {
	    break;
	 } else if (strncmp(genbuf, ": ", 8) == 0) {
	    if ((ptr = strrchr(genbuf, ')')) != NULL) {
	       *ptr = '\0';
	       if ((ptr = strrchr(genbuf, '(')) != NULL)
	          strcpy(from, ptr + 1);
	    }
	 } else if (strncmp(genbuf, "תվ: ", 8) == 0) {
	    strncpy(path, genbuf + 8, sizeof(path));
	    path[sizeof(path) - 1] = '\0';
	 }
      }
      if (fout != NULL) {
         while (fgets(genbuf, sizeof(genbuf), fin) != NULL)
	    fputs(genbuf, fout);
      }
      fclose(fin);
      if (fout != NULL) {
         fclose(fout);
	 setbdir(genbuf, brd);
	 append_record(genbuf, &postfile, sizeof(postfile));
      }
      if (strrchr(fh->owner, '.')) return;
      if((fh->filename[STRLEN - 1] == 'S') && (fh->filename[STRLEN - 2] == 'S')
         && (atoi(fh->filename + 2) > now - 14 * 86400)) {
         sprintf(genbuf, "%s\t%s\t%s\t%s\t%s\n",
	    board, fh->filename, fh->owner, from, fh->title);
	 if ((fin = fopen("innd/cancel.bntp", "a")) != NULL) {
	    fputs(genbuf, fin);
	    fclose(fin);
	 }
      }
   }
}

int 
thesis_mode()
{
	int     id;    //, i;
	unsigned int pbits;
	//i = 'W' - 'A';
	id = getuser(currentuser.userid);
	pbits = lookupuser.userdefine;
	//pbits ^= (1 << i);
	pbits ^= DEF_THESIS;
	lookupuser.userdefine = pbits;
	currentuser.userdefine = pbits;
	substitute_record(PASSFILE, &lookupuser, sizeof(struct userec), id);
	update_utmp();
	return FULLUPDATE;
}
#ifdef BACKUP_RANGE_DELETE
/* add by quickmouse 2000.5.27 */
int NotBackupBoard(void)
{
   if(!strcmp(currboard,"junk") || !strcmp(currboard,"deleted")) return 1;
   return seek_in_file("etc/notbackupboards",currboard);
}
/* end of add */
#endif
/* Add by everlove 07/08/2001 ϼ */
Add_Combine(board,fileinfo)
char *board;
struct fileheader *fileinfo;
{
  FILE *fp;
  char buf[STRLEN];
  char temp2[1024];

  sprintf(buf,"tmp/%s.combine",currentuser.userid);
  fp=fopen(buf,"at");
  fprintf(fp,"[1;32m[0;1m\n");
   {
    FILE *fp1;
    char buf[80];
    char *s_ptr,*e_ptr;
    int blankline=0;

    setbfile(buf,board,fileinfo->filename);
    fp1=fopen(buf,"rt");
    if (fgets(temp2, 256, fp1)!=NULL)
      {
        e_ptr=strchr(temp2,',');
        if (e_ptr!=NULL) *e_ptr='\0';
          s_ptr=&temp2[7];
         fprintf(fp, "    [0;1;32m%s [0;1m",s_ptr);
        }
    fgets(temp2, 256, fp1);
    if (fgets(temp2, 256, fp1)!=NULL)
      {
      e_ptr=strchr(temp2,',');
         if (e_ptr!=NULL) *(--e_ptr)='\0';
             s_ptr=strchr(temp2,'(');
         if (s_ptr==NULL) s_ptr=temp2;
              else s_ptr++;
      fprintf(fp, " [1;36m%s[0;1m ᵽ\n",s_ptr);
      }
    while (!feof(fp1)) {
      fgets(temp2, 256, fp1);
      if ((unsigned)*temp2<'\x1b'){ if (blankline) continue; else blankline=1; }
        else blankline=0;
      if ((strstr(temp2, ""))|| + (*temp2==':')) continue;
      if (strncmp(temp2,"--",2)==0) break;
      fputs(temp2, fp);
      }
    fclose(fp1);
   }
  fprintf(fp,"\n" );
  fclose(fp);
}
/* The End */
/*Add by everlove ʮʾ */
int if_exist_title(char *title) {
        static struct {
                int hash_ip;
                char title[64][60];
        } my_posts;
        char buf1[256];
        int n;
        FILE *fp;
        sethomefile(buf1, currentuser.userid, "my_posts");
        fp=fopen(buf1, "r+");
        if(fp==NULL) fp=fopen(buf1, "w+");
        fread(&my_posts, sizeof(my_posts), 1, fp);
        for(n=0; n<64; n++)
                if(!strncmp(my_posts.title[n], title, 50)) {
                        fclose(fp);
                        return 1;
                };
        my_posts.hash_ip = (my_posts.hash_ip+1) & 63;
        strncpy(my_posts.title[my_posts.hash_ip], title, 50);
        fseek(fp, 0, SEEK_SET);
        fwrite(&my_posts, sizeof(my_posts), 1, fp);
        fclose(fp);
        return 0;
}

